/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.item.tools;

import codechicken.lib.math.MathHelper;
import codechicken.lib.raytracer.RayTracer;
import com.google.common.collect.Sets;
import java.util.Set;
import morph.avaritia.Avaritia;
import morph.avaritia.entity.EntityImmortalItem;
import morph.avaritia.handler.AvaritiaEventHandler;
import morph.avaritia.init.ModItems;
import morph.avaritia.util.ToolHelper;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPickaxeInfinity
extends ItemPickaxe {
    private static final Item.ToolMaterial TOOL_MATERIAL = EnumHelper.addToolMaterial((String)"INFINITY_PICKAXE", (int)32, (int)9999, (float)9999.0f, (float)6.0f, (int)200);
    public static final Set<Material> MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.field_151576_e, Material.field_151573_f, Material.field_151588_w, Material.field_151592_s, Material.field_76233_E, Material.field_151574_g, Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z, Material.field_151571_B});

    public ItemPickaxeInfinity() {
        super(TOOL_MATERIAL);
        this.func_77655_b("avaritia:infinity_pickaxe");
        this.setRegistryName("infinity_pickaxe");
        this.func_77637_a(Avaritia.tab);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack pick = new ItemStack((Item)this);
            pick.func_77966_a(Enchantments.field_185308_t, 10);
            list.add((Object)pick);
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return ModItems.COSMIC_RARITY;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("hammer")) {
            return 5.0f;
        }
        for (String type : this.getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return this.field_77864_a;
        }
        return Math.max(super.func_150893_a(stack, state), 6.0f);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            NBTTagCompound tags = stack.func_77978_p();
            if (tags == null) {
                tags = new NBTTagCompound();
                stack.func_77982_d(tags);
            }
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack) < 10) {
                stack.func_77966_a(Enchantments.field_185308_t, 10);
            }
            tags.func_74757_a("hammer", !tags.func_74767_n("hammer"));
            player.func_184609_a(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase victim, EntityLivingBase player) {
        if (!(stack.func_77978_p() == null || !stack.func_77978_p().func_74767_n("hammer") || victim instanceof EntityPlayer && AvaritiaEventHandler.isInfinite((EntityPlayer)victim))) {
            int i = 10;
            victim.func_70024_g(-MathHelper.sin((double)(player.field_70177_z * (float)Math.PI / 180.0f)) * (double)i * 0.5, 2.0, MathHelper.cos((double)(player.field_70177_z * (float)Math.PI / 180.0f)) * (double)i * 0.5);
        }
        return true;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        RayTraceResult traceResult;
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("hammer") && (traceResult = RayTracer.retrace((EntityPlayer)player, (double)10.0, (boolean)true)) != null) {
            this.breakOtherBlock(player, stack, pos, traceResult.field_178784_b);
        }
        return false;
    }

    public void breakOtherBlock(EntityPlayer player, ItemStack stack, BlockPos pos, EnumFacing sideHit) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        Material mat = state.func_185904_a();
        if (!MATERIALS.contains(mat)) {
            return;
        }
        if (state.func_177230_c().isAir(state, (IBlockAccess)world, pos)) {
            return;
        }
        boolean doY = sideHit.func_176740_k() != EnumFacing.Axis.Y;
        int range = 8;
        BlockPos minOffset = new BlockPos(-range, doY ? -1 : -range, -range);
        BlockPos maxOffset = new BlockPos(range, doY ? range * 2 - 2 : range, range);
        ToolHelper.aoeBlocks(player, stack, world, pos, minOffset, maxOffset, null, MATERIALS, true);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityImmortalItem(world, location, itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }
}

