/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels.content;

import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.resources.textures.ColorTexture;
import betterquesting.api2.client.gui.resources.textures.ItemTexture;
import betterquesting.api2.client.gui.resources.textures.LayeredTexture;
import betterquesting.api2.client.gui.resources.textures.OreDictTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.core.BetterQuesting;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.Focus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Optional;
import org.lwjgl.input.Keyboard;

public class PanelItemSlot
extends PanelButtonStorage<BigItemStack> {
    private final boolean showCount;
    private final boolean oreDict;
    private final List<BigItemStack> oreVariants = new ArrayList<BigItemStack>();

    public PanelItemSlot(IGuiRect rect, int id, BigItemStack value) {
        this(rect, id, value, false, false);
    }

    public PanelItemSlot(IGuiRect rect, int id, BigItemStack value, boolean showCount) {
        this(rect, id, value, showCount, false);
    }

    public PanelItemSlot(IGuiRect rect, int id, BigItemStack value, boolean showCount, boolean oreDict) {
        super(rect, id, "", value);
        this.showCount = showCount;
        this.oreDict = oreDict;
        this.setTextures(PresetTexture.ITEM_FRAME.getTexture(), PresetTexture.ITEM_FRAME.getTexture(), new LayeredTexture(PresetTexture.ITEM_FRAME.getTexture(), new ColorTexture(PresetColor.ITEM_HIGHLIGHT.getColor(), new GuiPadding(1, 1, 1, 1))));
        this.setStoredValue(value);
    }

    public PanelItemSlot setStoredValue(BigItemStack value) {
        super.setStoredValue(value);
        if (value != null) {
            Minecraft mc = Minecraft.func_71410_x();
            this.setIcon(this.oreDict || value.getBaseStack().func_77952_i() == Short.MAX_VALUE ? new OreDictTexture(1.0f, value, this.showCount, true) : new ItemTexture(value, this.showCount, true), 1);
            this.setTooltip(value.getBaseStack().func_82840_a((EntityPlayer)mc.field_71439_g, (ITooltipFlag)(mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)));
        } else {
            this.setIcon(null);
            this.setTooltip(null);
        }
        this.updateOreStacks();
        return this;
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        if (this.getStoredValue() != null && this.isHovered()) {
            BigItemStack ttStack = (BigItemStack)this.getStoredValue();
            if (this.oreDict && this.oreVariants.size() > 0) {
                ttStack = this.oreVariants.get((int)((double)System.currentTimeMillis() / 1000.0) % this.oreVariants.size());
            }
            Minecraft mc = Minecraft.func_71410_x();
            return ttStack.getBaseStack().func_82840_a((EntityPlayer)mc.field_71439_g, (ITooltipFlag)(mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        }
        return null;
    }

    private void updateOreStacks() {
        if (this.oreVariants == null) {
            return;
        }
        this.oreVariants.clear();
        BigItemStack stack = (BigItemStack)this.getStoredValue();
        if (stack == null) {
            return;
        }
        if (!stack.hasOreDict()) {
            if (stack.getBaseStack().func_77952_i() == Short.MAX_VALUE) {
                NonNullList subItems = NonNullList.func_191196_a();
                stack.getBaseStack().func_77973_b().func_150895_a(CreativeTabs.field_78027_g, subItems);
                subItems.forEach(is -> {
                    BigItemStack bis = new BigItemStack((ItemStack)is);
                    bis.stackSize = stack.stackSize;
                    this.oreVariants.add(bis);
                });
            } else {
                this.oreVariants.add(stack);
            }
            return;
        }
        for (ItemStack iStack : stack.getOreIngredient().func_193365_a()) {
            if (iStack.func_77952_i() == Short.MAX_VALUE) {
                NonNullList subItems = NonNullList.func_191196_a();
                iStack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, subItems);
                for (ItemStack sStack : subItems) {
                    BigItemStack bStack = new BigItemStack(sStack);
                    bStack.stackSize = stack.stackSize;
                    this.oreVariants.add(bStack);
                }
                continue;
            }
            BigItemStack bStack = new BigItemStack(iStack);
            bStack.stackSize = stack.stackSize;
            this.oreVariants.add(bStack);
        }
    }

    @Override
    public void onButtonClick() {
        if (this.getCallback() != null) {
            this.getCallback().setValue((BigItemStack)this.getStoredValue());
        } else if (BetterQuesting.hasJEI && this.getStoredValue() != null) {
            this.lookupRecipe(((BigItemStack)this.getStoredValue()).getBaseStack(), true);
        }
    }

    @Override
    public void onRightButtonClick() {
        if (this.getCallback() != null) {
            this.getCallback().setValue((BigItemStack)this.getStoredValue());
        } else if (BetterQuesting.hasJEI && this.getStoredValue() != null) {
            this.lookupRecipe(((BigItemStack)this.getStoredValue()).getBaseStack(), false);
        }
    }

    @Override
    public boolean onKeyTyped(char c, int keycode) {
        if (!BetterQuesting.hasJEI) {
            return false;
        }
        if (!Keyboard.getEventKeyState()) {
            return false;
        }
        if (!this.isHovered()) {
            return false;
        }
        if (this.getStoredValue() == null) {
            return false;
        }
        boolean showRecipe = KeyBindings.showRecipe.isActiveAndMatches(keycode);
        boolean showUses = KeyBindings.showUses.isActiveAndMatches(keycode);
        if (showRecipe || showUses) {
            this.lookupRecipe(((BigItemStack)this.getStoredValue()).getBaseStack(), showRecipe);
            return true;
        }
        return false;
    }

    @Optional.Method(modid="jei")
    public void lookupRecipe(ItemStack stack, boolean showRecipe) {
        if (stack == null || stack.func_190926_b() || Internal.getRuntime() == null) {
            return;
        }
        IFocus.Mode mode = showRecipe ? IFocus.Mode.OUTPUT : IFocus.Mode.INPUT;
        Internal.getRuntime().getRecipesGui().show((IFocus)new Focus(mode, (Object)stack));
    }
}

