/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.resources.textures;

import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.resources.textures.ItemTexture;
import betterquesting.api2.client.gui.resources.textures.SlideShowTexture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class OreDictTexture
extends SlideShowTexture {
    public OreDictTexture(float interval, BigItemStack stack, boolean showCount, boolean keepAspect) {
        super(interval, OreDictTexture.splitOreTextures(stack, showCount, keepAspect).toArray(new ItemTexture[0]));
    }

    public OreDictTexture(float interval, Collection<BigItemStack> list, boolean showCount, boolean keepAspect) {
        super(interval, OreDictTexture.buildTextures(list, showCount, keepAspect).toArray(new ItemTexture[0]));
    }

    private static List<ItemTexture> buildTextures(Collection<BigItemStack> subItems, boolean showCount, boolean keepAspect) {
        ArrayList<ItemTexture> list = new ArrayList<ItemTexture>();
        subItems.forEach(is -> list.add(new ItemTexture((BigItemStack)is, showCount, keepAspect)));
        return list;
    }

    private static List<ItemTexture> splitOreTextures(BigItemStack stack, boolean showCount, boolean keepAspect) {
        ArrayList<ItemTexture> list = new ArrayList<ItemTexture>();
        if (!stack.hasOreDict()) {
            if (stack.getBaseStack().func_77952_i() == Short.MAX_VALUE) {
                NonNullList subItems = NonNullList.func_191196_a();
                stack.getBaseStack().func_77973_b().func_150895_a(CreativeTabs.field_78027_g, subItems);
                subItems.forEach(is -> {
                    BigItemStack bis = new BigItemStack((ItemStack)is);
                    bis.stackSize = stack.stackSize;
                    list.add(new ItemTexture(bis, showCount, keepAspect));
                });
            } else {
                list.add(new ItemTexture(stack, showCount, keepAspect));
            }
            return list;
        }
        for (ItemStack iStack : stack.getOreIngredient().func_193365_a()) {
            if (iStack.func_77952_i() == Short.MAX_VALUE) {
                NonNullList subItems = NonNullList.func_191196_a();
                iStack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, subItems);
                for (ItemStack sStack : subItems) {
                    BigItemStack bStack = new BigItemStack(sStack);
                    bStack.stackSize = stack.stackSize;
                    list.add(new ItemTexture(bStack, showCount, keepAspect));
                }
                continue;
            }
            BigItemStack bStack = new BigItemStack(iStack);
            bStack.stackSize = stack.stackSize;
            list.add(new ItemTexture(bStack, showCount, keepAspect));
        }
        return list;
    }
}

