/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.supporter;

import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.supporter.mc_link.McLinkEndpoint;
import betterquesting.core.BetterQuesting;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nonnull;

public class MCLinkAPI {
    private static final String MCL_TOKEN = "Yo1nkbXn7uVptLoL3GpkAaT7HsU8QFGJ";
    private static String userAgent = null;

    @Nonnull
    public JsonObject getApiStatus() {
        return new JsonObject();
    }

    public void updateSupporterInfo(@Nonnull Collection<UUID> playerIDs, Collection<String> tokens) {
        JsonObject jsonBase = new JsonObject();
        JsonObject jsonTokens = new JsonObject();
        JsonObject jsonServices = new JsonObject();
        JsonArray teirArgs = new JsonArray();
        teirArgs.add((Number)0);
        jsonServices.add("Patreon", (JsonElement)teirArgs);
        jsonServices.add("Twitch", (JsonElement)new JsonArray());
        tokens.forEach(key -> jsonTokens.add(key, (JsonElement)jsonServices));
        jsonBase.add("tokens", (JsonElement)jsonTokens);
        JsonArray jsonIds = new JsonArray();
        playerIDs.forEach(id -> jsonIds.add(id.toString()));
        jsonBase.add("uuids", (JsonElement)jsonIds);
        try {
            JsonElement jsonElement = MCLinkAPI.sendJsonPost(McLinkEndpoint.API_AUTH.URL, (JsonElement)jsonBase);
        }
        catch (Exception e) {
            BetterQuesting.logger.error("Unable to lookup supporter info", (Throwable)e);
        }
    }

    private static JsonElement sendJsonPost(String endpoint, JsonElement json) throws IOException {
        HttpURLConnection con;
        if (userAgent == null) {
            MCLinkAPI.setupMetadata();
        }
        URL url = new URL(endpoint);
        String redirect = url.toString();
        do {
            url = new URL(url, redirect);
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setInstanceFollowRedirects(true);
            con.setAllowUserInteraction(false);
            con.setConnectTimeout(30000);
            con.setReadTimeout(30000);
            con.setDoOutput(true);
            con.setRequestProperty("User-Agent", userAgent);
            con.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.name());
            con.setRequestProperty("Accept", "application/json");
            con.setRequestProperty("Content-Type", "application/json; charset=" + StandardCharsets.UTF_8.name());
            try (OutputStreamWriter osw = new OutputStreamWriter(con.getOutputStream(), StandardCharsets.UTF_8);){
                JsonHelper.GSON.toJson(json, (Appendable)osw);
                osw.flush();
                redirect = con.getHeaderField("Location");
            }
        } while (redirect != null && con.getResponseCode() / 100 == 3);
        InputStream is = con.getErrorStream();
        if (is == null) {
            is = con.getInputStream();
        }
        try (InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);){
            JsonElement jsonOut = (JsonElement)JsonHelper.GSON.fromJson((Reader)isr, JsonElement.class);
            JsonElement jsonElement = jsonOut != null ? jsonOut : new JsonObject();
            return jsonElement;
        }
    }

    private static void setupMetadata() {
        String modVersion = "4.2.2".equalsIgnoreCase("@VERSION@") ? "DEV" : "4.2.2";
        String mcVersion = "1.12.2";
        String branding = "Forge";
        StringBuilder sb = new StringBuilder("Better Questing Unofficial");
        sb.append('/').append(modVersion.replaceAll("[;()\n\r]", ""));
        sb.append(" (APIv").append(1).append("; ");
        sb.append("MCv").append(mcVersion.replaceAll("[;()\n\r]", "")).append("; ");
        sb.append(branding.replaceAll("[;()\n\r]", "")).append("; ");
        String os = System.getProperty("os.name") + ' ' + System.getProperty("os.arch") + ' ' + System.getProperty("os.version");
        sb.append(os.replaceAll("[;()\n\r]", ""));
        userAgent = sb.append(')').toString();
    }
}

