/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.editors.tasks;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.controls.PanelTextField;
import betterquesting.api2.client.gui.controls.filters.FieldFilterString;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.resources.textures.ItemTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.editors.tasks.CanvasAdvancementSearch;
import betterquesting.questing.tasks.TaskAdvancement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class GuiEditTaskAdvancement
extends GuiScreenCanvas
implements IVolatileScreen {
    private final DBEntry<IQuest> quest;
    private final TaskAdvancement task;
    private ResourceLocation selected;
    private static final ResourceLocation QUEST_EDIT = new ResourceLocation("betterquesting", "quest_edit");

    public GuiEditTaskAdvancement(GuiScreen parent, DBEntry<IQuest> quest, TaskAdvancement task) {
        super(parent);
        this.quest = quest;
        this.task = task;
        this.selected = task.advID;
    }

    @Override
    public void initPanel() {
        super.initPanel();
        Keyboard.enableRepeatEvents((boolean)true);
        CanvasTextured cvBackground = new CanvasTextured(new GuiTransform(), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBackground);
        cvBackground.addPanel(new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(16, 16, 16, -32), 0), QuestTranslation.translate("bq_standard.title.edit_advancement", new Object[0])).setAlignment(1).setColor(PresetColor.TEXT_HEADER.getColor()));
        CanvasAdvancementSearch cvAdvList = new CanvasAdvancementSearch(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(16, 48, 24, 24), 0), this.field_146297_k.field_71439_g.field_71174_a.func_191982_f().func_194229_a()){
            private final List<PanelButtonStorage<Advancement>> btnList;
            {
                this.btnList = new ArrayList<PanelButtonStorage<Advancement>>();
            }

            @Override
            public void refreshSearch() {
                super.refreshSearch();
                this.btnList.clear();
            }

            @Override
            protected boolean addResult(Advancement entry, int index, int cachedWidth) {
                DisplayInfo disp = entry.func_192068_c();
                this.addPanel(new PanelGeneric(new GuiRectangle(0, index * 24, 24, 24, 0), PresetTexture.ITEM_FRAME.getTexture()));
                if (disp != null) {
                    this.addPanel(new PanelGeneric(new GuiRectangle(0, index * 24, 24, 24, -1), new ItemTexture(new BigItemStack(disp.func_192298_b()))));
                }
                PanelButtonStorage<Advancement> btnAdv = new PanelButtonStorage<Advancement>(new GuiRectangle(24, index * 24, cachedWidth - 24, 24, 0), -1, disp != null ? disp.func_192297_a().func_150254_d() : entry.func_192067_g().toString(), entry);
                btnAdv.setActive(!entry.func_192067_g().equals((Object)GuiEditTaskAdvancement.this.selected));
                btnAdv.setCallback(value -> {
                    GuiEditTaskAdvancement.this.selected = value.func_192067_g();
                    for (PanelButtonStorage<Advancement> b : this.btnList) {
                        b.setActive(!b.getStoredValue().func_192067_g().equals((Object)GuiEditTaskAdvancement.this.selected));
                    }
                });
                if (disp != null) {
                    btnAdv.setTooltip(RenderUtils.splitString(disp.func_193222_b().func_150254_d(), 128, GuiEditTaskAdvancement.this.field_146297_k.field_71466_p));
                }
                this.addPanel(btnAdv);
                this.btnList.add(btnAdv);
                return true;
            }
        };
        cvBackground.addPanel(cvAdvList);
        PanelVScrollBar scAdv = new PanelVScrollBar(new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-24, 48, 16, 24), 0));
        cvBackground.addPanel(scAdv);
        cvAdvList.setScrollDriverY(scAdv);
        PanelTextField<String> tfSearch = new PanelTextField<String>(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(16, 32, 16, -48), 0), "", FieldFilterString.INSTANCE);
        tfSearch.setWatermark("Search...");
        cvBackground.addPanel(tfSearch);
        tfSearch.setCallback(cvAdvList::setSearchFilter);
        cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), -1, QuestTranslation.translate("gui.done", new Object[0])){

            @Override
            public void onButtonClick() {
                GuiEditTaskAdvancement.this.sendChanges();
                GuiEditTaskAdvancement.this.field_146297_k.func_147108_a(GuiEditTaskAdvancement.this.parent);
            }
        });
    }

    private void sendChanges() {
        this.task.advID = this.selected;
        NBTTagCompound payload = new NBTTagCompound();
        NBTTagList dataList = new NBTTagList();
        NBTTagCompound entry = new NBTTagCompound();
        entry.func_74768_a("questID", this.quest.getID());
        entry.func_74782_a("config", (NBTBase)this.quest.getValue().writeToNBT(new NBTTagCompound()));
        dataList.func_74742_a((NBTBase)entry);
        payload.func_74782_a("data", (NBTBase)dataList);
        payload.func_74768_a("action", 0);
        QuestingAPI.getAPI(ApiReference.PACKET_SENDER).sendToServer(new QuestingPacket(QUEST_EDIT, payload));
    }
}

