/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.core;

import betterquesting.api.placeholders.EntityPlaceholder;
import betterquesting.api.placeholders.FluidPlaceholder;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.blocks.BlockSubmitStation;
import betterquesting.blocks.TileSubmitStation;
import betterquesting.client.CreativeTabQuesting;
import betterquesting.commands.BQ_CommandAdmin;
import betterquesting.commands.BQ_CommandDebug;
import betterquesting.commands.BQ_CommandUser;
import betterquesting.commands.BQ_CopyProgress;
import betterquesting.commands.bqs.BQS_Commands;
import betterquesting.commands.bqs.BqsComDumpAdvancements;
import betterquesting.core.proxies.CommonProxy;
import betterquesting.handlers.ConfigHandler;
import betterquesting.handlers.LootSaveLoad;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.items.ItemExtraLife;
import betterquesting.items.ItemGuideBook;
import betterquesting.items.ItemLootChest;
import betterquesting.items.ItemQuestBook;
import betterquesting.network.PacketQuesting;
import betterquesting.network.PacketTypeRegistry;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="betterquesting", version="4.2.2", name="Better Questing Unofficial", guiFactory="betterquesting.handlers.ConfigGuiFactory")
public class BetterQuesting {
    public static final String VERSION = "4.2.2";
    public static final String FORMAT = "2.0.0";
    public static final String MODID_STD = "bq_standard";
    public static boolean hasJEI = false;
    private static final String MCL_API = "Yo1nkbXn7uVptLoL3GpkAaT7HsU8QFGJ";
    @Mod.Instance(value="betterquesting")
    public static BetterQuesting instance;
    @SidedProxy(clientSide="betterquesting.core.proxies.ClientProxy", serverSide="betterquesting.core.proxies.CommonProxy")
    public static CommonProxy proxy;
    public SimpleNetworkWrapper network;
    public static Logger logger;
    public static CreativeTabs tabQuesting;
    public static Item extraLife;
    public static Item guideBook;
    public static Item lootChest;
    public static Item questBook;
    public static Block submitStation;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel("BQ_NET_CHAN");
        ConfigHandler.config = new Configuration(event.getSuggestedConfigurationFile(), true);
        ConfigHandler.initConfigs();
        proxy.registerHandlers();
        PacketTypeRegistry.INSTANCE.init();
        this.network.registerMessage(PacketQuesting.HandleClient.class, PacketQuesting.class, 0, Side.CLIENT);
        this.network.registerMessage(PacketQuesting.HandleServer.class, PacketQuesting.class, 0, Side.SERVER);
        CapabilityProviderQuestCache.register();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FluidRegistry.registerFluid((Fluid)FluidPlaceholder.fluidPlaceholder);
        GameRegistry.registerTileEntity(TileSubmitStation.class, (ResourceLocation)new ResourceLocation("betterquesting", "submit_station"));
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("betterquesting", "placeholder"), EntityPlaceholder.class, (String)"placeholder", (int)0, (Object)this, (int)16, (int)1, (boolean)false);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        hasJEI = Loader.isModLoaded((String)"jei");
        proxy.registerExpansion();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        ICommandManager command = server.func_71187_D();
        ServerCommandManager manager = (ServerCommandManager)command;
        manager.func_71560_a((ICommand)new BQ_CommandAdmin());
        manager.func_71560_a((ICommand)new BQ_CommandUser());
        manager.func_71560_a((ICommand)new BQ_CopyProgress());
        manager.func_71560_a((ICommand)new BQS_Commands());
        manager.func_71560_a((ICommand)new BqsComDumpAdvancements());
        if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            manager.func_71560_a((ICommand)new BQ_CommandDebug());
        }
        SaveLoadHandler.INSTANCE.loadDatabases(server);
        LootSaveLoad.INSTANCE.LoadLoot(event.getServer());
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
        SaveLoadHandler.INSTANCE.unloadDatabases();
        LootSaveLoad.INSTANCE.UnloadLoot();
    }

    static {
        tabQuesting = new CreativeTabQuesting();
        extraLife = new ItemExtraLife();
        guideBook = new ItemGuideBook();
        lootChest = new ItemLootChest();
        questBook = new ItemQuestBook();
        submitStation = new BlockSubmitStation();
    }
}

