/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.misc;

import betterquesting.core.BetterQuesting;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.ResourcePackFileNotFoundException;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class QuestResourcesFolder
implements IResourcePack {
    private static final ResourceLocation UNKNOWN_PACK_TEXTURE = new ResourceLocation("textures/misc/unknown_pack.png");
    private static final File rootFolder = new File("config/betterquesting/resources/");
    private BufferedImage bufferedImage = null;

    @Nonnull
    public InputStream func_110590_a(@Nonnull ResourceLocation location) throws IOException {
        if (!this.func_110589_b(location)) {
            throw new ResourcePackFileNotFoundException(rootFolder, location.toString());
        }
        return new FileInputStream(new File(rootFolder.getPath() + "/" + location.func_110624_b(), location.func_110623_a()));
    }

    public boolean func_110589_b(@Nonnull ResourceLocation location) {
        File res = new File(rootFolder.getPath() + "/" + location.func_110624_b(), location.func_110623_a());
        return res.exists();
    }

    @Nonnull
    public Set<String> func_110587_b() {
        if (!rootFolder.exists() && !rootFolder.mkdirs()) {
            return Collections.emptySet();
        }
        String[] content = rootFolder.list();
        if (content == null || content.length <= 0) {
            return Collections.emptySet();
        }
        HashSet<String> folders = new HashSet<String>();
        for (String s : content) {
            File f = new File(rootFolder, s);
            if (!f.exists() || !f.isDirectory()) continue;
            if (!f.getName().equals(f.getName().toLowerCase())) {
                this.logNameNotLowercase(f.getName(), f.toString());
                continue;
            }
            folders.add(f.getName());
        }
        return folders;
    }

    public <T extends IMetadataSection> T func_135058_a(@Nonnull MetadataSerializer meta, @Nonnull String s) {
        return null;
    }

    @Nonnull
    public BufferedImage func_110586_a() {
        if (this.bufferedImage != null) {
            return this.bufferedImage;
        }
        try {
            this.bufferedImage = TextureUtil.func_177053_a((InputStream)Minecraft.func_71410_x().func_110442_L().func_110536_a(UNKNOWN_PACK_TEXTURE).func_110527_b());
        }
        catch (IOException ioexception) {
            throw new Error("Couldn't bind resource pack icon", ioexception);
        }
        return this.bufferedImage;
    }

    @Nonnull
    public String func_130077_b() {
        return "Better Questing Unofficial_folders";
    }

    private void logNameNotLowercase(String name, String file) {
        BetterQuesting.logger.log(Level.WARN, "ResourcePack: ignored non-lowercase namespace: {} in {}", new Object[]{name, file});
    }
}

