/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.network.QuestingPacket;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeRegistry;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NetCacheSync {
    private static final ResourceLocation ID_NAME = new ResourceLocation("betterquesting", "cache_sync");

    public static void registerHandler() {
        if (BetterQuesting.proxy.isClient()) {
            PacketTypeRegistry.INSTANCE.registerClientHandler(ID_NAME, NetCacheSync::onClient);
        }
    }

    public static void sendSync(@Nonnull EntityPlayerMP player) {
        QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc == null) {
            return;
        }
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74782_a("data", (NBTBase)qc.serializeNBT());
        PacketSender.INSTANCE.sendToPlayers(new QuestingPacket(ID_NAME, payload), player);
    }

    @SideOnly(value=Side.CLIENT)
    private static void onClient(NBTTagCompound message) {
        QuestCache qc;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        QuestCache questCache = qc = player != null ? (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null) : null;
        if (qc != null) {
            qc.deserializeNBT(message.func_74775_l("data"));
        }
    }
}

