/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.QuestingPacket;
import betterquesting.core.BetterQuesting;
import betterquesting.network.handlers.NetLootSync;
import betterquesting.questing.rewards.loot.LootRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class NetLootImport {
    private static final ResourceLocation ID_NAME = new ResourceLocation("bq_standard:loot_import");

    public static void registerHandler() {
        QuestingAPI.getAPI(ApiReference.PACKET_REG).registerServerHandler(ID_NAME, NetLootImport::onServer);
    }

    @SideOnly(value=Side.CLIENT)
    public static void importLoot(NBTTagCompound data) {
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74782_a("data", (NBTBase)data);
        QuestingAPI.getAPI(ApiReference.PACKET_SENDER).sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    private static void onServer(Tuple<NBTTagCompound, EntityPlayerMP> message) {
        EntityPlayerMP sender = (EntityPlayerMP)message.func_76340_b();
        NBTTagCompound tag = (NBTTagCompound)message.func_76341_a();
        if (sender.func_184102_h() == null) {
            return;
        }
        if (!sender.func_184102_h().func_184103_al().func_152596_g(sender.func_146103_bH())) {
            BetterQuesting.logger.log(Level.WARN, "Player " + sender.func_70005_c_() + " (UUID:" + QuestingAPI.getQuestingUUID((EntityPlayer)sender) + ") tried to import loot without OP permissions!");
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You need to be OP to edit loot!"));
            return;
        }
        LootRegistry.INSTANCE.readFromNBT(tag.func_74775_l("data"), false);
        NetLootSync.sendSync(null);
    }
}

