/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.events.DatabaseEvent;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.BQThreadedIO;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeRegistry;
import betterquesting.questing.QuestDatabase;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NetQuestSync {
    private static final ResourceLocation ID_NAME = new ResourceLocation("betterquesting", "quest_sync");

    public static void registerHandler() {
        PacketTypeRegistry.INSTANCE.registerServerHandler(ID_NAME, NetQuestSync::onServer);
        if (BetterQuesting.proxy.isClient()) {
            PacketTypeRegistry.INSTANCE.registerClientHandler(ID_NAME, NetQuestSync::onClient);
        }
    }

    public static void quickSync(int questID, boolean config, boolean progress) {
        int[] nArray;
        if (!config && !progress) {
            return;
        }
        if (questID < 0) {
            nArray = null;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = questID;
        }
        int[] IDs = nArray;
        if (config) {
            NetQuestSync.sendSync(null, IDs, true, false);
        }
        if (progress) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server == null) {
                return;
            }
            for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
                NetQuestSync.sendSync(player, IDs, false, true);
            }
        }
    }

    @Deprecated
    public static void sendSync(@Nullable EntityPlayerMP player, @Nullable int[] questIDs, boolean config, boolean progress) {
        NetQuestSync.sendSync(player, questIDs, null, config, progress);
    }

    public static void sendSync(@Nullable EntityPlayerMP player, @Nullable int[] questIDs, @Nullable int[] resetIDs, boolean config, boolean progress) {
        if (!config && !progress || questIDs != null && questIDs.length <= 0) {
            return;
        }
        BQThreadedIO.INSTANCE.enqueue(() -> {
            NBTTagList dataList = new NBTTagList();
            List questSubset = questIDs == null ? QuestDatabase.INSTANCE.getEntries() : QuestDatabase.INSTANCE.bulkLookup(questIDs);
            List<UUID> pidList = player == null ? null : Collections.singletonList(QuestingAPI.getQuestingUUID((EntityPlayer)player));
            for (DBEntry entry : questSubset) {
                NBTTagCompound tag = new NBTTagCompound();
                if (config) {
                    tag.func_74782_a("config", (NBTBase)((IQuest)entry.getValue()).writeToNBT(new NBTTagCompound()));
                }
                if (progress) {
                    tag.func_74782_a("progress", (NBTBase)((IQuest)entry.getValue()).writeProgressToNBT(new NBTTagCompound(), pidList));
                }
                if (resetIDs != null) {
                    tag.func_74783_a("resets", resetIDs);
                }
                tag.func_74768_a("questID", entry.getID());
                dataList.func_74742_a((NBTBase)tag);
            }
            NBTTagCompound payload = new NBTTagCompound();
            payload.func_74757_a("merge", !config || questIDs != null);
            payload.func_74782_a("data", (NBTBase)dataList);
            if (player == null) {
                PacketSender.INSTANCE.sendToAll(new QuestingPacket(ID_NAME, payload));
            } else {
                PacketSender.INSTANCE.sendToPlayers(new QuestingPacket(ID_NAME, payload), player);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public static void requestSync(@Nullable int[] questIDs, boolean configs, boolean progress) {
        NBTTagCompound payload = new NBTTagCompound();
        if (questIDs != null) {
            payload.func_74783_a("requestIDs", questIDs);
        }
        payload.func_74757_a("getConfig", configs);
        payload.func_74757_a("getProgress", progress);
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    private static void onServer(Tuple<NBTTagCompound, EntityPlayerMP> message) {
        NBTTagCompound payload = (NBTTagCompound)message.func_76341_a();
        int[] reqIDs = !payload.func_150297_b("requestIDs", 11) ? null : payload.func_74759_k("requestIDs");
        NetQuestSync.sendSync((EntityPlayerMP)message.func_76340_b(), reqIDs, payload.func_74767_n("getConfig"), payload.func_74767_n("getProgress"));
    }

    @SideOnly(value=Side.CLIENT)
    private static void onClient(NBTTagCompound message) {
        NBTTagList data = message.func_150295_c("data", 10);
        boolean merge = message.func_74767_n("merge");
        if (!merge) {
            QuestDatabase.INSTANCE.reset();
        }
        for (int i = 0; i < data.func_74745_c(); ++i) {
            NBTTagCompound tag = data.func_150305_b(i);
            if (!tag.func_150297_b("questID", 99)) continue;
            int questID = tag.func_74762_e("questID");
            IQuest quest = (IQuest)QuestDatabase.INSTANCE.getValue(questID);
            if (tag.func_150297_b("config", 10)) {
                if (quest == null) {
                    quest = QuestDatabase.INSTANCE.createNew(questID);
                }
                quest.readFromNBT(tag.func_74775_l("config"));
            }
            if (!tag.func_150297_b("progress", 10) || quest == null) continue;
            quest.readProgressFromNBT(tag.func_74775_l("progress"), merge || Minecraft.func_71410_x().func_71387_A());
        }
        MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Update(DatabaseEvent.DBType.QUEST));
    }
}

