/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.questing.tasks.TaskInteractItem;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NetTaskInteract {
    private static final ResourceLocation ID_NAME = new ResourceLocation("bq_standard:task_interact");

    public static void registerHandler() {
        QuestingAPI.getAPI(ApiReference.PACKET_REG).registerServerHandler(ID_NAME, NetTaskInteract::onServer);
    }

    @SideOnly(value=Side.CLIENT)
    public static void requestInteraction(boolean isHit, boolean isMainHand) {
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74757_a("isMainHand", isMainHand);
        payload.func_74757_a("isHit", isHit);
        QuestingAPI.getAPI(ApiReference.PACKET_SENDER).sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    private static void onServer(Tuple<NBTTagCompound, EntityPlayerMP> message) {
        EntityPlayerMP sender = (EntityPlayerMP)message.func_76340_b();
        NBTTagCompound tag = (NBTTagCompound)message.func_76341_a();
        ParticipantInfo pInfo = new ParticipantInfo((EntityPlayer)sender);
        List actQuest = QuestingAPI.getAPI(ApiReference.QUEST_DB).bulkLookup(pInfo.getSharedQuests());
        EnumHand hand = tag.func_74767_n("isMainHand") ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        boolean isHit = tag.func_74767_n("isHit");
        for (DBEntry<IQuest> dBEntry : actQuest) {
            for (DBEntry task : ((IQuest)dBEntry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskInteractItem)) continue;
                ((TaskInteractItem)task.getValue()).onInteract(pInfo, dBEntry, hand, ItemStack.field_190927_a, Blocks.field_150350_a.func_176223_P(), sender.func_180425_c(), isHit);
            }
        }
    }
}

