/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import com.brandon3055.brandonscore.lib.DummyTeleporter;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ITeleporter;

public class TeleportUtils {
    public static Entity teleportEntity(Entity entity, int dimension, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return entity;
        }
        MinecraftServer server = entity.func_184102_h();
        int sourceDim = entity.field_70170_p.field_73011_w.getDimension();
        if (!entity.func_184207_aI() && !entity.func_184218_aH()) {
            return TeleportUtils.handleEntityTeleport(entity, server, sourceDim, dimension, xCoord, yCoord, zCoord, yaw, pitch);
        }
        Entity rootEntity = entity.func_184208_bv();
        PassengerHelper passengerHelper = new PassengerHelper(rootEntity);
        PassengerHelper rider = passengerHelper.getPassenger(entity);
        if (rider == null) {
            LogHelperBC.error("RiddenEntity: This error should not be possible");
            return entity;
        }
        passengerHelper.teleport(server, sourceDim, dimension, xCoord, yCoord, zCoord, yaw, pitch);
        passengerHelper.remountRiders();
        passengerHelper.updateClients();
        return rider.entity;
    }

    public static Entity teleportEntity(Entity entity, int dimension, double xCoord, double yCoord, double zCoord) {
        return TeleportUtils.teleportEntity(entity, dimension, xCoord, yCoord, zCoord, entity.field_70177_z, entity.field_70125_A);
    }

    private static Entity handleEntityTeleport(Entity entity, MinecraftServer server, int sourceDim, int targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        boolean interDimensional;
        if (entity == null || entity.field_70170_p.field_72995_K || !entity.func_70089_S()) {
            return entity;
        }
        boolean bl = interDimensional = sourceDim != targetDim;
        if (interDimensional && !ForgeHooks.onTravelToDimension((Entity)entity, (int)targetDim)) {
            return entity;
        }
        if (interDimensional) {
            if (entity instanceof EntityPlayerMP) {
                return TeleportUtils.teleportPlayerInterdimentional((EntityPlayerMP)entity, server, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            }
            return TeleportUtils.teleportEntityInterdimentional(entity, server, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            player.field_71135_a.func_147364_a(xCoord, yCoord, zCoord, yaw, pitch);
        } else {
            entity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
        }
        entity.func_70034_d(yaw);
        return entity;
    }

    private static Entity teleportEntityInterdimentional(Entity entity, MinecraftServer server, int targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        WorldServer targetWorld = server.func_71218_a(targetDim);
        entity = entity.changeDimension(targetDim, (ITeleporter)new DummyTeleporter(targetWorld, xCoord, yCoord, zCoord, yaw, pitch));
        return entity;
    }

    private static EntityPlayer teleportPlayerInterdimentional(EntityPlayerMP player, MinecraftServer server, int targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        if (!ForgeHooks.onTravelToDimension((Entity)player, (int)targetDim)) {
            return player;
        }
        WorldServer targetWorld = server.func_71218_a(targetDim);
        server.func_184103_al().transferPlayerToDimension(player, targetDim, (Teleporter)new DummyTeleporter(targetWorld, xCoord, yCoord, zCoord, yaw, pitch));
        player.field_71144_ck = -1;
        player.field_71149_ch = -1.0f;
        player.field_71146_ci = -1;
        return player;
    }

    private static class PassengerHelper {
        public Entity entity;
        public LinkedList<PassengerHelper> passengers = new LinkedList();
        public double offsetX;
        public double offsetY;
        public double offsetZ;

        public PassengerHelper(Entity entity) {
            this.entity = entity;
            if (entity.func_184218_aH()) {
                this.offsetX = entity.field_70165_t - entity.func_184187_bx().field_70165_t;
                this.offsetY = entity.field_70163_u - entity.func_184187_bx().field_70163_u;
                this.offsetZ = entity.field_70161_v - entity.func_184187_bx().field_70161_v;
            }
            for (Entity passenger : entity.func_184188_bt()) {
                this.passengers.add(new PassengerHelper(passenger));
            }
        }

        public void teleport(MinecraftServer server, int sourceDim, int targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
            this.entity.func_184226_ay();
            this.entity = TeleportUtils.handleEntityTeleport(this.entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            for (PassengerHelper passenger : this.passengers) {
                passenger.teleport(server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            }
        }

        public void remountRiders() {
            if (this.entity == null) {
                return;
            }
            if (this.entity.func_184218_aH()) {
                this.entity.func_70012_b(this.entity.field_70165_t + this.offsetX, this.entity.field_70163_u + this.offsetY, this.entity.field_70161_v + this.offsetZ, this.entity.field_70177_z, this.entity.field_70125_A);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.entity.func_184205_a(this.entity, true);
                passenger.remountRiders();
            }
        }

        public void updateClients() {
            if (this.entity instanceof EntityPlayerMP) {
                this.updateClient((EntityPlayerMP)this.entity);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        private void updateClient(EntityPlayerMP playerMP) {
            if (this.entity.func_184207_aI()) {
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketSetPassengers(this.entity));
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        public PassengerHelper getPassenger(Entity passenger) {
            if (this.entity == passenger) {
                return this;
            }
            for (PassengerHelper rider : this.passengers) {
                PassengerHelper re = rider.getPassenger(passenger);
                if (re == null) continue;
                return re;
            }
            return null;
        }
    }
}

