/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.entities;

import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.blocks.ModBlocks;
import com.direwolf20.buildinggadgets.common.entities.ConstructionBlockEntity;
import com.google.common.base.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockBuildEntity
extends Entity {
    private static final DataParameter<Integer> toolMode = EntityDataManager.func_187226_a(BlockBuildEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<IBlockState>> SET_BLOCK = EntityDataManager.func_187226_a(BlockBuildEntity.class, (DataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<BlockPos> FIXED = EntityDataManager.func_187226_a(BlockBuildEntity.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> usePaste = EntityDataManager.func_187226_a(BlockBuildEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    private int despawning = -1;
    public int maxLife = 20;
    private int mode;
    private IBlockState setBlock;
    private IBlockState originalSetBlock;
    private IBlockState actualSetBlock;
    private BlockPos setPos;
    private EntityLivingBase spawnedBy;
    private boolean useConstructionPaste;
    private World world;

    public BlockBuildEntity(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.1f, 0.1f);
        this.world = worldIn;
    }

    public BlockBuildEntity(World worldIn, BlockPos spawnPos, EntityLivingBase player, IBlockState spawnBlock, int toolMode, IBlockState actualSpawnBlock, boolean constrPaste) {
        super(worldIn);
        this.func_70105_a(0.1f, 0.1f);
        this.func_70107_b(spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p());
        IBlockState currentBlock = worldIn.func_180495_p(spawnPos);
        TileEntity te = worldIn.func_175625_s(spawnPos);
        this.setPos = spawnPos;
        if (te instanceof ConstructionBlockTileEntity) {
            this.setBlock = ((ConstructionBlockTileEntity)te).getBlockState();
            if (this.setBlock == null) {
                this.setBlock = spawnBlock;
            }
        } else {
            this.setBlock = spawnBlock;
        }
        this.originalSetBlock = spawnBlock;
        this.setSetBlock(this.setBlock);
        if (toolMode == 3) {
            if (currentBlock != null) {
                if (te instanceof ConstructionBlockTileEntity) {
                    this.setBlock = ((ConstructionBlockTileEntity)te).getBlockState();
                    if (this.setBlock == null) {
                        this.setBlock = currentBlock;
                    }
                } else {
                    this.setBlock = currentBlock;
                }
                this.setSetBlock(this.setBlock);
            } else {
                this.setBlock = Blocks.field_150350_a.func_176223_P();
                this.setSetBlock(this.setBlock);
            }
        }
        this.world = worldIn;
        this.mode = toolMode;
        this.setToolMode(toolMode);
        this.spawnedBy = player;
        this.actualSetBlock = actualSpawnBlock;
        if (this.setBlock.func_177230_c() instanceof BlockLeaves) {
            this.setBlock = this.setBlock.func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
        }
        this.world.func_175656_a(spawnPos, ModBlocks.effectBlock.func_176223_P());
        this.setUsingConstructionPaste(constrPaste);
    }

    public int getToolMode() {
        return (Integer)this.field_70180_af.func_187225_a(toolMode);
    }

    public void setToolMode(int mode) {
        this.field_70180_af.func_187227_b(toolMode, (Object)mode);
    }

    @Nullable
    public IBlockState getSetBlock() {
        return (IBlockState)((Optional)this.field_70180_af.func_187225_a(SET_BLOCK)).orNull();
    }

    public void setSetBlock(@Nullable IBlockState state) {
        this.field_70180_af.func_187227_b(SET_BLOCK, (Object)Optional.fromNullable((Object)state));
    }

    public void setUsingConstructionPaste(Boolean paste) {
        this.field_70180_af.func_187227_b(usePaste, (Object)paste);
    }

    public boolean getUsingConstructionPaste() {
        return (Boolean)this.field_70180_af.func_187225_a(usePaste);
    }

    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    public int getTicksExisted() {
        return this.field_70173_aa;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > this.maxLife) {
            this.setDespawning();
        }
        if (this.isDespawning()) {
            this.despawnTick();
        }
    }

    public boolean isDespawning() {
        return this.despawning != -1;
    }

    private void setDespawning() {
        if (this.despawning == -1) {
            this.despawning = 0;
            if (this.setPos != null && this.setBlock != null && this.getToolMode() == 1) {
                if (this.getUsingConstructionPaste()) {
                    this.world.func_175656_a(this.setPos, ModBlocks.constructionBlock.func_176223_P());
                    TileEntity te = this.world.func_175625_s(this.setPos);
                    if (te instanceof ConstructionBlockTileEntity) {
                        ((ConstructionBlockTileEntity)te).setBlockState(this.setBlock);
                        ((ConstructionBlockTileEntity)te).setActualBlockState(this.actualSetBlock);
                    }
                    this.world.func_72838_d((Entity)new ConstructionBlockEntity(this.world, this.setPos, false));
                } else {
                    this.world.func_175656_a(this.setPos, this.setBlock);
                    this.world.func_180495_p(this.setPos).func_177230_c().func_189540_a(this.setBlock, this.world, this.setPos, this.world.func_180495_p(this.setPos.func_177984_a()).func_177230_c(), this.setPos.func_177984_a());
                }
            } else if (this.setPos != null && this.setBlock != null && this.getToolMode() == 2) {
                this.world.func_175656_a(this.setPos, Blocks.field_150350_a.func_176223_P());
            } else if (this.setPos != null && this.setBlock != null && this.getToolMode() == 3) {
                this.world.func_72838_d((Entity)new BlockBuildEntity(this.world, this.setPos, this.spawnedBy, this.originalSetBlock, 1, this.actualSetBlock, this.getUsingConstructionPaste()));
            }
        }
    }

    private void despawnTick() {
        ++this.despawning;
        if (this.despawning > 1) {
            this.func_70106_y();
        }
    }

    public void func_70106_y() {
        this.field_70128_L = true;
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("despawning", this.despawning);
        compound.func_74768_a("ticksExisted", this.field_70173_aa);
        compound.func_74782_a("setPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.setPos));
        NBTTagCompound blockStateTag = new NBTTagCompound();
        NBTUtil.func_190009_a((NBTTagCompound)blockStateTag, (IBlockState)this.setBlock);
        compound.func_74782_a("setBlock", (NBTBase)blockStateTag);
        NBTTagCompound actualBlockStateTag = new NBTTagCompound();
        NBTUtil.func_190009_a((NBTTagCompound)actualBlockStateTag, (IBlockState)this.actualSetBlock);
        compound.func_74782_a("actualSetBlock", (NBTBase)actualBlockStateTag);
        NBTUtil.func_190009_a((NBTTagCompound)blockStateTag, (IBlockState)this.originalSetBlock);
        compound.func_74782_a("originalBlock", (NBTBase)blockStateTag);
        compound.func_74768_a("mode", this.mode);
        compound.func_74757_a("paste", this.useConstructionPaste);
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.despawning = compound.func_74762_e("despawning");
        this.field_70173_aa = compound.func_74762_e("ticksExisted");
        this.setPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("setPos"));
        this.setBlock = NBTUtil.func_190008_d((NBTTagCompound)compound.func_74775_l("setBlock"));
        this.originalSetBlock = NBTUtil.func_190008_d((NBTTagCompound)compound.func_74775_l("originalBlock"));
        this.actualSetBlock = NBTUtil.func_190008_d((NBTTagCompound)compound.func_74775_l("actualSetBlock"));
        this.mode = compound.func_74762_e("mode");
        this.useConstructionPaste = compound.func_74767_n("paste");
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FIXED, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(toolMode, (Object)1);
        this.field_70180_af.func_187214_a(SET_BLOCK, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(usePaste, (Object)this.useConstructionPaste);
    }
}

