/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.impl;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import stanhebben.zenscript.IZenCompileEnvironment;
import stanhebben.zenscript.IZenRegistry;
import stanhebben.zenscript.TypeExpansion;
import stanhebben.zenscript.compiler.ClassNameGenerator;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.ZenPosition;

public class GenericGlobalEnvironment
implements IEnvironmentGlobal {
    private final Map<String, byte[]> classes;
    private final Map<String, IZenSymbol> symbols;
    private final ClassNameGenerator generator;
    private final IZenRegistry registry;

    public GenericGlobalEnvironment(Map<String, byte[]> classes, IZenRegistry registry) {
        this.classes = classes;
        this.symbols = new HashMap<String, IZenSymbol>();
        this.generator = new ClassNameGenerator();
        this.registry = registry;
    }

    @Override
    public IZenCompileEnvironment getEnvironment() {
        return this.registry.getCompileEnvironment();
    }

    @Override
    public TypeExpansion getExpansion(String name) {
        return this.registry.getExpansions().computeIfAbsent(name, TypeExpansion::new);
    }

    @Override
    public ClassNameGenerator getClassNameGenerator() {
        return this.generator;
    }

    @Override
    public String makeClassName() {
        return this.generator.generate();
    }

    @Override
    public String makeClassNameWithMiddleName(String middleName) {
        return this.generator.generateWithMiddleName(middleName);
    }

    @Override
    public boolean containsClass(String name) {
        return this.classes.containsKey(name);
    }

    @Override
    public Set<String> getClassNames() {
        return this.classes.keySet();
    }

    @Override
    public byte[] getClass(String name) {
        return this.classes.get(name);
    }

    @Override
    public void putClass(String name, byte[] data) {
        this.classes.put(name, data);
    }

    @Override
    public IPartialExpression getValue(String name, ZenPosition position) {
        if (this.symbols.containsKey(name)) {
            return this.symbols.get(name).instance(position);
        }
        if (this.registry.getGlobals().containsKey(name)) {
            return this.registry.getGlobals().get(name).instance(position);
        }
        IZenSymbol pkg = this.registry.getRoot().get(name);
        if (pkg == null) {
            return null;
        }
        return pkg.instance(position);
    }

    @Override
    public void putValue(String name, IZenSymbol value, ZenPosition position) {
        if (this.symbols.containsKey(name)) {
            this.error(position, "Value already defined in this scope: " + name);
        } else {
            this.symbols.put(name, value);
        }
    }

    @Override
    public void error(ZenPosition position, String message) {
        this.registry.getErrorLogger().error(position, message);
    }

    @Override
    public void warning(ZenPosition position, String message) {
        this.registry.getErrorLogger().warning(position, message);
    }

    @Override
    public void info(ZenPosition position, String message) {
        this.registry.getErrorLogger().info(position, message);
    }

    @Override
    public void error(String message) {
        this.registry.getErrorLogger().error(message);
    }

    @Override
    public void error(String message, Throwable e) {
        this.registry.getErrorLogger().error(message, e);
    }

    @Override
    public void warning(String message) {
        this.registry.getErrorLogger().warning(message);
    }

    @Override
    public void info(String message) {
        this.registry.getErrorLogger().info(message);
    }

    @Override
    public ZenType getType(Type type) {
        return this.registry.getTypes().getType(type);
    }
}

