/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import java.util.List;
import net.blay09.mods.craftingtweaks.api.DefaultProviderV2;
import net.blay09.mods.craftingtweaks.api.RotationHandler;
import net.blay09.mods.craftingtweaks.api.TweakProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class DefaultProviderV2Impl
implements DefaultProviderV2 {
    private static final RotationHandler rotationHandler = new RotationHandler(){

        @Override
        public boolean ignoreSlotId(int slotId) {
            return slotId == 4;
        }

        @Override
        public int rotateSlotId(int slotId, boolean counterClockwise) {
            if (!counterClockwise) {
                switch (slotId) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 5;
                    }
                    case 5: {
                        return 8;
                    }
                    case 8: {
                        return 7;
                    }
                    case 7: {
                        return 6;
                    }
                    case 6: {
                        return 3;
                    }
                    case 3: {
                        return 0;
                    }
                }
            } else {
                switch (slotId) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 6;
                    }
                    case 5: {
                        return 2;
                    }
                    case 6: {
                        return 7;
                    }
                    case 7: {
                        return 8;
                    }
                    case 8: {
                        return 5;
                    }
                }
            }
            return 0;
        }
    };

    @Override
    public <T extends Container> void clearGrid(TweakProvider<T> provider, int id, EntityPlayer entityPlayer, T container, boolean phantomItems, boolean forced) {
        IInventory craftMatrix = provider.getCraftMatrix(entityPlayer, container, id);
        if (craftMatrix == null) {
            return;
        }
        int start = provider.getCraftingGridStart(entityPlayer, container, id);
        int size = provider.getCraftingGridSize(entityPlayer, container, id);
        for (int i = start; i < start + size; ++i) {
            int slotIndex = ((Slot)container.field_75151_b.get(i)).getSlotIndex();
            if (phantomItems) {
                craftMatrix.func_70299_a(slotIndex, ItemStack.field_190927_a);
                continue;
            }
            ItemStack itemStack = craftMatrix.func_70301_a(slotIndex);
            if (itemStack.func_190926_b()) continue;
            ItemStack returnStack = itemStack.func_77946_l();
            entityPlayer.field_71071_by.func_70441_a(returnStack);
            craftMatrix.func_70299_a(slotIndex, returnStack.func_190916_E() == 0 ? ItemStack.field_190927_a : returnStack);
            if (returnStack.func_190916_E() <= 0 || !forced) continue;
            entityPlayer.func_71019_a(returnStack, false);
            craftMatrix.func_70299_a(slotIndex, ItemStack.field_190927_a);
        }
        container.func_75142_b();
    }

    @Override
    public <T extends Container> void balanceGrid(TweakProvider<T> provider, int id, EntityPlayer entityPlayer, T container) {
        IInventory craftMatrix = provider.getCraftMatrix(entityPlayer, container, id);
        if (craftMatrix == null) {
            return;
        }
        ArrayListMultimap itemMap = ArrayListMultimap.create();
        HashMultiset itemCount = HashMultiset.create();
        int start = provider.getCraftingGridStart(entityPlayer, container, id);
        int size = provider.getCraftingGridSize(entityPlayer, container, id);
        for (int i = start; i < start + size; ++i) {
            int slotIndex = ((Slot)container.field_75151_b.get(i)).getSlotIndex();
            ItemStack itemStack = craftMatrix.func_70301_a(slotIndex);
            if (itemStack.func_190926_b() || itemStack.func_77976_d() <= 1) continue;
            String key = itemStack.func_77973_b().getRegistryName() + "@" + itemStack.func_77952_i();
            itemMap.put((Object)key, (Object)itemStack);
            itemCount.add((Object)key, itemStack.func_190916_E());
        }
        for (String key : itemMap.keySet()) {
            List balanceList = itemMap.get((Object)key);
            int totalCount = itemCount.count((Object)key);
            int countPerStack = totalCount / balanceList.size();
            int restCount = totalCount % balanceList.size();
            for (ItemStack itemStack : balanceList) {
                itemStack.func_190920_e(countPerStack);
            }
            int idx = 0;
            while (restCount > 0) {
                ItemStack itemStack;
                itemStack = (ItemStack)balanceList.get(idx);
                if (itemStack.func_190916_E() < itemStack.func_77976_d()) {
                    itemStack.func_190917_f(1);
                    --restCount;
                }
                if (++idx < balanceList.size()) continue;
                idx = 0;
            }
        }
        container.func_75142_b();
    }

    @Override
    public <T extends Container> void spreadGrid(TweakProvider<T> provider, int id, EntityPlayer entityPlayer, T container) {
        boolean emptyBiggestSlot;
        IInventory craftMatrix = provider.getCraftMatrix(entityPlayer, container, id);
        if (craftMatrix == null) {
            return;
        }
        do {
            ItemStack biggestSlotStack = null;
            int biggestSlotSize = 1;
            int start = provider.getCraftingGridStart(entityPlayer, container, id);
            int size = provider.getCraftingGridSize(entityPlayer, container, id);
            for (int i = start; i < start + size; ++i) {
                int slotIndex = ((Slot)container.field_75151_b.get(i)).getSlotIndex();
                ItemStack itemStack = craftMatrix.func_70301_a(slotIndex);
                if (itemStack.func_190926_b() || itemStack.func_190916_E() <= biggestSlotSize) continue;
                biggestSlotStack = itemStack;
                biggestSlotSize = itemStack.func_190916_E();
            }
            if (biggestSlotStack == null) {
                return;
            }
            emptyBiggestSlot = false;
            for (int i = start; i < start + size; ++i) {
                int slotIndex = ((Slot)container.field_75151_b.get(i)).getSlotIndex();
                ItemStack itemStack = craftMatrix.func_70301_a(slotIndex);
                if (!itemStack.func_190926_b()) continue;
                if (biggestSlotStack.func_190916_E() > 1) {
                    craftMatrix.func_70299_a(slotIndex, biggestSlotStack.func_77979_a(1));
                    continue;
                }
                emptyBiggestSlot = true;
            }
        } while (emptyBiggestSlot);
        this.balanceGrid(provider, id, entityPlayer, container);
    }

    @Override
    public <T extends Container> ItemStack putIntoGrid(TweakProvider<T> provider, int id, EntityPlayer entityPlayer, T container, ItemStack itemStack, int index) {
        IInventory craftMatrix = provider.getCraftMatrix(entityPlayer, container, id);
        if (craftMatrix == null) {
            return itemStack;
        }
        ItemStack craftStack = craftMatrix.func_70301_a(index);
        if (!craftStack.func_190926_b()) {
            int spaceLeft;
            if (craftStack.func_77969_a(itemStack) && ItemStack.func_77970_a((ItemStack)craftStack, (ItemStack)itemStack) && (spaceLeft = Math.min(craftMatrix.func_70297_j_(), craftStack.func_77976_d()) - craftStack.func_190916_E()) > 0) {
                ItemStack splitStack = itemStack.func_77979_a(Math.min(spaceLeft, itemStack.func_190916_E()));
                craftStack.func_190917_f(splitStack.func_190916_E());
                if (itemStack.func_190916_E() <= 0) {
                    return null;
                }
            }
        } else {
            ItemStack transferStack = itemStack.func_77979_a(Math.min(itemStack.func_190916_E(), craftMatrix.func_70297_j_()));
            craftMatrix.func_70299_a(index, transferStack);
        }
        if (itemStack.func_190916_E() <= 0) {
            return null;
        }
        return itemStack;
    }

    @Override
    public <T extends Container> boolean transferIntoGrid(TweakProvider<T> provider, int id, EntityPlayer entityPlayer, T container, Slot sourceSlot) {
        IInventory craftMatrix = provider.getCraftMatrix(entityPlayer, container, id);
        if (craftMatrix == null) {
            return false;
        }
        int start = provider.getCraftingGridStart(entityPlayer, container, id);
        int size = provider.getCraftingGridSize(entityPlayer, container, id);
        ItemStack itemStack = sourceSlot.func_75211_c();
        if (itemStack.func_190926_b()) {
            return false;
        }
        int firstEmptySlot = -1;
        for (int i = start; i < start + size; ++i) {
            int slotIndex = ((Slot)container.field_75151_b.get(i)).getSlotIndex();
            ItemStack craftStack = craftMatrix.func_70301_a(slotIndex);
            if (!craftStack.func_190926_b()) {
                int spaceLeft;
                if (!craftStack.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)craftStack, (ItemStack)itemStack) || (spaceLeft = Math.min(craftMatrix.func_70297_j_(), craftStack.func_77976_d()) - craftStack.func_190916_E()) <= 0) continue;
                ItemStack splitStack = itemStack.func_77979_a(Math.min(spaceLeft, itemStack.func_190916_E()));
                craftStack.func_190917_f(splitStack.func_190916_E());
                if (itemStack.func_190916_E() > 0) continue;
                return true;
            }
            if (firstEmptySlot != -1) continue;
            firstEmptySlot = slotIndex;
        }
        if (itemStack.func_190916_E() > 0 && firstEmptySlot != -1) {
            ItemStack transferStack = itemStack.func_77979_a(Math.min(itemStack.func_190916_E(), craftMatrix.func_70297_j_()));
            craftMatrix.func_70299_a(firstEmptySlot, transferStack);
            return true;
        }
        return false;
    }

    @Override
    public <T extends Container> boolean canTransferFrom(EntityPlayer entityPlayer, T container, Slot slot) {
        return slot.field_75224_c == entityPlayer.field_71071_by;
    }

    @Override
    public <T extends Container> void rotateGrid(TweakProvider<T> provider, int id, EntityPlayer entityPlayer, T container, boolean counterClockwise) {
        this.rotateGrid(provider, id, entityPlayer, container, rotationHandler, counterClockwise);
    }

    @Override
    public <T extends Container> void rotateGrid(TweakProvider<T> provider, int id, EntityPlayer entityPlayer, T container, RotationHandler rotationHandler, boolean counterClockwise) {
        int slotIndex;
        int i;
        IInventory craftMatrix = provider.getCraftMatrix(entityPlayer, container, id);
        if (craftMatrix == null) {
            return;
        }
        int start = provider.getCraftingGridStart(entityPlayer, container, id);
        int size = provider.getCraftingGridSize(entityPlayer, container, id);
        InventoryBasic matrixClone = new InventoryBasic("", false, size);
        for (i = 0; i < size; ++i) {
            slotIndex = ((Slot)container.field_75151_b.get(start + i)).getSlotIndex();
            matrixClone.func_70299_a(i, craftMatrix.func_70301_a(slotIndex));
        }
        for (i = 0; i < size; ++i) {
            if (rotationHandler.ignoreSlotId(i)) continue;
            slotIndex = ((Slot)container.field_75151_b.get(start + rotationHandler.rotateSlotId(i, counterClockwise))).getSlotIndex();
            craftMatrix.func_70299_a(slotIndex, matrixClone.func_70301_a(i));
        }
        container.func_75142_b();
    }

    @Override
    public RotationHandler getRotationHandler() {
        return rotationHandler;
    }
}

