/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.addons;

import javax.annotation.Nullable;
import net.blay09.mods.craftingtweaks.addons.AdvancedTableRotation;
import net.blay09.mods.craftingtweaks.addons.EliteTableRotation;
import net.blay09.mods.craftingtweaks.addons.ProviderExtendedCrafting;
import net.blay09.mods.craftingtweaks.addons.UltimateTableRotation;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksAPI;
import net.blay09.mods.craftingtweaks.api.SimpleTweakProvider;
import net.blay09.mods.craftingtweaks.api.TweakProvider;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftingTweaksAddons {
    public static final Logger logger = LogManager.getLogger();
    protected static final String MODID_EXC = "extendedcrafting";
    protected static final String MODID_AVA = "avaritia";
    protected static final String MODID_FOR = "forestry";

    public static void postInit(FMLPostInitializationEvent event) {
        SimpleTweakProvider<?> provider;
        if (Loader.isModLoaded((String)MODID_EXC)) {
            CraftingTweaksAddons.registerSimpleProvider(MODID_EXC, "com.blakebr0.extendedcrafting.client.container.ContainerBasicTable");
            CraftingTweaksAddons.registerProvider("com.blakebr0.extendedcrafting.client.container.ContainerAdvancedTable", new ProviderExtendedCrafting(new AdvancedTableRotation(), 25));
            CraftingTweaksAddons.registerProvider("com.blakebr0.extendedcrafting.client.container.ContainerEliteTable", new ProviderExtendedCrafting(new EliteTableRotation(), 49));
            CraftingTweaksAddons.registerProvider("com.blakebr0.extendedcrafting.client.container.ContainerUltimateTable", new ProviderExtendedCrafting(new UltimateTableRotation(), 81));
        }
        if (Loader.isModLoaded((String)MODID_AVA)) {
            CraftingTweaksAddons.registerProvider("morph.avaritia.container.ContainerExtremeCrafting", new ProviderExtendedCrafting(MODID_AVA, new UltimateTableRotation(), 81));
        }
        if (Loader.isModLoaded((String)MODID_FOR) && (provider = CraftingTweaksAddons.registerSimpleProvider(MODID_FOR, "forestry.worktable.gui.ContainerWorktable")) != null) {
            provider.setPhantomItems(true);
            provider.setGrid(54, 9);
            provider.setTweakRotate(true, true, -16, 20);
            provider.setTweakBalance(true, true, -16, 38);
            provider.setTweakClear(true, true, -16, 56);
        }
    }

    @Nullable
    private static SimpleTweakProvider<?> registerSimpleProvider(String modid, String className) {
        try {
            return CraftingTweaksAPI.registerSimpleProvider(modid, Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            logger.error("Could not register Crafting Tweaks addon for {} - internal names have changed.", (Object)modid);
            return null;
        }
    }

    private static <T extends Container> void registerProvider(String className, TweakProvider<T> provider) {
        try {
            CraftingTweaksAPI.registerProvider(Class.forName(className), provider);
        }
        catch (ClassNotFoundException e) {
            logger.error("Could not register Crafting Tweaks addon for {} - internal names have changed.", (Object)provider.getModId());
        }
    }
}

