/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.inventory.item;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class ItemInventoryWrapper
implements IInventory {
    public ItemStack inventory;
    public int size;
    public NonNullList<ItemStack> slots;
    protected NBTTagCompound tag;
    public boolean dirty = false;

    public ItemInventoryWrapper(ItemStack inventory, int size) {
        this.inventory = inventory;
        this.size = size;
        this.slots = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this.load();
        this.func_70296_d();
    }

    public void load() {
        NBTTagCompound nbt = this.inventory.func_77978_p();
        if (!this.inventory.func_77942_o() || !nbt.func_74764_b("Items")) {
            if (this.inventory.func_77942_o()) {
                this.tag = nbt;
                this.loadItems();
                this.tag = new NBTTagCompound();
                this.saveItems();
            } else {
                this.inventory.func_77983_a("Inventory", (NBTBase)new NBTTagCompound());
            }
        }
        this.tag = nbt.func_74775_l("Inventory");
        this.loadItems();
    }

    protected void loadItems() {
        for (int i = 0; i < this.size; ++i) {
            if (this.tag.func_74764_b("Slot")) {
                this.slots.set(i, (Object)new ItemStack(this.tag.func_74775_l("Slot" + i)));
                continue;
            }
            this.slots.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    protected void saveItems() {
        for (int i = 0; i < this.size; ++i) {
            if (((ItemStack)this.slots.get(i)).func_190926_b()) {
                this.tag.func_82580_o("Slot" + i);
                continue;
            }
            this.tag.func_74782_a("Slot" + i, (NBTBase)((ItemStack)this.slots.get(i)).func_77955_b(new NBTTagCompound()));
        }
        this.inventory.func_77983_a("Items", (NBTBase)this.tag);
    }

    public boolean getDirty() {
        boolean dirt = this.dirty;
        this.dirty = false;
        return dirt;
    }

    public String func_70005_c_() {
        return this.inventory.func_82833_r();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_82837_s();
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.inventory.func_82833_r());
    }

    public int func_70302_i_() {
        return this.size;
    }

    public boolean func_191420_l() {
        for (ItemStack s : this.slots) {
            if (s.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.slots.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.slots, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.slots, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.slots.set(index, (Object)stack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.saveItems();
        this.dirty = true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
        this.func_70296_d();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

