/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.registry;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.cucumber.iface.IModelHelper;
import com.blakebr0.cucumber.iface.IRepairMaterial;
import com.blakebr0.cucumber.item.ItemMeta;
import com.blakebr0.cucumber.registry.Ore;
import com.blakebr0.cucumber.registry.RegistryObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModRegistry {
    private String modid;
    public List<RegistryObject<Block>> blocks = new ArrayList<RegistryObject<Block>>();
    public List<RegistryObject<Item>> items = new ArrayList<RegistryObject<Item>>();
    public List<RegistryObject<IRecipe>> recipes = new ArrayList<RegistryObject<IRecipe>>();
    public Map<Class, String> tiles = new HashMap<Class, String>();
    public Map<ItemStack, String> ores = new HashMap<ItemStack, String>();

    public ModRegistry(String modid) {
        this.modid = modid;
    }

    public static ModRegistry create(String modid) {
        ModRegistry registry = new ModRegistry(modid);
        MinecraftForge.EVENT_BUS.register((Object)registry);
        return registry;
    }

    public <T extends Block> T register(T block, String name) {
        return this.register(block, name, true);
    }

    public <T extends Block> T register(T block, String name, Ore ... oreNames) {
        return this.register(block, name, true, oreNames);
    }

    public <T extends Block> T register(T block, String name, boolean itemBlock) {
        if (block instanceof IEnableable && !((IEnableable)block).isEnabled()) {
            return block;
        }
        this.blocks.add(new RegistryObject<T>(block, name));
        if (itemBlock) {
            this.items.add(new RegistryObject<ItemBlock>(new ItemBlock(block), name));
        }
        return block;
    }

    public <T extends Block> T register(T block, String name, boolean itemBlock, Ore ... oreNames) {
        if (block instanceof IEnableable && !((IEnableable)block).isEnabled()) {
            return block;
        }
        this.blocks.add(new RegistryObject<T>(block, name));
        if (itemBlock) {
            this.items.add(new RegistryObject<ItemBlock>(new ItemBlock(block), name, oreNames));
        }
        return block;
    }

    public <T extends Block> T register(T block, String name, ItemBlock itemBlock) {
        if (block instanceof IEnableable && !((IEnableable)block).isEnabled()) {
            return block;
        }
        this.blocks.add(new RegistryObject<T>(block, name));
        this.items.add(new RegistryObject<ItemBlock>(itemBlock, name));
        return block;
    }

    public <T extends Block> T register(T block, String name, ItemBlock itemBlock, Ore ... oreNames) {
        if (block instanceof IEnableable && !((IEnableable)block).isEnabled()) {
            return block;
        }
        this.blocks.add(new RegistryObject<T>(block, name));
        this.items.add(new RegistryObject<ItemBlock>(itemBlock, name, oreNames));
        return block;
    }

    public <T extends Item> T register(T item, String name) {
        if (item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof IEnableable && !((IEnableable)((ItemBlock)item).func_179223_d()).isEnabled()) {
            return item;
        }
        if (item instanceof IEnableable && !((IEnableable)item).isEnabled()) {
            return item;
        }
        this.items.add(new RegistryObject<T>(item, name));
        if (item instanceof ItemMeta) {
            ((ItemMeta)item).init();
        }
        return item;
    }

    public <T extends Item> T register(T item, String name, Ore ... oreNames) {
        if (item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof IEnableable && !((IEnableable)((ItemBlock)item).func_179223_d()).isEnabled()) {
            return item;
        }
        if (item instanceof IEnableable && !((IEnableable)item).isEnabled()) {
            return item;
        }
        this.items.add(new RegistryObject<T>(item, name, oreNames));
        if (item instanceof ItemMeta) {
            ((ItemMeta)item).init();
        }
        return item;
    }

    public <T extends Item> T register(T item, String name, ItemStack stack) {
        if (item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof IEnableable && !((IEnableable)((ItemBlock)item).func_179223_d()).isEnabled()) {
            return item;
        }
        if (item instanceof IEnableable && !((IEnableable)item).isEnabled()) {
            return item;
        }
        this.register(item, name);
        if (item instanceof IRepairMaterial) {
            ((IRepairMaterial)item).setRepairMaterial(stack);
        }
        return item;
    }

    public <T extends Item> T register(T item, String name, ItemStack stack, Ore ... oreNames) {
        if (item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof IEnableable && !((IEnableable)((ItemBlock)item).func_179223_d()).isEnabled()) {
            return item;
        }
        if (item instanceof IEnableable && !((IEnableable)item).isEnabled()) {
            return item;
        }
        this.register(item, name, oreNames);
        if (item instanceof IRepairMaterial) {
            ((IRepairMaterial)item).setRepairMaterial(stack);
        }
        return item;
    }

    public <T extends IRecipe> T register(T recipe) {
        if (recipe.func_77571_b().func_190926_b()) {
            return recipe;
        }
        if (recipe.func_192400_c().isEmpty()) {
            return recipe;
        }
        this.recipes.add(new RegistryObject<T>(recipe, RecipeHelper.getRecipeLocation(recipe.func_77571_b()).toString()));
        return recipe;
    }

    public <T extends IRecipe> T register(T recipe, String name) {
        if (recipe.func_77571_b().func_190926_b()) {
            return recipe;
        }
        if (recipe.func_192400_c().isEmpty()) {
            return recipe;
        }
        this.recipes.add(new RegistryObject<T>(recipe, this.modid + ":" + name));
        return recipe;
    }

    public void register(Class clazz, String name) {
        this.tiles.put(clazz, name);
    }

    public void addOre(Object ore, String name) {
        if (ore instanceof Block) {
            this.ores.put(new ItemStack((Block)ore), name);
        } else if (ore instanceof Item) {
            this.ores.put(new ItemStack((Item)ore), name);
        } else if (ore instanceof ItemStack) {
            this.ores.put(((ItemStack)ore).func_77946_l(), name);
        } else {
            throw new RuntimeException("Tried to add an invalid object to the OreDictionary, well done. (" + ore.toString() + " named: " + name + ")");
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        for (RegistryObject<Block> block : this.blocks) {
            if (block.get().getRegistryName() == null) {
                block.get().setRegistryName(block.func_176610_l());
            }
            event.getRegistry().register((IForgeRegistryEntry)block.get());
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        for (RegistryObject<Item> registryObject : this.items) {
            if (registryObject.get().getRegistryName() == null) {
                registryObject.get().setRegistryName(registryObject.func_176610_l());
            }
            event.getRegistry().register((IForgeRegistryEntry)registryObject.get());
            if (registryObject.getOreNames() == null) continue;
            for (Ore o : registryObject.getOreNames()) {
                OreDictionary.registerOre((String)o.getName(), (ItemStack)StackHelper.to(registryObject.get(), 1, o.getMeta()));
            }
        }
        for (Map.Entry entry : this.ores.entrySet()) {
            OreDictionary.registerOre((String)((String)entry.getValue()), (ItemStack)((ItemStack)entry.getKey()));
        }
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        for (RegistryObject<IRecipe> recipe : this.recipes) {
            if (recipe.get().getRegistryName() == null) {
                recipe.get().setRegistryName(new ResourceLocation(recipe.func_176610_l()));
            }
            event.getRegistry().register((IForgeRegistryEntry)recipe.get());
        }
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        for (RegistryObject<Item> item : this.items) {
            if (item.get() instanceof ItemMeta) {
                ((ItemMeta)item.get()).initModels();
                continue;
            }
            if (item.get() instanceof IModelHelper) {
                ((IModelHelper)item.get()).initModels();
                continue;
            }
            if (item.get() instanceof ItemBlock) {
                if (((ItemBlock)item.get()).func_179223_d() instanceof IModelHelper) {
                    ((IModelHelper)((ItemBlock)item.get()).func_179223_d()).initModels();
                    continue;
                }
                ModelLoader.setCustomModelResourceLocation((Item)item.get(), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.modid + ":" + item.func_176610_l(), "inventory"));
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)item.get(), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.modid + ":" + item.func_176610_l(), "inventory"));
        }
    }
}

