/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.client.gui;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mustapelto.deepmoblearning.client.gui.GuiContainerTickable;
import mustapelto.deepmoblearning.client.gui.buttons.ButtonBase;
import mustapelto.deepmoblearning.client.gui.buttons.ButtonRedstoneMode;
import mustapelto.deepmoblearning.common.network.DMLPacketHandler;
import mustapelto.deepmoblearning.common.network.MessageRedstoneMode;
import mustapelto.deepmoblearning.common.tiles.TileEntityMachine;
import mustapelto.deepmoblearning.common.util.Point;
import mustapelto.deepmoblearning.common.util.Rect;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public abstract class GuiMachine
extends GuiContainerTickable {
    protected final TileEntityMachine tileEntity;
    private final Point redstoneModeButtonLocation;
    private ButtonRedstoneMode redstoneModeButton;

    public GuiMachine(TileEntityMachine tileEntity, EntityPlayer player, World world, int width, int height, Point redstoneModeButtonLocation) {
        super(tileEntity, player, world, width, height);
        this.tileEntity = tileEntity;
        this.redstoneModeButtonLocation = redstoneModeButtonLocation;
    }

    @Override
    protected void initButtons() {
        this.redstoneModeButton = new ButtonRedstoneMode(0, this.field_147003_i + this.redstoneModeButtonLocation.X, this.field_147009_r + this.redstoneModeButtonLocation.Y, this.tileEntity.getRedstoneMode());
    }

    @Override
    protected void rebuildButtonList() {
        super.rebuildButtonList();
        this.field_146292_n.add(this.redstoneModeButton);
    }

    @Override
    protected void handleButtonPress(ButtonBase button, int mouseButton) {
        if (button instanceof ButtonRedstoneMode) {
            ButtonRedstoneMode redstoneModeButton = (ButtonRedstoneMode)button;
            if (mouseButton == 0) {
                redstoneModeButton.setRedstoneMode(redstoneModeButton.getRedstoneMode().next());
            } else if (mouseButton == 1) {
                redstoneModeButton.setRedstoneMode(redstoneModeButton.getRedstoneMode().prev());
            }
            DMLPacketHandler.sendToServer(new MessageRedstoneMode(this.tileEntity, redstoneModeButton.getRedstoneMode()));
        }
    }

    protected void drawEnergyBar(Rect energyBar, Point energyBarTextureLocation) {
        int energyBarHeight = (int)((float)this.tileEntity.getEnergy() / (float)this.tileEntity.getMaxEnergy() * (float)energyBar.HEIGHT);
        int energyBarOffset = energyBar.HEIGHT - energyBarHeight;
        this.func_73729_b(this.field_147003_i + energyBar.LEFT, this.field_147009_r + energyBar.TOP + energyBarOffset, energyBarTextureLocation.X, energyBarTextureLocation.Y, energyBar.WIDTH, energyBarHeight);
    }

    public List<Rectangle> getGuiExclusionAreas() {
        ArrayList<Rectangle> result = new ArrayList<Rectangle>();
        result.add(new Rectangle(this.redstoneModeButton.field_146128_h, this.redstoneModeButton.field_146129_i, this.redstoneModeButton.field_146120_f, this.redstoneModeButton.field_146121_g));
        return result;
    }
}

