/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.client.gui;

import com.google.common.collect.ImmutableList;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mustapelto.deepmoblearning.DMLConstants;
import mustapelto.deepmoblearning.client.gui.GuiContainerTickable;
import mustapelto.deepmoblearning.client.gui.buttons.ButtonBase;
import mustapelto.deepmoblearning.client.gui.buttons.ButtonItemDisplay;
import mustapelto.deepmoblearning.client.gui.buttons.ButtonStartTrial;
import mustapelto.deepmoblearning.common.network.DMLPacketHandler;
import mustapelto.deepmoblearning.common.network.MessageRequestUpdateTileEntity;
import mustapelto.deepmoblearning.common.tiles.TileEntityTrialKeystone;
import mustapelto.deepmoblearning.common.trials.AttunementData;
import mustapelto.deepmoblearning.common.trials.affix.TrialAffix;
import mustapelto.deepmoblearning.common.util.Point;
import mustapelto.deepmoblearning.common.util.Rect;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class GuiTrialKeystone
extends GuiContainerTickable {
    private static final ResourceLocation TEXTURE = new ResourceLocation("deepmoblearning", "textures/gui/trial_keystone.png");
    private static final int WIDTH = 200;
    private static final int HEIGHT = 178;
    private static final Rect MAIN_GUI = new Rect(0, 0, 200, 100);
    private static final Rect TRIAL_INFO_OVERLAY = new Rect(109, 0, 91, 100);
    private static final Point START_TRIAL_BUTTON = new Point(114, 76);
    private static final Point REWARD_BUTTON_LIST = new Point(115, 48);
    private static final int REWARD_BUTTON_SIZE = 18;
    private static final int REWARD_BUTTON_ID_OFFSET = 20;
    private static final Point ERROR_TEXT_CENTER = new Point(100, 50);
    private static final Point TRIAL_INFO_TEXT_LEFT = new Point(6, 6);
    private static final Point TRIAL_INFO_TEXT_RIGHT = new Point(115, 6);
    private static final int TIER_NAME_OFFSET_X = 25;
    private static final int WAVES_OFFSET_X = 35;
    private final TileEntityTrialKeystone trialKeystone;
    private AttunementData attunementData;
    private ButtonStartTrial startTrialButton;
    private final List<ButtonItemDisplay> rewardItemDisplay = new ArrayList<ButtonItemDisplay>();
    private final List<String> errorStrings = new ArrayList<String>();
    private boolean hasError;

    public GuiTrialKeystone(TileEntityTrialKeystone tileEntity, EntityPlayer player, World world) {
        super(tileEntity, player, world, 200, 178);
        this.trialKeystone = tileEntity;
    }

    private void getAttunementData() {
        this.attunementData = this.trialKeystone.getTrialData();
    }

    @Override
    protected void initButtons() {
        super.initButtons();
        this.startTrialButton = new ButtonStartTrial(0, this.field_147003_i + GuiTrialKeystone.START_TRIAL_BUTTON.X, this.field_147009_r + GuiTrialKeystone.START_TRIAL_BUTTON.Y);
    }

    @Override
    protected void rebuildButtonList() {
        super.rebuildButtonList();
        this.field_146292_n.add(this.startTrialButton);
        this.getAttunementData();
        this.rebuildRewardButtons();
        this.field_146292_n.addAll(this.rewardItemDisplay);
    }

    @Override
    protected void handleButtonPress(ButtonBase button, int mouseButton) {
        if (button instanceof ButtonStartTrial) {
            this.trialKeystone.startTrial();
            DMLPacketHandler.sendToServer(new MessageRequestUpdateTileEntity(this.trialKeystone));
        }
    }

    private void rebuildRewardButtons() {
        this.rewardItemDisplay.clear();
        this.getAttunementData();
        if (this.hasError || this.attunementData == null) {
            return;
        }
        ImmutableList<ItemStack> rewards = this.attunementData.getRewards();
        for (int i = 0; i < rewards.size(); ++i) {
            ItemStack reward = (ItemStack)rewards.get(i);
            this.rewardItemDisplay.add(new ButtonItemDisplay(20 + i, this.field_147003_i + GuiTrialKeystone.REWARD_BUTTON_LIST.X + i * 18, this.field_147009_r + GuiTrialKeystone.REWARD_BUTTON_LIST.Y, reward));
        }
    }

    @Override
    public void func_73876_c() {
        AttunementData oldAttunementData = this.attunementData;
        this.getAttunementData();
        if (this.attunementData != oldAttunementData) {
            this.buttonListNeedsRebuild = true;
        }
        super.func_73876_c();
        this.errorStrings.clear();
        this.hasError = true;
        if (this.trialKeystone.isTrialActive()) {
            this.errorStrings.add(I18n.func_135052_a((String)"deepmoblearning.trial_keystone.trial_active_1", (Object[])new Object[0]));
            this.errorStrings.add(I18n.func_135052_a((String)"deepmoblearning.trial_keystone.trial_active_2", (Object[])new Object[0]));
            this.errorStrings.add(I18n.func_135052_a((String)"deepmoblearning.trial_keystone.trial_active_3", (Object[])new Object[]{this.trialKeystone.getCurrentWave() + 1, this.trialKeystone.getLastWave()}));
        } else if (!this.trialKeystone.isTrialAreaClear()) {
            this.errorStrings.add(I18n.func_135052_a((String)"deepmoblearning.trial_keystone.area_blocked_1", (Object[])new Object[0]));
            this.errorStrings.add(I18n.func_135052_a((String)"deepmoblearning.trial_keystone.area_blocked_2", (Object[])new Object[0]));
            this.errorStrings.add(I18n.func_135052_a((String)"deepmoblearning.trial_keystone.area_blocked_3", (Object[])new Object[0]));
            this.errorStrings.add(I18n.func_135052_a((String)"deepmoblearning.trial_keystone.area_blocked_4", (Object[])new Object[0]));
            this.errorStrings.add(I18n.func_135052_a((String)"deepmoblearning.trial_keystone.area_blocked_5", (Object[])new Object[0]));
        } else if (!this.trialKeystone.hasTrialKeyInInventory()) {
            this.errorStrings.add(I18n.func_135052_a((String)"deepmoblearning.trial_keystone.no_trial_key_1", (Object[])new Object[0]));
            this.errorStrings.add(I18n.func_135052_a((String)"deepmoblearning.trial_keystone.no_trial_key_2", (Object[])new Object[0]));
        } else {
            this.hasError = false;
        }
        if (this.attunementData == null || this.hasError) {
            this.startTrialButton.field_146125_m = false;
            this.startTrialButton.field_146124_l = false;
            this.buttonListNeedsRebuild = true;
        } else {
            this.startTrialButton.field_146125_m = true;
            this.startTrialButton.field_146124_l = true;
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        RenderHelper.func_74520_c();
        this.rewardItemDisplay.forEach(item -> this.drawItemStackWithOverlay(item.getStack(), item.field_146128_h - this.field_147003_i, item.field_146129_i - this.field_147009_r));
        RenderHelper.func_74518_a();
        super.func_146979_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.textureManager.func_110577_a(TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.field_147003_i + GuiTrialKeystone.MAIN_GUI.LEFT, this.field_147009_r + GuiTrialKeystone.MAIN_GUI.TOP, TextureCoords.MAIN_GUI.X, TextureCoords.MAIN_GUI.Y, GuiTrialKeystone.MAIN_GUI.WIDTH, GuiTrialKeystone.MAIN_GUI.HEIGHT);
        this.func_73729_b(this.field_147003_i + DMLConstants.Gui.TrialKeystone.TRIAL_KEY_SLOT.LEFT, this.field_147009_r + DMLConstants.Gui.TrialKeystone.TRIAL_KEY_SLOT.TOP, TextureCoords.TRIAL_KEY_SLOT.X, TextureCoords.TRIAL_KEY_SLOT.Y, DMLConstants.Gui.TrialKeystone.TRIAL_KEY_SLOT.WIDTH, DMLConstants.Gui.TrialKeystone.TRIAL_KEY_SLOT.HEIGHT);
        this.drawPlayerInventory(this.field_147003_i + DMLConstants.Gui.TrialKeystone.PLAYER_INVENTORY.X, this.field_147009_r + DMLConstants.Gui.TrialKeystone.PLAYER_INVENTORY.Y);
        if (this.hasError) {
            int lines = this.errorStrings.size();
            int y = this.field_147009_r + GuiTrialKeystone.ERROR_TEXT_CENTER.Y - lines * 12 / 2;
            for (String errorString : this.errorStrings) {
                this.func_73732_a(this.field_146289_q, errorString, this.field_147003_i + GuiTrialKeystone.ERROR_TEXT_CENTER.X, y, 0xFFFFFF);
                y += 12;
            }
            return;
        }
        this.getAttunementData();
        if (this.attunementData == null) {
            return;
        }
        this.func_73729_b(this.field_147003_i + GuiTrialKeystone.TRIAL_INFO_OVERLAY.LEFT, this.field_147009_r + GuiTrialKeystone.TRIAL_INFO_OVERLAY.TOP, TextureCoords.TRIAL_INFO_OVERLAY.X, TextureCoords.TRIAL_INFO_OVERLAY.Y, GuiTrialKeystone.TRIAL_INFO_OVERLAY.WIDTH, GuiTrialKeystone.TRIAL_INFO_OVERLAY.HEIGHT);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"deepmoblearning.trial_keystone.trial_type", (Object[])new Object[0]), this.field_147003_i + GuiTrialKeystone.TRIAL_INFO_TEXT_LEFT.X, this.field_147009_r + GuiTrialKeystone.TRIAL_INFO_TEXT_LEFT.Y, 6478079);
        this.func_73731_b(this.field_146289_q, this.attunementData.getMobDisplayName(), this.field_147003_i + GuiTrialKeystone.TRIAL_INFO_TEXT_LEFT.X, this.field_147009_r + GuiTrialKeystone.TRIAL_INFO_TEXT_LEFT.Y + 12, 0xFFFFFF);
        ImmutableList<TrialAffix> affixes = this.trialKeystone.getAffixes();
        if (!affixes.isEmpty()) {
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"deepmoblearning.trial_keystone.affixes", (Object[])new Object[0]), this.field_147003_i + GuiTrialKeystone.TRIAL_INFO_TEXT_LEFT.X, this.field_147009_r + GuiTrialKeystone.TRIAL_INFO_TEXT_LEFT.Y + 24, 6478079);
            for (int i = 0; i < affixes.size(); ++i) {
                TrialAffix affix = (TrialAffix)affixes.get(i);
                this.func_73731_b(this.field_146289_q, affix.getAffixName(), this.field_147003_i + GuiTrialKeystone.TRIAL_INFO_TEXT_LEFT.X, this.field_147009_r + GuiTrialKeystone.TRIAL_INFO_TEXT_LEFT.Y + 12 * (3 + i), 0xFFFFFF);
            }
        }
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"deepmoblearning.trial_keystone.tier", (Object[])new Object[0]), this.field_147003_i + GuiTrialKeystone.TRIAL_INFO_TEXT_RIGHT.X, this.field_147009_r + GuiTrialKeystone.TRIAL_INFO_TEXT_RIGHT.Y, 6478079);
        this.func_73731_b(this.field_146289_q, this.attunementData.getTierDisplayNameFormatted(), this.field_147003_i + GuiTrialKeystone.TRIAL_INFO_TEXT_RIGHT.X + 25, this.field_147009_r + GuiTrialKeystone.TRIAL_INFO_TEXT_RIGHT.Y, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"deepmoblearning.trial_keystone.waves", (Object[])new Object[0]), this.field_147003_i + GuiTrialKeystone.TRIAL_INFO_TEXT_RIGHT.X, this.field_147009_r + GuiTrialKeystone.TRIAL_INFO_TEXT_RIGHT.Y + 12, 6478079);
        this.func_73731_b(this.field_146289_q, String.valueOf(this.attunementData.getMaxWave()), this.field_147003_i + GuiTrialKeystone.TRIAL_INFO_TEXT_RIGHT.X + 35, this.field_147009_r + GuiTrialKeystone.TRIAL_INFO_TEXT_RIGHT.Y + 12, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"deepmoblearning.trial_keystone.rewards", (Object[])new Object[0]), this.field_147003_i + GuiTrialKeystone.TRIAL_INFO_TEXT_RIGHT.X, this.field_147009_r + GuiTrialKeystone.TRIAL_INFO_TEXT_RIGHT.Y + 30, 6478079);
    }

    public List<Rectangle> getGuiExclusionAreas() {
        return ImmutableList.of((Object)new Rectangle(this.field_147003_i + DMLConstants.Gui.TrialKeystone.TRIAL_KEY_SLOT.LEFT, this.field_147009_r + DMLConstants.Gui.TrialKeystone.TRIAL_KEY_SLOT.TOP, DMLConstants.Gui.TrialKeystone.TRIAL_KEY_SLOT.WIDTH, DMLConstants.Gui.TrialKeystone.TRIAL_KEY_SLOT.HEIGHT));
    }

    private static final class TextureCoords {
        private static final Point MAIN_GUI = new Point(0, 0);
        private static final Point TRIAL_INFO_OVERLAY = new Point(18, 100);
        private static final Point TRIAL_KEY_SLOT = new Point(0, 100);

        private TextureCoords() {
        }
    }
}

