/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.client.jei;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mustapelto.deepmoblearning.client.jei.GuiExclusionHandlers;
import mustapelto.deepmoblearning.client.jei.fabricator.LootFabricatorCategory;
import mustapelto.deepmoblearning.client.jei.fabricator.LootFabricatorRecipe;
import mustapelto.deepmoblearning.client.jei.fabricator.LootFabricatorWrapper;
import mustapelto.deepmoblearning.client.jei.simulation.SimulationChamberCategory;
import mustapelto.deepmoblearning.client.jei.simulation.SimulationChamberRecipe;
import mustapelto.deepmoblearning.client.jei.simulation.SimulationChamberWrapper;
import mustapelto.deepmoblearning.client.jei.trial.TrialKeystoneRecipe;
import mustapelto.deepmoblearning.client.jei.trial.TrialKeystoneRecipeCategory;
import mustapelto.deepmoblearning.client.jei.trial.TrialKeystoneRecipeWrapper;
import mustapelto.deepmoblearning.common.DMLRegistry;
import mustapelto.deepmoblearning.common.items.ItemDataModel;
import mustapelto.deepmoblearning.common.items.ItemPristineMatter;
import mustapelto.deepmoblearning.common.metadata.MetadataDataModel;
import mustapelto.deepmoblearning.common.metadata.MetadataManager;
import mustapelto.deepmoblearning.common.trials.AttunementData;
import mustapelto.deepmoblearning.common.util.DataModelHelper;
import mustapelto.deepmoblearning.common.util.TrialKeyHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class DMLJeiPlugin
implements IModPlugin {
    private static SimulationChamberCategory simChamberCategory;
    private static LootFabricatorCategory lootFabricatorCategory;
    private static TrialKeystoneRecipeCategory trialKeystoneCategory;

    public void registerCategories(@Nonnull IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        simChamberCategory = new SimulationChamberCategory(guiHelper);
        lootFabricatorCategory = new LootFabricatorCategory(guiHelper);
        trialKeystoneCategory = new TrialKeystoneRecipeCategory(guiHelper);
        registry.addRecipeCategories(new IRecipeCategory[]{simChamberCategory});
        registry.addRecipeCategories(new IRecipeCategory[]{lootFabricatorCategory});
        registry.addRecipeCategories(new IRecipeCategory[]{trialKeystoneCategory});
    }

    public void register(@Nonnull IModRegistry registry) {
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new GuiExclusionHandlers.MachineGuiExclusion(), new GuiExclusionHandlers.TrialGuiExclusion()});
        registry.handleRecipes(SimulationChamberRecipe.class, SimulationChamberWrapper::new, simChamberCategory.getUid());
        for (ItemDataModel itemDataModel : DMLRegistry.getDataModels()) {
            MetadataDataModel metadata = itemDataModel.getDataModelMetadata();
            if (!metadata.isEnabled()) continue;
            ItemStack dataModel = new ItemStack((Item)itemDataModel);
            ItemStack livingMatter = metadata.getLivingMatter();
            ItemStack pristineMatter = metadata.getPristineMatter();
            DataModelHelper.setTierLevel(dataModel, 1);
            SimulationChamberRecipe.addRecipe(dataModel, livingMatter, pristineMatter);
        }
        registry.addRecipes(new ArrayList<SimulationChamberRecipe>(SimulationChamberRecipe.recipes), simChamberCategory.getUid());
        simChamberCategory.addCatalysts(registry);
        registry.handleRecipes(LootFabricatorRecipe.class, LootFabricatorWrapper::new, lootFabricatorCategory.getUid());
        HashMap<ItemStack, Object> pristineTables = new HashMap<ItemStack, Object>();
        for (ItemPristineMatter pristineMatter : DMLRegistry.getPristineMatters()) {
            MetadataDataModel metadata;
            ItemStack pristineStack = new ItemStack((Item)pristineMatter);
            Optional<MetadataDataModel> metadataOptional = ItemPristineMatter.getDataModelMetadata(pristineStack);
            if (!metadataOptional.isPresent() || !(metadata = metadataOptional.get()).isEnabled()) continue;
            pristineTables.put(pristineStack, metadata.getLootItems());
        }
        pristineTables.forEach((input, outputs) -> outputs.forEach(output -> LootFabricatorRecipe.addRecipe(input, output)));
        registry.addRecipes(new ArrayList<LootFabricatorRecipe>(LootFabricatorRecipe.recipes), lootFabricatorCategory.getUid());
        lootFabricatorCategory.addCatalysts(registry);
        registry.handleRecipes(TrialKeystoneRecipe.class, TrialKeystoneRecipeWrapper::new, trialKeystoneCategory.getUid());
        for (ItemDataModel itemDataModel : DMLRegistry.getDataModels()) {
            MetadataDataModel metadata = itemDataModel.getDataModelMetadata();
            if (!metadata.isEnabled()) continue;
            for (int i = MetadataManager.getMinDataModelTier(); i <= MetadataManager.getMaxDataModelTier(); ++i) {
                ItemStack trialKey = TrialKeyHelper.createAttunedKey(metadata, i);
                AttunementData attunement = TrialKeyHelper.getAttunement(trialKey).orElse(null);
                if (attunement == null) continue;
                TrialKeystoneRecipe.addRecipe(trialKey, attunement.getRewards(), attunement.getMobDisplayName(), attunement.getTierDisplayNameFormatted());
            }
        }
        registry.addRecipes(new ArrayList<TrialKeystoneRecipe>(TrialKeystoneRecipe.recipes), trialKeystoneCategory.getUid());
        trialKeystoneCategory.addCatalysts(registry);
        registry.addIngredientInfo((Object)new ItemStack((Item)DMLRegistry.ITEM_GLITCH_INGOT), VanillaTypes.ITEM, new String[]{"deepmoblearning.glitch_ingot.jei_info_1", "", "deepmoblearning.glitch_ingot.jei_info_2", "deepmoblearning.glitch_ingot.jei_info_3", "", "deepmoblearning.glitch_ingot.jei_info_4"});
    }
}

