/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.client.jei.fabricator;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mustapelto.deepmoblearning.client.jei.fabricator.LootFabricatorWrapper;
import mustapelto.deepmoblearning.common.DMLRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class LootFabricatorCategory
implements IRecipeCategory<LootFabricatorWrapper> {
    private final ItemStack catalyst;
    private final IDrawable background;
    private final IDrawableAnimated progress;

    public LootFabricatorCategory(IGuiHelper guiHelper) {
        ResourceLocation base = new ResourceLocation("deepmoblearning", "textures/gui/jei/extraction_chamber.png");
        this.catalyst = new ItemStack((Block)DMLRegistry.BLOCK_LOOT_FABRICATOR);
        this.background = guiHelper.createDrawable(base, 0, 0, 103, 30);
        IDrawableStatic progress = guiHelper.createDrawable(base, 0, 30, 35, 6);
        this.progress = guiHelper.createAnimatedDrawable(progress, 120, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void setRecipe(IRecipeLayout recipeLayout, @Nonnull LootFabricatorWrapper wrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 8, 6);
        guiItemStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        guiItemStacks.init(1, false, 76, 6);
        guiItemStacks.set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    @Nonnull
    public String getUid() {
        return "deepmoblearning.extraction_chamber";
    }

    @Nonnull
    public String getTitle() {
        return this.catalyst.func_82833_r();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.progress.draw(minecraft, 34, 12);
    }

    @Nonnull
    public String getModName() {
        return "deepmoblearning";
    }

    public void addCatalysts(IModRegistry registry) {
        registry.addRecipeCatalyst((Object)this.catalyst, new String[]{this.getUid()});
    }
}

