/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.client.jei.simulation;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mustapelto.deepmoblearning.client.jei.simulation.SimulationChamberWrapper;
import mustapelto.deepmoblearning.common.DMLRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SimulationChamberCategory
implements IRecipeCategory<SimulationChamberWrapper> {
    private final ItemStack catalyst;
    private final IDrawable background;
    private final IDrawableAnimated progress;

    public SimulationChamberCategory(IGuiHelper guiHelper) {
        ResourceLocation base = new ResourceLocation("deepmoblearning", "textures/gui/jei/simulation_chamber.png");
        this.catalyst = new ItemStack((Block)DMLRegistry.BLOCK_SIMULATION_CHAMBER);
        this.background = guiHelper.createDrawable(base, 0, 0, 116, 43);
        IDrawableStatic progress = guiHelper.createDrawable(base, 0, 43, 35, 6);
        this.progress = guiHelper.createAnimatedDrawable(progress, 120, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void setRecipe(@Nonnull IRecipeLayout layout, @Nonnull SimulationChamberWrapper wrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        guiItemStacks.init(0, true, 3, 3);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiItemStacks.init(1, true, 27, 3);
        guiItemStacks.set(1, (List)inputs.get(1));
        guiItemStacks.init(2, false, 95, 3);
        guiItemStacks.set(2, (List)outputs.get(0));
        guiItemStacks.init(3, false, 75, 25);
        guiItemStacks.set(3, (List)outputs.get(1));
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.progress.draw(minecraft, 52, 9);
    }

    @Nonnull
    public String getUid() {
        return "deepmoblearning.simulation_chamber";
    }

    @Nonnull
    public String getTitle() {
        return this.catalyst.func_82833_r();
    }

    @Nonnull
    public String getModName() {
        return "deepmoblearning";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void addCatalysts(IModRegistry registry) {
        registry.addRecipeCatalyst((Object)this.catalyst, new String[]{this.getUid()});
    }
}

