/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="deepmoblearning", name="deepmobevolution/deepmobevolution", category="")
@Mod.EventBusSubscriber
public class DMLConfig {
    @Config.Name(value="Misc Settings")
    public static MiscSettings MISC_SETTINGS = new MiscSettings();
    @Config.Name(value="Machine Settings")
    public static MachineSettings MACHINE_SETTINGS = new MachineSettings();
    @Config.Name(value="Glitch Armor Settings")
    public static GlitchArmorSettings GLITCH_ARMOR_SETTINGS = new GlitchArmorSettings();
    @Config.Name(value="Deep Learner GUI Overlay Settings")
    public static DeepLearnerGuiOverlaySettings DEEP_LEARNER_GUI_OVERLAY_SETTINGS = new DeepLearnerGuiOverlaySettings();

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("deepmoblearning")) {
            ConfigManager.sync((String)"deepmoblearning", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class MiscSettings {
        @Config.Name(value="Show Data Model tier in item name?")
        public boolean SHOW_TIER_IN_NAME = true;
        @Config.Name(value="Is Soot-Covered Redstone Crafting Enabled?")
        public boolean SOOT_COVERED_REDSTONE_CRAFTING_ENABLED = true;
    }

    public static class MachineSettings {
        @Config.Name(value="Simulation Chamber Processing Time")
        @Config.Comment(value={"Time it takes for the Simulation Chamber to run one iteration (in ticks)"})
        @Config.RangeInt(min=1)
        public int SIMULATION_CHAMBER_PROCESSING_TIME = 301;
        @Config.Name(value="Loot Fabricator RF Cost")
        @Config.Comment(value={"Energy cost of Loot Fabricator in RF/t"})
        @Config.RangeInt(min=0)
        public int LOOT_FABRICATOR_RF_COST = 256;
        @Config.Name(value="Loot Fabricator Processing Time")
        @Config.Comment(value={"Time it takes for the Loot Fabricator to process one item (in ticks)"})
        @Config.RangeInt(min=1)
        public int LOOT_FABRICATOR_PROCESSING_TIME = 51;
        @Config.Name(value="Legacy Machine Sidedness")
        @Config.Comment(value={"Use legacy sidedness (insert from top, output to all other sides)?"})
        public boolean LEGACY_MACHINE_SIDEDNESS = false;
    }

    public static class GlitchArmorSettings {
        @Config.Name(value="Glitch Armor Pristine Chance")
        @Config.Comment(value={"Chance to drop Pristine Matter on Data Model mob kill with full Glitch Armor equipped"})
        @Config.RangeInt(min=0, max=100)
        public int GLITCH_ARMOR_PRISTINE_CHANCE = 18;
        @Config.Name(value="Glitch Armor Pristine Count")
        @Config.Comment(value={"Number of Pristine Matter to drop on Data Model mob kill with full Glitch Armor equipped"})
        @Config.RangeInt(min=0, max=64)
        public int GLITCH_ARMOR_PRISTINE_COUNT = 2;
        @Config.Name(value="Is Glitch Armor Creative Flight Enabled?")
        public boolean GLITCH_CREATIVE_FLIGHT_ENABLED = true;
    }

    public static class DeepLearnerGuiOverlaySettings {
        @Config.Name(value="Position")
        @Config.Comment(value={"Overlay screen position. Valid values: topleft / topright / bottomright / bottomleft"})
        public String POSITION = "topleft";
        @Config.Name(value="Horizontal Padding")
        @Config.Comment(value={"Horizontal padding from selected corner"})
        public int PADDING_HORIZONTAL = 0;
        @Config.Name(value="Vertical Padding")
        @Config.Comment(value={"Vertical padding from selected corner"})
        public int PADDING_VERTICAL = 0;

        public GuiPosition getGuiPosition() {
            return GuiPosition.fromString(this.POSITION);
        }

        public static enum GuiPosition {
            TOP_LEFT("topleft"),
            TOP_RIGHT("topright"),
            BOTTOM_RIGHT("bottomright"),
            BOTTOM_LEFT("bottomleft");

            private final String value;
            private static final Map<String, GuiPosition> map;

            private GuiPosition(String value) {
                this.value = value;
            }

            public static GuiPosition fromString(String positionString) {
                return map.getOrDefault(positionString, TOP_LEFT);
            }

            static {
                map = new HashMap<String, GuiPosition>();
                for (GuiPosition position : GuiPosition.values()) {
                    map.put(position.value, position);
                }
            }
        }
    }
}

