/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.metadata;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import mustapelto.deepmoblearning.DMLConstants;
import mustapelto.deepmoblearning.DMLRelearned;
import mustapelto.deepmoblearning.common.DMLRegistry;
import mustapelto.deepmoblearning.common.metadata.Metadata;
import mustapelto.deepmoblearning.common.util.DMLRHelper;
import mustapelto.deepmoblearning.common.util.ItemStackDefinitionHelper;
import mustapelto.deepmoblearning.common.util.StringHelper;
import mustapelto.deepmoblearning.common.util.WeightedString;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class MetadataDataModel
extends Metadata {
    private static final String DATA_MODEL_ID = "id";
    private static final String MOD_ID = "mod";
    private static final String DISPLAY_NAME = "displayName";
    private static final String DISPLAY_NAME_PLURAL = "displayNamePlural";
    private static final String LIVING_MATTER = "livingMatter";
    private static final String SIMULATION_RF_COST = "simulationRFCost";
    private static final String EXTRA_TOOLTIP = "extraTooltip";
    private static final String CRAFTING_INGREDIENTS = "craftingIngredients";
    private static final String ASSOCIATED_MOBS = "associatedMobs";
    private static final String LOOT_ITEMS = "lootItems";
    private static final String TRIAL = "trial";
    private static final String DEEP_LEARNER_DISPLAY = "deepLearnerDisplay";
    private static final String[] REQUIRED_KEYS = new String[]{"id", "livingMatter", "craftingIngredients", "associatedMobs", "lootItems"};
    private static final String DEFAULT_DATA_MODEL_ID = "";
    private static final String DEFAULT_MOD_ID = "minecraft";
    private static final String DEFAULT_DISPLAY_NAME_PLURAL = "%ss";
    private static final String DEFAULT_LIVING_MATTER = "";
    private static final int DEFAULT_SIMULATION_RF_COST = 256;
    private static final String DEFAULT_EXTRA_TOOLTIP = "";
    private final String dataModelID;
    private final String modID;
    private final boolean isEnabled;
    private final String displayName;
    private final String displayNamePlural;
    private final String livingMatterString;
    private final int simulationRFCost;
    private final String extraTooltip;
    private final ImmutableList<String> craftingIngredientStrings;
    private final ImmutableList<String> associatedMobStrings;
    private final ImmutableList<String> lootItemStrings;
    private final TrialData trialData;
    private final DeepLearnerDisplayData deepLearnerDisplayData;
    private ImmutableList<ResourceLocation> associatedMobs;
    private ImmutableList<ItemStack> lootItems;
    private ItemStack livingMatter;
    private ItemStack pristineMatter;

    public MetadataDataModel(JsonObject data) throws IllegalArgumentException {
        if (MetadataDataModel.isInvalidJson(data, REQUIRED_KEYS)) {
            throw new IllegalArgumentException("Invalid Data Model JSON entry!");
        }
        this.dataModelID = MetadataDataModel.getString(data, DATA_MODEL_ID).orElse("");
        this.modID = MetadataDataModel.getString(data, MOD_ID).orElse(DEFAULT_MOD_ID);
        this.isEnabled = DMLRHelper.isModLoaded(this.modID);
        this.displayName = MetadataDataModel.getString(data, DISPLAY_NAME).orElse(StringHelper.uppercaseFirst(this.dataModelID));
        this.displayNamePlural = MetadataDataModel.getString(data, DISPLAY_NAME_PLURAL).orElse(String.format(DEFAULT_DISPLAY_NAME_PLURAL, this.displayName));
        this.livingMatterString = MetadataDataModel.getString(data, LIVING_MATTER).orElse("");
        this.simulationRFCost = MetadataDataModel.getInt(data, SIMULATION_RF_COST, 0, 25600).orElse(256);
        this.extraTooltip = MetadataDataModel.getString(data, EXTRA_TOOLTIP).orElse("");
        this.craftingIngredientStrings = MetadataDataModel.getStringList(data, CRAFTING_INGREDIENTS).orElse((ImmutableList<String>)ImmutableList.of());
        this.associatedMobStrings = MetadataDataModel.getStringList(data, ASSOCIATED_MOBS).orElse((ImmutableList<String>)ImmutableList.of());
        this.lootItemStrings = MetadataDataModel.getStringList(data, LOOT_ITEMS).orElse((ImmutableList<String>)ImmutableList.of());
        JsonObject trialDataJSON = MetadataDataModel.getJsonObject(data, TRIAL).orElse(null);
        if (trialDataJSON == null) {
            this.trialData = new TrialData(this);
            DMLRelearned.logger.warn("Missing Trial JSON entry in config for Data Model {}:{}. Using default values.", (Object)this.modID, (Object)this.dataModelID);
        } else {
            this.trialData = new TrialData(trialDataJSON, this);
        }
        JsonObject deepLearnerDisplayJSON = MetadataDataModel.getJsonObject(data, DEEP_LEARNER_DISPLAY).orElse(null);
        if (deepLearnerDisplayJSON == null) {
            this.deepLearnerDisplayData = new DeepLearnerDisplayData(this);
            DMLRelearned.logger.warn("Missing Deep Learner display JSON object in entry {}:{}. Using default values.", (Object)this.modID, (Object)this.dataModelID);
        } else {
            this.deepLearnerDisplayData = new DeepLearnerDisplayData(deepLearnerDisplayJSON, this);
        }
    }

    @Override
    public void finalizeData() {
        if (!DMLRHelper.isModLoaded(this.modID) || !this.isEnabled) {
            return;
        }
        ImmutableList.Builder mobListBuilder = ImmutableList.builder();
        boolean hasValidMobs = false;
        for (String entry : this.associatedMobStrings) {
            if (DMLRHelper.isRegisteredEntity(entry)) {
                mobListBuilder.add((Object)new ResourceLocation(entry));
                hasValidMobs = true;
                continue;
            }
            DMLRelearned.logger.warn("Invalid entry \"{}\" in Associated Mobs list for Data Model: {}. No registered entity of this name found!", (Object)entry, (Object)this.dataModelID);
        }
        if (!hasValidMobs) {
            String defaultMob = DMLRHelper.getRegistryString(this.modID, this.dataModelID);
            if (DMLRHelper.isRegisteredEntity(defaultMob)) {
                mobListBuilder.add((Object)new ResourceLocation(defaultMob));
                DMLRelearned.logger.warn("No valid Associated Mob entries for Data Model: {}. Using default mob ({}).", (Object)this.dataModelID, (Object)defaultMob);
            } else {
                DMLRelearned.logger.error("No valid Associated Mob entries for Data Model: {}. Model will not be able to gain data!", (Object)this.dataModelID);
            }
        }
        this.associatedMobs = mobListBuilder.build();
        this.lootItems = ItemStackDefinitionHelper.itemStackListFromStringList(this.lootItemStrings);
        if (this.lootItems.isEmpty()) {
            DMLRelearned.logger.error("No valid Loot Items found for Data Model: {}. This Model's Pristine Matter won't be able to produce any loot!", (Object)this.dataModelID);
        }
        this.livingMatter = DMLRegistry.getLivingMatter(this.livingMatterString);
        this.pristineMatter = DMLRegistry.getPristineMatter(this.dataModelID);
        this.trialData.finalizeData();
        this.deepLearnerDisplayData.finalizeData();
    }

    @Override
    public String getID() {
        return this.dataModelID;
    }

    public String getModID() {
        return this.modID;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String getDataModelRegistryID() {
        return "data_model_" + this.dataModelID;
    }

    public String getPristineMatterRegistryID() {
        return "pristine_matter_" + this.dataModelID;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNamePlural() {
        return this.displayNamePlural;
    }

    public int getSimulationRFCost() {
        return this.simulationRFCost;
    }

    public ItemStack getLivingMatter(int size) {
        ItemStack result = this.livingMatter.func_77946_l();
        result.func_190920_e(size);
        return result;
    }

    public ItemStack getLivingMatter() {
        return this.getLivingMatter(1);
    }

    public ItemStack getPristineMatter(int size) {
        ItemStack result = this.pristineMatter.func_77946_l();
        result.func_190920_e(size);
        return result;
    }

    public ItemStack getPristineMatter() {
        return this.getPristineMatter(1);
    }

    public String getExtraTooltip() {
        return this.extraTooltip;
    }

    public TrialData getTrialData() {
        return this.trialData;
    }

    public DeepLearnerDisplayData getDeepLearnerDisplayData() {
        return this.deepLearnerDisplayData;
    }

    public ResourceLocation getDataModelTexture() {
        try {
            ResourceLocation locationFromId = new ResourceLocation("deepmoblearning", "textures/items/" + this.getDataModelRegistryID() + ".png");
            Minecraft.func_71410_x().func_110442_L().func_135056_b(locationFromId);
            return new ResourceLocation("deepmoblearning", "items/" + this.getDataModelRegistryID());
        }
        catch (IOException e) {
            DMLRelearned.logger.info("Data Model texture not found for entry {}:{}. Using default texture.", (Object)this.modID, (Object)this.dataModelID);
            return DMLConstants.DefaultModels.DATA_MODEL;
        }
    }

    public ResourceLocation getPristineMatterTexture() {
        try {
            ResourceLocation locationFromId = new ResourceLocation("deepmoblearning", "textures/items/" + this.getPristineMatterRegistryID() + ".png");
            Minecraft.func_71410_x().func_110442_L().func_135056_b(locationFromId);
            return new ResourceLocation("deepmoblearning", "items/" + this.getPristineMatterRegistryID());
        }
        catch (IOException e) {
            DMLRelearned.logger.info("Pristine Matter texture not found for entry {}:{}. Using default texture.", (Object)this.modID, (Object)this.dataModelID);
            return DMLConstants.DefaultModels.PRISTINE_MATTER;
        }
    }

    public boolean isAssociatedMob(EntityLivingBase entity) {
        EntityEntry entityEntry = EntityRegistry.getEntry(entity.getClass());
        if (entityEntry == null) {
            return false;
        }
        ResourceLocation registryName = entityEntry.getRegistryName();
        if (registryName == null) {
            return false;
        }
        return this.associatedMobs.contains((Object)registryName);
    }

    public ImmutableList<ItemStack> getLootItems() {
        if (this.lootItems == null) {
            return ImmutableList.of();
        }
        return this.lootItems;
    }

    public ItemStack getLootItem(int index) {
        if (index >= 0 && index < this.lootItems.size()) {
            return ((ItemStack)this.lootItems.get(index)).func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasLootItem(ItemStack item) {
        for (ItemStack lootItem : this.lootItems) {
            if (!ItemStack.func_77989_b((ItemStack)item, (ItemStack)lootItem)) continue;
            return true;
        }
        return false;
    }

    public int getLootItemIndex(ItemStack item) {
        if (this.lootItems.isEmpty() || !this.hasLootItem(item)) {
            return -1;
        }
        for (int i = 0; i < this.lootItems.size(); ++i) {
            if (!ItemStack.func_77989_b((ItemStack)((ItemStack)this.lootItems.get(i)), (ItemStack)item)) continue;
            return i;
        }
        return -1;
    }

    public Optional<IRecipe> getCraftingRecipe() {
        ItemStack output = DMLRegistry.getDataModel(this.dataModelID);
        if (output.func_190926_b()) {
            return Optional.empty();
        }
        NonNullList ingredients = NonNullList.func_191196_a();
        Ingredient blankModel = CraftingHelper.getIngredient((Object)new ItemStack((Item)DMLRegistry.ITEM_DATA_MODEL_BLANK));
        ingredients.add((Object)blankModel);
        boolean isOreRecipe = false;
        ImmutableList<Ingredient> customIngredients = ItemStackDefinitionHelper.ingredientListFromStringList(this.craftingIngredientStrings);
        for (Ingredient ingredient : customIngredients) {
            if (ingredient.equals(Ingredient.field_193370_a)) {
                DMLRelearned.logger.warn("Invalid Data Model crafting ingredient. Skipping.");
                continue;
            }
            if (ingredient instanceof OreIngredient) {
                isOreRecipe = true;
            }
            ingredients.add((Object)ingredient);
        }
        ResourceLocation recipeGroup = new ResourceLocation("deepmoblearning", "data_models");
        Object result = isOreRecipe ? new ShapelessOreRecipe(recipeGroup, output, new Object[]{ingredients}) : new ShapelessRecipes(recipeGroup.toString(), output, ingredients);
        result.setRegistryName(output.func_77973_b().getRegistryName());
        return Optional.of(result);
    }

    public static class TrialData {
        private static final String ENTITIES = "entities";
        private static final String MOBS_PER_WAVE = "mobsPerWave";
        private static final String SPAWN_DELAY = "spawnDelay";
        private static final String REWARDS = "rewards";
        private static final int DEFAULT_MOBS_PER_WAVE = 4;
        private static final double DEFAULT_SPAWN_DELAY = 2.0;
        private final MetadataDataModel container;
        private final ImmutableList<WeightedString> entityStrings;
        private final ImmutableList<Integer> mobsPerWave;
        private final double spawnDelay;
        private final ImmutableList<String> rewardStrings;
        private ImmutableList<WeightedString> entities;
        private ImmutableList<ItemStack> rewards;

        public TrialData(MetadataDataModel container) {
            this.container = container;
            this.entityStrings = ImmutableList.of();
            this.mobsPerWave = ImmutableList.of();
            this.spawnDelay = 2.0;
            this.rewardStrings = ImmutableList.of();
            this.entities = ImmutableList.of();
            this.rewards = ImmutableList.of();
        }

        public TrialData(JsonObject data, MetadataDataModel container) {
            this.container = container;
            this.entityStrings = Metadata.getWeightedStringList(data, ENTITIES).orElse((ImmutableList<WeightedString>)ImmutableList.of());
            this.mobsPerWave = Metadata.getIntList(data, MOBS_PER_WAVE).orElse((ImmutableList<Integer>)ImmutableList.of((Object)4));
            this.spawnDelay = Metadata.getDouble(data, SPAWN_DELAY, 0.0, 20.0).orElse(2.0);
            this.rewardStrings = Metadata.getStringList(data, REWARDS).orElse((ImmutableList<String>)ImmutableList.of());
        }

        public void finalizeData() {
            this.buildValidatedEntityList();
            this.rewards = ItemStackDefinitionHelper.itemStackListFromStringList(this.rewardStrings);
        }

        private void buildValidatedEntityList() {
            DMLRelearned.logger.info("Registering Trial for {}", (Object)this.container.getDisplayName());
            boolean hasValidEntities = false;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (WeightedString entry : this.entityStrings) {
                String entityString = entry.getValue();
                if (!DMLRHelper.isRegisteredEntity(entityString)) {
                    DMLRelearned.logger.warn("Invalid entry \"{}\" in Trial entity list for Data Model: {}. No registered entity of this name found!", (Object)entityString, (Object)this.container.dataModelID);
                    continue;
                }
                DMLRelearned.logger.info("Registering Trial entity {} with weight {}", (Object)entityString, (Object)entry.field_76292_a);
                builder.add((Object)new WeightedString(entityString, entry.field_76292_a));
                hasValidEntities = true;
            }
            if (!hasValidEntities) {
                DMLRelearned.logger.info("No Trial available for {}", (Object)this.container.getDisplayName());
            }
            this.entities = builder.build();
        }

        public boolean hasEntity() {
            return this.entities.size() > 0;
        }

        public Optional<EntityLiving> getRandomEntity(World world) {
            String entityName = ((WeightedString)WeightedRandom.func_76271_a((Random)ThreadLocalRandom.current(), this.entities)).getValue();
            ResourceLocation entityResource = new ResourceLocation(entityName);
            Entity entity = EntityList.func_188429_b((ResourceLocation)entityResource, (World)world);
            return entity instanceof EntityLiving ? Optional.of((EntityLiving)entity) : Optional.empty();
        }

        public double getSpawnDelay() {
            return this.spawnDelay;
        }

        public ImmutableList<ItemStack> getRewards() {
            if (this.rewards == null) {
                return ImmutableList.of();
            }
            return this.rewards;
        }

        public int getMobsPerWave(int wave) {
            if (wave < 0) {
                return 0;
            }
            if (wave >= this.mobsPerWave.size()) {
                return (Integer)this.mobsPerWave.get(this.mobsPerWave.size() - 1);
            }
            return (Integer)this.mobsPerWave.get(wave);
        }
    }

    public static class DeepLearnerDisplayData {
        private static final String HEARTS = "hearts";
        private static final String MOB_TRIVIA = "mobTrivia";
        private static final String ENTITY = "entity";
        private static final String ENTITY_HELD_ITEM = "entityHeldItem";
        private static final String ENTITY_SCALE = "entityScale";
        private static final String ENTITY_OFFSET_X = "entityOffsetX";
        private static final String ENTITY_OFFSET_Y = "entityOffsetY";
        private static final String EXTRA_ENTITY = "extraEntity";
        private static final String EXTRA_ENTITY_IS_CHILD = "extraEntityIsChild";
        private static final String EXTRA_ENTITY_OFFSET_X = "extraEntityOffsetX";
        private static final String EXTRA_ENTITY_OFFSET_Y = "extraEntityOffsetY";
        private static final int DEFAULT_HEARTS = 0;
        private static final String DEFAULT_MOB_TRIVIA = "Nothing is known about this mob.";
        private static final int DEFAULT_ENTITY_SCALE = 40;
        private static final int DEFAULT_ENTITY_OFFSET_X = 0;
        private static final int DEFAULT_ENTITY_OFFSET_Y = 0;
        private static final boolean DEFAULT_EXTRA_ENTITY_IS_CHILD = false;
        private static final int DEFAULT_EXTRA_ENTITY_OFFSET_X = 0;
        private static final int DEFAULT_EXTRA_ENTITY_OFFSET_Y = 0;
        private final int hearts;
        private final ImmutableList<String> mobTrivia;
        private final ResourceLocation entity;
        private final ResourceLocation entityHeldItem;
        private final int entityScale;
        private final int entityOffsetX;
        private final int entityOffsetY;
        private final ResourceLocation extraEntityName;
        private final boolean extraEntityIsChild;
        private final int extraEntityOffsetX;
        private final int extraEntityOffsetY;
        private ResourceLocation entityValidated;
        private final MetadataDataModel container;

        public DeepLearnerDisplayData(MetadataDataModel container) {
            this.container = container;
            this.hearts = 0;
            this.mobTrivia = ImmutableList.of();
            this.entity = null;
            this.entityHeldItem = null;
            this.entityScale = 1;
            this.entityOffsetX = 0;
            this.entityOffsetY = 0;
            this.extraEntityName = null;
            this.extraEntityIsChild = false;
            this.extraEntityOffsetX = 0;
            this.extraEntityOffsetY = 0;
        }

        public DeepLearnerDisplayData(JsonObject data, MetadataDataModel container) {
            this.container = container;
            this.hearts = Metadata.getInt(data, HEARTS, 0, Integer.MAX_VALUE).orElse(0);
            this.mobTrivia = Metadata.getStringList(data, MOB_TRIVIA).orElse((ImmutableList<String>)ImmutableList.of((Object)DEFAULT_MOB_TRIVIA));
            this.entity = Metadata.getResourceLocation(data, ENTITY).orElse(null);
            this.entityHeldItem = Metadata.getResourceLocation(data, ENTITY_HELD_ITEM).orElse(null);
            this.entityScale = Metadata.getInt(data, ENTITY_SCALE, 0, 200).orElse(40);
            this.entityOffsetX = Metadata.getInt(data, ENTITY_OFFSET_X, -200, 200).orElse(0);
            this.entityOffsetY = Metadata.getInt(data, ENTITY_OFFSET_Y, -200, 200).orElse(0);
            this.extraEntityName = Metadata.getResourceLocation(data, EXTRA_ENTITY).orElse(null);
            this.extraEntityIsChild = Metadata.getBoolean(data, EXTRA_ENTITY_IS_CHILD).orElse(false);
            this.extraEntityOffsetX = Metadata.getInt(data, EXTRA_ENTITY_OFFSET_X, -200, 200).orElse(0);
            this.extraEntityOffsetY = Metadata.getInt(data, EXTRA_ENTITY_OFFSET_Y, -200, 200).orElse(0);
        }

        public void finalizeData() {
            this.entityValidated = this.entity == null && !this.container.associatedMobs.isEmpty() ? (ResourceLocation)this.container.associatedMobs.get(0) : this.entity;
        }

        public int getHearts() {
            return this.hearts;
        }

        public ImmutableList<String> getMobTrivia() {
            return this.mobTrivia;
        }

        public Optional<Entity> getEntity(World world) {
            Item heldItem;
            if (!EntityList.func_180125_b((ResourceLocation)this.entityValidated)) {
                return Optional.empty();
            }
            Entity entity = EntityList.func_188429_b((ResourceLocation)this.entityValidated, (World)world);
            if (entity instanceof EntityLiving && this.entityHeldItem != null && (heldItem = Item.func_111206_d((String)this.entityHeldItem.toString())) != null) {
                ((EntityLiving)entity).func_184611_a(EnumHand.MAIN_HAND, new ItemStack(heldItem));
            }
            return entity != null ? Optional.of(entity) : Optional.empty();
        }

        public int getEntityScale() {
            return this.entityScale;
        }

        public int getEntityOffsetX() {
            return this.entityOffsetX;
        }

        public int getEntityOffsetY() {
            return this.entityOffsetY;
        }

        public Optional<Entity> getExtraEntity(World world) {
            if (!EntityList.func_180125_b((ResourceLocation)this.extraEntityName)) {
                return Optional.empty();
            }
            Entity entity = EntityList.func_188429_b((ResourceLocation)this.extraEntityName, (World)world);
            if (this.extraEntityIsChild) {
                if (entity instanceof EntityZombie) {
                    ((EntityZombie)entity).func_82227_f(true);
                } else if (entity instanceof EntityAgeable) {
                    ((EntityAgeable)entity).func_70873_a(-1000000);
                }
            }
            return entity != null ? Optional.of(entity) : Optional.empty();
        }

        public int getExtraEntityOffsetX() {
            return this.extraEntityOffsetX;
        }

        public int getExtraEntityOffsetY() {
            return this.extraEntityOffsetY;
        }
    }
}

