/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.metadata;

import com.google.gson.JsonObject;
import java.io.IOException;
import mustapelto.deepmoblearning.DMLConstants;
import mustapelto.deepmoblearning.DMLRelearned;
import mustapelto.deepmoblearning.common.DMLRegistry;
import mustapelto.deepmoblearning.common.metadata.Metadata;
import mustapelto.deepmoblearning.common.util.StringHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class MetadataLivingMatter
extends Metadata {
    private static final String LIVING_MATTER_ID = "id";
    private static final String MOD_ID = "mod";
    private static final String DISPLAY_NAME = "displayName";
    private static final String DISPLAY_COLOR = "displayColor";
    private static final String XP_VALUE = "xpValue";
    private static final String[] REQUIRED_KEYS = new String[]{"id"};
    private static final String DEFAULT_LIVING_MATTER_ID = "";
    private static final String DEFAULT_MOD_ID = "minecraft";
    private static final String DEFAULT_DISPLAY_COLOR = "white";
    private static final int DEFAULT_XP_VALUE = 10;
    private final String livingMatterID;
    private final String modID;
    private final String displayName;
    private final int xpValue;
    private final String displayNameFormatted;
    private ItemStack itemStack;

    public MetadataLivingMatter(JsonObject data) throws IllegalArgumentException {
        if (MetadataLivingMatter.isInvalidJson(data, REQUIRED_KEYS)) {
            throw new IllegalArgumentException("Invalid Living Matter JSON entry!");
        }
        this.livingMatterID = MetadataLivingMatter.getString(data, LIVING_MATTER_ID).orElse(DEFAULT_LIVING_MATTER_ID);
        this.modID = MetadataLivingMatter.getString(data, MOD_ID).orElse(DEFAULT_MOD_ID);
        this.displayName = MetadataLivingMatter.getString(data, DISPLAY_NAME).orElse(StringHelper.uppercaseFirst(this.livingMatterID));
        String displayColorString = MetadataLivingMatter.getString(data, DISPLAY_COLOR).orElse(DEFAULT_DISPLAY_COLOR);
        TextFormatting displayColor = StringHelper.getValidFormatting(displayColorString);
        this.displayNameFormatted = StringHelper.getFormattedString(this.displayName, displayColor);
        this.xpValue = MetadataLivingMatter.getInt(data, XP_VALUE, 0, 1000).orElse(10);
    }

    @Override
    public void finalizeData() {
        this.itemStack = DMLRegistry.getLivingMatter(this.livingMatterID);
    }

    @Override
    public String getID() {
        return this.livingMatterID;
    }

    public String getModID() {
        return this.modID;
    }

    public String getRegistryID() {
        return "living_matter_" + this.livingMatterID;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameFormatted() {
        return this.displayNameFormatted;
    }

    public int getXpValue() {
        return this.xpValue;
    }

    public ItemStack getItemStack(int size) {
        ItemStack result = this.itemStack.func_77946_l();
        result.func_190920_e(size);
        return result;
    }

    public ItemStack getItemStack() {
        return this.getItemStack(1);
    }

    public ResourceLocation getLivingMatterTexture() {
        try {
            ResourceLocation locationFromId = new ResourceLocation("deepmoblearning", "textures/items/" + this.getRegistryID() + ".png");
            Minecraft.func_71410_x().func_110442_L().func_135056_b(locationFromId);
            return new ResourceLocation("deepmoblearning", "items/" + this.getRegistryID());
        }
        catch (IOException e) {
            DMLRelearned.logger.info("Living Matter texture not found for entry: {}. Using default texture.", (Object)this.livingMatterID);
            return DMLConstants.DefaultModels.LIVING_MATTER;
        }
    }
}

