/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import mustapelto.deepmoblearning.DMLConstants;
import mustapelto.deepmoblearning.DMLRelearned;
import mustapelto.deepmoblearning.common.metadata.MetadataDataModel;
import mustapelto.deepmoblearning.common.metadata.MetadataDataModelTier;
import mustapelto.deepmoblearning.common.metadata.MetadataLivingMatter;
import mustapelto.deepmoblearning.common.util.DMLRHelper;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class MetadataManager {
    private static final String INTERNAL_PATH = "/settings/";
    private static final String DATA_MODEL_FILE = "DataModels.json";
    private static final String DATA_MODEL_TIER_FILE = "DataModelTiers.json";
    private static final String LIVING_MATTER_FILE = "LivingMatter.json";
    private static final String LIVING_MATTER_RECIPES_FILE = "LivingMatterRecipes.json";
    private static File configDir;
    private static ImmutableMap<String, MetadataDataModel> dataModelStore;
    private static ImmutableSortedMap<Integer, MetadataDataModelTier> dataModelTierStore;
    private static ImmutableMap<String, MetadataLivingMatter> livingMatterStore;
    private static ImmutableList<JsonObject> livingMatterRecipesJson;

    public static void init(FMLPreInitializationEvent event) throws IOException {
        DMLRelearned.logger.info("Loading data from JSON config files...");
        configDir = new File(event.getModConfigurationDirectory(), "deepmobevolution");
        if (!configDir.exists() && !configDir.mkdirs()) {
            throw new IOException("Could not create mod config directory!");
        }
        MetadataManager.copyConfigFile(DATA_MODEL_FILE).flatMap(MetadataManager::readConfigFile).ifPresent(MetadataManager::initDataModelStore);
        MetadataManager.copyConfigFile(DATA_MODEL_TIER_FILE).flatMap(MetadataManager::readConfigFile).ifPresent(MetadataManager::initDataModelTierStore);
        MetadataManager.copyConfigFile(LIVING_MATTER_FILE).flatMap(MetadataManager::readConfigFile).ifPresent(MetadataManager::initLivingMatterStore);
        MetadataManager.copyConfigFile(LIVING_MATTER_RECIPES_FILE).flatMap(MetadataManager::readConfigFile).ifPresent(MetadataManager::readLivingMatterRecipes);
    }

    public static void finalizeData() {
        DMLRelearned.logger.info("Finalizing config data...");
        dataModelStore.values().forEach(MetadataDataModel::finalizeData);
        dataModelTierStore.values().forEach(MetadataDataModelTier::finalizeData);
        livingMatterStore.values().forEach(MetadataLivingMatter::finalizeData);
    }

    private static Optional<File> copyConfigFile(String filename) {
        File file = new File(configDir, filename);
        if (!file.exists()) {
            try (InputStream input = DMLRelearned.class.getResourceAsStream(INTERNAL_PATH + filename);){
                Files.copy(input, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                DMLRelearned.logger.error("Error extracting default config file \"{}\" from mod jar!", (Object)filename);
                return Optional.empty();
            }
        }
        return Optional.of(file);
    }

    private static Optional<JsonArray> readConfigFile(File file) {
        JsonElement result;
        FileReader fileReader;
        String filename = file.getName();
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            DMLRelearned.logger.error("Config file \"{}\" not found! Error message: {}", (Object)filename, (Object)e.getMessage());
            return Optional.empty();
        }
        try (JsonReader reader = new JsonReader((Reader)fileReader);){
            JsonParser parser = new JsonParser();
            reader.setLenient(true);
            result = parser.parse(reader);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                DMLRelearned.logger.error("Error reading config file \"{}\"! Error message: {}", (Object)filename, (Object)e.getMessage());
            } else if (e instanceof JsonSyntaxException) {
                DMLRelearned.logger.error("Invalid JSON in config file \"{}\"! Error message: {}", (Object)filename, (Object)e.getMessage());
            } else {
                DMLRelearned.logger.error("Exception while reading config file \"{}\"! Error message: {}", (Object)filename, (Object)e.getMessage());
            }
            return Optional.empty();
        }
        if (!result.isJsonArray()) {
            DMLRelearned.logger.error("Error parsing config file \"{}\": root element must be an array!", (Object)filename);
            return Optional.empty();
        }
        return Optional.of(result.getAsJsonArray());
    }

    private static void initDataModelStore(JsonArray json) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < json.size(); ++i) {
            MetadataDataModel metadata;
            JsonElement entry = json.get(i);
            if (!entry.isJsonObject()) {
                DMLRelearned.logger.warn(MetadataManager.getInvalidEntryString(i, "Data Model"));
                continue;
            }
            try {
                metadata = new MetadataDataModel(entry.getAsJsonObject());
            }
            catch (IllegalArgumentException e) {
                DMLRelearned.logger.warn(MetadataManager.getInvalidObjectString(i, "Data Model"));
                continue;
            }
            builder.put((Object)metadata.getID(), (Object)metadata);
        }
        dataModelStore = builder.build();
    }

    private static void initDataModelTierStore(JsonArray json) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (int i = 0; i < json.size(); ++i) {
            MetadataDataModelTier metadata;
            JsonElement entry = json.get(i);
            if (!entry.isJsonObject()) {
                DMLRelearned.logger.warn(MetadataManager.getInvalidEntryString(i, "Data Model Tier"));
                continue;
            }
            try {
                metadata = new MetadataDataModelTier(entry.getAsJsonObject());
            }
            catch (IllegalArgumentException e) {
                DMLRelearned.logger.warn(MetadataManager.getInvalidObjectString(i, "Data Model Tier"));
                continue;
            }
            builder.put((Object)metadata.getTier(), (Object)metadata);
        }
        dataModelTierStore = builder.build();
    }

    private static void initLivingMatterStore(JsonArray json) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < json.size(); ++i) {
            MetadataLivingMatter metadata;
            JsonElement entry = json.get(i);
            if (!entry.isJsonObject()) {
                DMLRelearned.logger.warn(MetadataManager.getInvalidEntryString(i, "Living Matter"));
                continue;
            }
            try {
                metadata = new MetadataLivingMatter(entry.getAsJsonObject());
            }
            catch (IllegalArgumentException e) {
                DMLRelearned.logger.warn(MetadataManager.getInvalidObjectString(i, "Living Matter"));
                continue;
            }
            builder.put((Object)metadata.getID(), (Object)metadata);
        }
        livingMatterStore = builder.build();
    }

    private static void readLivingMatterRecipes(JsonArray array) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < array.size(); ++i) {
            JsonElement entry = array.get(i);
            if (entry.isJsonObject()) {
                builder.add((Object)entry.getAsJsonObject());
                continue;
            }
            DMLRelearned.logger.warn(MetadataManager.getInvalidEntryString(i, "Living Matter Recipe"));
        }
        livingMatterRecipesJson = builder.build();
    }

    private static String getInvalidEntryString(int index, String configName) {
        return String.format("Invalid entry at index %s in %s config (root array elements must be objects)", index, configName);
    }

    private static String getInvalidObjectString(int index, String configName) {
        return String.format("Invalid object structure at index %s in %s config (invalid or missing keys)", index, configName);
    }

    public static ImmutableList<IRecipe> getCraftingRecipes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        dataModelStore.values().forEach(entry -> {
            if (DMLRHelper.isModLoaded(entry.getModID())) {
                entry.getCraftingRecipe().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            }
        });
        JsonContext ctx = new JsonContext("deepmoblearning");
        int recipeCount = 0;
        for (JsonObject entry2 : livingMatterRecipesJson) {
            IRecipe recipe;
            try {
                recipe = CraftingHelper.getRecipe((JsonObject)entry2, (JsonContext)ctx);
            }
            catch (Exception e) {
                DMLRelearned.logger.warn("Error reading Living Matter recipe entry! Error message: {}", (Object)e.getMessage());
                continue;
            }
            recipe.setRegistryName(new ResourceLocation("deepmoblearning:living_matter_conversion_" + recipeCount));
            builder.add((Object)recipe);
            ++recipeCount;
        }
        return builder.build();
    }

    public static ImmutableList<MetadataDataModel> getDataModelMetadataList() {
        return dataModelStore.values().asList();
    }

    public static Optional<MetadataDataModel> getDataModelMetadata(String id) {
        MetadataDataModel entry = (MetadataDataModel)dataModelStore.get((Object)id);
        return entry != null ? Optional.of(entry) : Optional.empty();
    }

    public static ImmutableMap<String, ResourceLocation> getDataModelTextures() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        dataModelStore.forEach((k, v) -> {
            ResourceLocation dataModelTexture = v.getDataModelTexture();
            if (!dataModelTexture.equals((Object)DMLConstants.DefaultModels.DATA_MODEL)) {
                builder.put(k, (Object)dataModelTexture);
            }
        });
        return builder.build();
    }

    public static ImmutableMap<String, ResourceLocation> getPristineMatterTextures() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        dataModelStore.forEach((k, v) -> {
            ResourceLocation pristineMatterTexture = v.getPristineMatterTexture();
            if (!pristineMatterTexture.equals((Object)DMLConstants.DefaultModels.PRISTINE_MATTER)) {
                builder.put(k, (Object)pristineMatterTexture);
            }
        });
        return builder.build();
    }

    public static ImmutableList<String> getAvailableTrials() {
        ImmutableList.Builder builder = ImmutableList.builder();
        dataModelStore.values().forEach(entry -> {
            if (entry.getTrialData().hasEntity()) {
                builder.add((Object)entry.getDisplayName());
            }
        });
        return builder.build();
    }

    public static Optional<MetadataDataModelTier> getDataModelTierData(int tier) {
        MetadataDataModelTier entry = (MetadataDataModelTier)dataModelTierStore.get((Object)tier);
        return entry != null ? Optional.of(entry) : Optional.empty();
    }

    public static int getMaxDataModelTier() {
        return dataModelTierStore.isEmpty() ? -1 : (Integer)dataModelTierStore.lastKey();
    }

    public static boolean isMaxDataModelTier(int tier) {
        int maxTier = MetadataManager.getMaxDataModelTier();
        return maxTier == -1 || tier >= maxTier;
    }

    public static int getMinDataModelTier() {
        return dataModelTierStore.isEmpty() ? -1 : (Integer)dataModelTierStore.firstKey();
    }

    public static boolean isMinDataModelTier(int tier) {
        int minTier = MetadataManager.getMinDataModelTier();
        return minTier == -1 || tier <= minTier;
    }

    public static int getNextDataModelTier(int current) {
        if (dataModelTierStore.isEmpty()) {
            return -1;
        }
        Integer next = (Integer)dataModelTierStore.higherKey((Object)current);
        return next != null ? next : (Integer)dataModelTierStore.lastKey();
    }

    public static int getPrevDataModelTier(int current) {
        if (dataModelTierStore.isEmpty()) {
            return -1;
        }
        Integer next = (Integer)dataModelTierStore.lowerKey((Object)current);
        return next != null ? next : (Integer)dataModelTierStore.firstKey();
    }

    public static ImmutableList<MetadataLivingMatter> getLivingMatterMetadataList() {
        return livingMatterStore.values().asList();
    }

    public static ImmutableMap<String, ResourceLocation> getLivingMatterTextures() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        livingMatterStore.forEach((k, v) -> {
            ResourceLocation livingMatterTexture = v.getLivingMatterTexture();
            if (!livingMatterTexture.equals((Object)DMLConstants.DefaultModels.LIVING_MATTER)) {
                builder.put(k, (Object)livingMatterTexture);
            }
        });
        return builder.build();
    }
}

