/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.common.items.ItemLivingMatter;
import mustapelto.deepmoblearning.common.network.DMLPacketHandler;
import mustapelto.deepmoblearning.common.util.ItemStackHelper;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageLivingMatterConsume
implements IMessage {
    private boolean consumeStack;

    public MessageLivingMatterConsume() {
        this.consumeStack = false;
    }

    public MessageLivingMatterConsume(boolean consumeStack) {
        this.consumeStack = consumeStack;
    }

    public void fromBytes(ByteBuf buf) {
        this.consumeStack = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.consumeStack);
    }

    public static class Handler
    implements IMessageHandler<MessageLivingMatterConsume, IMessage> {
        @Nullable
        public IMessage onMessage(MessageLivingMatterConsume message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack mainHand = player.func_184614_ca();
            ItemStack offHand = player.func_184592_cb();
            if (ItemStackHelper.isLivingMatter(mainHand)) {
                DMLPacketHandler.handleMessageServer(ctx, () -> this.consumeMatter(mainHand, message.consumeStack, player));
            } else if (ItemStackHelper.isLivingMatter(offHand)) {
                DMLPacketHandler.handleMessageServer(ctx, () -> this.consumeMatter(offHand, message.consumeStack, player));
            }
            return null;
        }

        private void consumeMatter(ItemStack matterStack, boolean consumeStack, EntityPlayerMP player) {
            ItemLivingMatter matterItem = (ItemLivingMatter)matterStack.func_77973_b();
            int xp = matterItem.getLivingMatterData().getXpValue();
            if (consumeStack) {
                int size = matterStack.func_190916_E();
                matterStack.func_190918_g(size);
                player.func_71023_q(xp * size);
            } else {
                matterStack.func_190918_g(1);
                player.func_71023_q(xp);
            }
        }
    }
}

