/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.common.network.DMLPacketHandler;
import mustapelto.deepmoblearning.common.tiles.TileEntityLootFabricator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageLootFabOutputItem
implements IMessage {
    private BlockPos pos;
    private int dimension;
    private ItemStack outputItem;

    public MessageLootFabOutputItem() {
    }

    public MessageLootFabOutputItem(BlockPos pos, int dimension, ItemStack outputItem) {
        this.pos = pos;
        this.dimension = dimension;
        this.outputItem = outputItem;
    }

    public MessageLootFabOutputItem(TileEntityLootFabricator target, ItemStack outputItem) {
        this(target.func_174877_v(), target.func_145831_w().field_73011_w.getDimension(), outputItem);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.dimension);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.outputItem);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.dimension = buf.readInt();
        this.outputItem = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<MessageLootFabOutputItem, IMessage> {
        @Nullable
        public IMessage onMessage(MessageLootFabOutputItem message, MessageContext ctx) {
            WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(message.dimension);
            return DMLPacketHandler.handleMessageServer(ctx, () -> {
                TileEntityLootFabricator te = (TileEntityLootFabricator)world.func_175625_s(message.pos);
                if (te != null) {
                    te.setOutputItem(message.outputItem);
                }
            });
        }
    }
}

