/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.tiles;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.DMLRelearned;
import mustapelto.deepmoblearning.client.gui.GuiContainerBase;
import mustapelto.deepmoblearning.client.gui.GuiLootFabricator;
import mustapelto.deepmoblearning.common.DMLConfig;
import mustapelto.deepmoblearning.common.inventory.ContainerLootFabricator;
import mustapelto.deepmoblearning.common.inventory.ContainerTileEntity;
import mustapelto.deepmoblearning.common.inventory.ItemHandlerInputWrapper;
import mustapelto.deepmoblearning.common.inventory.ItemHandlerOutput;
import mustapelto.deepmoblearning.common.inventory.ItemHandlerPristineMatter;
import mustapelto.deepmoblearning.common.metadata.MetadataDataModel;
import mustapelto.deepmoblearning.common.network.DMLPacketHandler;
import mustapelto.deepmoblearning.common.network.MessageLootFabOutputItem;
import mustapelto.deepmoblearning.common.tiles.CraftingState;
import mustapelto.deepmoblearning.common.tiles.TileEntityMachine;
import mustapelto.deepmoblearning.common.util.ItemStackHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TileEntityLootFabricator
extends TileEntityMachine {
    private final ItemHandlerPristineMatter inputPristineMatter = new ItemHandlerPristineMatter(){

        @Override
        protected void onMetadataChanged() {
            if (this.pristineMatterMetadata != null && !TileEntityLootFabricator.this.isValidOutputItem()) {
                TileEntityLootFabricator.this.outputItem = ItemStack.field_190927_a;
            }
            TileEntityLootFabricator.this.resetCrafting();
        }
    };
    private final ItemHandlerInputWrapper pristineMatterWrapper = new ItemHandlerInputWrapper(this.inputPristineMatter);
    private final ItemHandlerOutput output = new ItemHandlerOutput(16);
    private ItemStack outputItem = ItemStack.field_190927_a;
    private static final String NBT_PRISTINE_INPUT = "inputPristine";
    private static final String NBT_OUTPUT = "output";
    private static final String NBT_OUTPUT_ITEM = "outputItem";
    private static final String NBT_LEGACY_PRISTINE = "pristine";
    private static final String NBT_LEGACY_OUTPUT_ITEM = "resultingItem";

    public TileEntityLootFabricator() {
        super(TileEntityLootFabricator.getEnergyCapacity(), TileEntityLootFabricator.getEnergyPerTick());
    }

    private static int getEnergyCapacity() {
        int energyCost = DMLConfig.MACHINE_SETTINGS.LOOT_FABRICATOR_RF_COST;
        long energyCapacity = 1000000L * (long)(energyCost / 100);
        return (int)Math.min(energyCapacity, Integer.MAX_VALUE);
    }

    private static int getEnergyPerTick() {
        int energyCost = DMLConfig.MACHINE_SETTINGS.LOOT_FABRICATOR_RF_COST;
        long energyPerTick = 100L * (long)energyCost;
        return (int)Math.min(energyPerTick, Integer.MAX_VALUE);
    }

    @Override
    public void func_73660_a() {
        if (!this.inputPristineMatter.getStackInSlot(0).func_190926_b() && !this.isValidOutputItem()) {
            this.outputItem = ItemStack.field_190927_a;
            this.resetCrafting();
        }
        super.func_73660_a();
    }

    @Override
    public boolean canStartCrafting() {
        return super.canStartCrafting() && this.hasPristineMatter() && this.hasRoomForOutput() && this.isValidOutputItem();
    }

    @Override
    protected void finishCrafting() {
        this.resetCrafting();
        if (this.outputItem.func_190926_b()) {
            DMLRelearned.logger.warn("Loot Fabricator at {} crafted without selected output!", (Object)this.field_174879_c.toString());
            return;
        }
        if (!this.isValidOutputItem()) {
            DMLRelearned.logger.warn("Loot Fabricator at {} crafted with invalid output selection!", (Object)this.field_174879_c.toString());
            this.outputItem = ItemStack.field_190927_a;
            return;
        }
        this.output.addItemToAvailableSlots(this.outputItem.func_77946_l());
        this.inputPristineMatter.voidItem();
    }

    @Override
    protected int getCraftingDuration() {
        return DMLConfig.MACHINE_SETTINGS.LOOT_FABRICATOR_PROCESSING_TIME;
    }

    @Override
    public int getCraftingEnergyCost() {
        return DMLConfig.MACHINE_SETTINGS.LOOT_FABRICATOR_RF_COST;
    }

    @Override
    protected CraftingState updateCraftingState() {
        if (!this.crafting && !this.hasPristineMatter()) {
            return CraftingState.IDLE;
        }
        if (!this.canContinueCrafting() || !this.isCrafting() && !this.canStartCrafting()) {
            return CraftingState.ERROR;
        }
        return CraftingState.RUNNING;
    }

    private boolean isValidOutputItem() {
        MetadataDataModel pristineMatterMetadata = this.getPristineMatterMetadata();
        return !this.outputItem.func_190926_b() && pristineMatterMetadata != null && pristineMatterMetadata.hasLootItem(this.outputItem);
    }

    @Nullable
    public MetadataDataModel getPristineMatterMetadata() {
        return this.inputPristineMatter.getPristineMatterMetadata();
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    public void setOutputItem(ItemStack outputItem) {
        this.outputItem = outputItem;
        if (!this.isValidOutputItem()) {
            this.outputItem = ItemStack.field_190927_a;
        }
        if (this.field_145850_b.field_72995_K) {
            DMLPacketHandler.sendToServer(new MessageLootFabOutputItem(this, this.outputItem));
        }
    }

    @Override
    public ContainerTileEntity getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerLootFabricator(this, inventoryPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainerBase getGui(EntityPlayer player, World world) {
        return new GuiLootFabricator(this, player, world);
    }

    public boolean hasPristineMatter() {
        return ItemStackHelper.isPristineMatter(this.inputPristineMatter.getStackInSlot(0));
    }

    public boolean hasRoomForOutput() {
        return this.output.hasRoomForItem(this.outputItem);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputPristineMatter, this.output}));
            }
            if (!DMLConfig.MACHINE_SETTINGS.LEGACY_MACHINE_SIDEDNESS) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.pristineMatterWrapper, this.output}));
            }
            if (facing == EnumFacing.UP) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inputPristineMatter);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.output);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public ByteBuf getUpdateData() {
        ByteBuf buf = super.getUpdateData();
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.outputItem);
        return buf;
    }

    @Override
    public void handleUpdateData(ByteBuf buf) {
        super.handleUpdateData(buf);
        this.outputItem = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagCompound inventory = new NBTTagCompound();
        inventory.func_74782_a(NBT_PRISTINE_INPUT, (NBTBase)this.inputPristineMatter.serializeNBT());
        inventory.func_74782_a(NBT_OUTPUT, (NBTBase)this.output.serializeNBT());
        compound.func_74782_a("inventory", (NBTBase)inventory);
        NBTTagCompound crafting = compound.func_74775_l("crafting");
        crafting.func_74782_a(NBT_OUTPUT_ITEM, (NBTBase)this.outputItem.serializeNBT());
        compound.func_74782_a("crafting", (NBTBase)crafting);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        NBTTagCompound outputItemNBT;
        super.func_145839_a(compound);
        if (compound.func_74764_b(NBT_LEGACY_PRISTINE)) {
            this.inputPristineMatter.deserializeNBT(compound.func_74775_l(NBT_LEGACY_PRISTINE));
            this.output.deserializeNBT(compound.func_74775_l(NBT_OUTPUT));
            outputItemNBT = compound.func_74775_l(NBT_LEGACY_OUTPUT_ITEM);
        } else {
            NBTTagCompound inventory = compound.func_74775_l("inventory");
            this.inputPristineMatter.deserializeNBT(inventory.func_74775_l(NBT_PRISTINE_INPUT));
            this.output.deserializeNBT(inventory.func_74775_l(NBT_OUTPUT));
            NBTTagCompound crafting = compound.func_74775_l("crafting");
            outputItemNBT = crafting.func_74775_l(NBT_OUTPUT_ITEM);
        }
        this.outputItem = new ItemStack(outputItemNBT);
    }
}

