/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.trials;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import mustapelto.deepmoblearning.DMLRelearned;
import mustapelto.deepmoblearning.common.metadata.MetadataDataModel;
import mustapelto.deepmoblearning.common.metadata.MetadataDataModelTier;
import mustapelto.deepmoblearning.common.metadata.MetadataManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class AttunementData {
    public static final String NBT_MOB_ID = "mobID";
    public static final String NBT_TIER = "tier";
    private final MetadataDataModel mob;
    private final MetadataDataModelTier tier;
    private final MetadataDataModel.TrialData modelTrialData;
    private final MetadataDataModelTier.TierTrialData tierTrialData;
    private final ImmutableList<ItemStack> rewards;

    private AttunementData(String mobID, int tier) {
        MetadataDataModel mob = MetadataManager.getDataModelMetadata(mobID).orElse(null);
        if (mob != null && !mob.getTrialData().hasEntity()) {
            mob = null;
        }
        this.mob = mob;
        this.tier = MetadataManager.getDataModelTierData(tier).orElse(null);
        if (!this.isInvalidData()) {
            this.modelTrialData = this.mob.getTrialData();
            this.tierTrialData = this.tier.getTierTrialData();
            this.rewards = this.buildRewards();
        } else {
            this.modelTrialData = null;
            this.tierTrialData = null;
            this.rewards = ImmutableList.of();
        }
    }

    public static Optional<AttunementData> create(String mob, int tier) {
        AttunementData data = new AttunementData(mob, tier);
        return data.isInvalidData() ? Optional.empty() : Optional.of(data);
    }

    private boolean isInvalidData() {
        return this.mob == null || this.tier == null;
    }

    public String getMobDisplayName() {
        return this.mob.getDisplayName();
    }

    public String getTierDisplayNameFormatted() {
        return this.tier.getDisplayNameFormatted();
    }

    public ImmutableList<ItemStack> getRewards() {
        return this.rewards;
    }

    private ImmutableList<ItemStack> buildRewards() {
        ImmutableList.Builder builder = ImmutableList.builder();
        int pristineAmount = this.tierTrialData.getPristine();
        builder.add((Object)this.mob.getPristineMatter(pristineAmount));
        if (MetadataManager.isMaxDataModelTier(this.tier.getTier())) {
            builder.addAll(this.modelTrialData.getRewards());
        }
        return builder.build();
    }

    public int getMaxWave() {
        return this.tierTrialData.getMaxWave();
    }

    public int getAffixCount() {
        return this.tierTrialData.getAffixes();
    }

    public int getGlitchChance() {
        return this.tierTrialData.getGlitchChance();
    }

    public double getSpawnDelay() {
        return this.modelTrialData.getSpawnDelay();
    }

    public Optional<EntityLiving> getRandomEntity(World world) {
        Optional<EntityLiving> result = this.modelTrialData.getRandomEntity(world);
        if (!result.isPresent()) {
            DMLRelearned.logger.warn("Could not create Trial entity!");
        }
        return result;
    }

    public int getCurrentWaveMobTotal(int currentWave) {
        return this.modelTrialData.getMobsPerWave(currentWave);
    }
}

