/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.util;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import mustapelto.deepmoblearning.common.items.ItemDataModel;
import mustapelto.deepmoblearning.common.items.ItemDeepLearner;
import mustapelto.deepmoblearning.common.metadata.MetadataDataModel;
import mustapelto.deepmoblearning.common.metadata.MetadataDataModelTier;
import mustapelto.deepmoblearning.common.metadata.MetadataManager;
import mustapelto.deepmoblearning.common.util.ItemStackHelper;
import mustapelto.deepmoblearning.common.util.MathHelper;
import mustapelto.deepmoblearning.common.util.NBTHelper;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class DataModelHelper {
    public static final String NBT_TIER = "tier";
    public static final String NBT_DATA_COUNT = "dataCount";
    public static final String NBT_TOTAL_KILL_COUNT = "totalKillCount";
    public static final String NBT_TOTAL_SIMULATION_COUNT = "totalSimulationCount";
    public static final String NBT_LEGACY_SIMULATION_COUNT = "simulationCount";
    public static final String NBT_LEGACY_KILL_COUNT = "killCount";

    private static boolean isLegacyNBT(ItemStack stack) {
        return NBTHelper.hasKey(stack, NBT_LEGACY_KILL_COUNT) || NBTHelper.hasKey(stack, NBT_LEGACY_SIMULATION_COUNT);
    }

    private static void convertLegacyNBT(ItemStack stack) {
        int currentSimulations = NBTHelper.getInteger(stack, NBT_LEGACY_SIMULATION_COUNT);
        int currentKills = NBTHelper.getInteger(stack, NBT_LEGACY_KILL_COUNT);
        NBTHelper.removeKey(stack, NBT_LEGACY_SIMULATION_COUNT);
        NBTHelper.removeKey(stack, NBT_LEGACY_KILL_COUNT);
        Optional<MetadataDataModelTier> tierData = DataModelHelper.getTierData(stack);
        int killMultiplier = tierData.map(MetadataDataModelTier::getKillMultiplier).orElse(0);
        int currentData = currentSimulations + currentKills * killMultiplier;
        NBTHelper.setInteger(stack, NBT_DATA_COUNT, currentData);
    }

    public static int getTier(ItemStack stack) {
        if (!ItemStackHelper.isDataModel(stack)) {
            return -1;
        }
        int tier = NBTHelper.getInteger(stack, NBT_TIER);
        int minTier = MetadataManager.getMinDataModelTier();
        int maxTier = MetadataManager.getMaxDataModelTier();
        if (tier < minTier) {
            tier = minTier;
            DataModelHelper.setTierLevel(stack, tier);
        } else if (tier > maxTier) {
            tier = maxTier;
            DataModelHelper.setTierLevel(stack, tier);
        }
        return tier;
    }

    public static void setTierLevel(ItemStack stack, int level) {
        NBTHelper.setInteger(stack, NBT_TIER, level);
    }

    public static int getCurrentTierDataCount(ItemStack stack) {
        if (DataModelHelper.isLegacyNBT(stack)) {
            DataModelHelper.convertLegacyNBT(stack);
        }
        return NBTHelper.getInteger(stack, NBT_DATA_COUNT);
    }

    public static void setCurrentTierDataCount(ItemStack stack, int count) {
        NBTHelper.setInteger(stack, NBT_DATA_COUNT, count);
    }

    public static int getTotalKillCount(ItemStack stack) {
        return NBTHelper.getInteger(stack, NBT_TOTAL_KILL_COUNT);
    }

    public static void setTotalKillCount(ItemStack stack, int count) {
        NBTHelper.setInteger(stack, NBT_TOTAL_KILL_COUNT, count);
    }

    public static int getTotalSimulationCount(ItemStack stack) {
        return NBTHelper.getInteger(stack, NBT_TOTAL_SIMULATION_COUNT);
    }

    public static void setTotalSimulationCount(ItemStack stack, int count) {
        NBTHelper.setInteger(stack, NBT_TOTAL_SIMULATION_COUNT, count);
    }

    public static Optional<MetadataDataModel> getDataModelMetadata(ItemStack stack) {
        return ItemStackHelper.isDataModel(stack) ? Optional.of(((ItemDataModel)stack.func_77973_b()).getDataModelMetadata()) : Optional.empty();
    }

    public static Optional<MetadataDataModelTier> getTierData(ItemStack stack, boolean nextTier) {
        int tier = DataModelHelper.getTier(stack) + (nextTier ? 1 : 0);
        return MetadataManager.getDataModelTierData(tier);
    }

    public static Optional<MetadataDataModelTier> getTierData(ItemStack stack) {
        return DataModelHelper.getTierData(stack, false);
    }

    public static boolean isMaxTier(ItemStack stack) {
        return MetadataManager.isMaxDataModelTier(DataModelHelper.getTier(stack));
    }

    private static boolean isMinTier(ItemStack stack) {
        return MetadataManager.isMinDataModelTier(DataModelHelper.getTier(stack));
    }

    public static boolean canSimulate(ItemStack stack) {
        return DataModelHelper.getTierData(stack).map(MetadataDataModelTier::getCanSimulate).orElse(false);
    }

    public static String getTierDisplayNameFormatted(ItemStack stack) {
        return DataModelHelper.getTierData(stack).map(MetadataDataModelTier::getDisplayNameFormatted).orElse("");
    }

    public static String getNextTierDisplayNameFormatted(ItemStack stack) {
        return DataModelHelper.getTierData(stack, true).map(MetadataDataModelTier::getDisplayNameFormatted).orElse("");
    }

    public static int getTierRequiredData(ItemStack stack) {
        return DataModelHelper.getTierData(stack).map(MetadataDataModelTier::getDataToNext).orElse(0);
    }

    public static int getTierKillMultiplier(ItemStack stack) {
        return DataModelHelper.getTierData(stack).map(MetadataDataModelTier::getKillMultiplier).orElse(0);
    }

    public static int getKillsToNextTier(ItemStack stack) {
        int dataRequired = DataModelHelper.getTierRequiredData(stack);
        int dataCurrent = DataModelHelper.getCurrentTierDataCount(stack);
        int killMultiplier = DataModelHelper.getTierKillMultiplier(stack);
        return DataModelHelper.isMaxTier(stack) ? 0 : MathHelper.divideAndRoundUp(dataRequired - dataCurrent, killMultiplier);
    }

    public static int getSimulationEnergy(ItemStack stack) {
        return DataModelHelper.getDataModelMetadata(stack).map(MetadataDataModel::getSimulationRFCost).orElse(0);
    }

    public static int getPristineChance(ItemStack stack) {
        return DataModelHelper.getTierData(stack).map(MetadataDataModelTier::getPristineChance).orElse(0);
    }

    public static boolean getDataModelMatchesLivingMatter(ItemStack dataModel, ItemStack livingMatter) {
        return DataModelHelper.getDataModelMetadata(dataModel).map(data -> data.getLivingMatter().func_77969_a(livingMatter)).orElse(false);
    }

    public static boolean getDataModelMatchesPristineMatter(ItemStack dataModel, ItemStack pristineMatter) {
        return DataModelHelper.getDataModelMetadata(dataModel).map(data -> data.getPristineMatter().func_77969_a(pristineMatter)).orElse(false);
    }

    public static ImmutableList<ItemStack> getDataModelStacksFromList(List<ItemStack> stackList) {
        return (ImmutableList)stackList.stream().filter(ItemStackHelper::isDataModel).collect(ImmutableList.toImmutableList());
    }

    public static ItemStack getHighestTierDataModelFromList(List<ItemStack> stackList) {
        return stackList.stream().max(Comparator.comparingInt(DataModelHelper::getTier)).orElse(ItemStack.field_190927_a);
    }

    public static void addSimulation(ItemStack stack) {
        DataModelHelper.increaseDataCount(stack, 1);
        DataModelHelper.setTotalSimulationCount(stack, DataModelHelper.getTotalSimulationCount(stack) + 1);
        DataModelHelper.tryIncreaseTier(stack);
    }

    private static void increaseDataCount(ItemStack stack, int amount) {
        int data = DataModelHelper.getCurrentTierDataCount(stack);
        DataModelHelper.setCurrentTierDataCount(stack, data + amount);
    }

    public static void addKill(ItemStack stack, EntityPlayerMP player) {
        DataModelHelper.getTierData(stack).ifPresent(tierData -> {
            int increase = tierData.getKillMultiplier();
            if (ItemStackHelper.isGlitchSword(player.func_184614_ca())) {
                increase *= 2;
            }
            DataModelHelper.increaseDataCount(stack, increase);
            DataModelHelper.setTotalKillCount(stack, DataModelHelper.getTotalKillCount(stack) + 1);
            if (DataModelHelper.tryIncreaseTier(stack)) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("deepmoblearning.data_model.reached_tier", new Object[]{stack.func_82833_r(), DataModelHelper.getTierDisplayNameFormatted(stack)}));
            }
        });
    }

    private static boolean tryIncreaseTier(ItemStack stack) {
        int requiredData;
        if (DataModelHelper.isMaxTier(stack)) {
            return false;
        }
        int currentData = DataModelHelper.getCurrentTierDataCount(stack);
        if (currentData >= (requiredData = DataModelHelper.getTierRequiredData(stack))) {
            DataModelHelper.setCurrentTierDataCount(stack, currentData - requiredData);
            DataModelHelper.increaseTier(stack);
            return true;
        }
        return false;
    }

    private static void increaseTier(ItemStack stack) {
        int currentTier = DataModelHelper.getTier(stack);
        int nextTier = MetadataManager.getNextDataModelTier(currentTier);
        DataModelHelper.setTierLevel(stack, nextTier);
    }

    private static void decreaseTier(ItemStack stack) {
        int currentTier = DataModelHelper.getTier(stack);
        int prevTier = MetadataManager.getPrevDataModelTier(currentTier);
        DataModelHelper.setTierLevel(stack, prevTier);
    }

    public static void findAndLevelUpModels(NonNullList<ItemStack> inventory, EntityPlayerMP player, CreativeLevelUpAction action) {
        for (ItemStack inventoryStack : inventory) {
            if (!ItemStackHelper.isDeepLearner(inventoryStack)) continue;
            NonNullList<ItemStack> deepLearnerContents = ItemDeepLearner.getContainedItems(inventoryStack);
            for (ItemStack modelStack : deepLearnerContents) {
                if (!ItemStackHelper.isDataModel(modelStack)) continue;
                switch (action) {
                    case DECREASE_TIER: {
                        if (DataModelHelper.isMinTier(modelStack)) break;
                        DataModelHelper.decreaseTier(modelStack);
                        break;
                    }
                    case INCREASE_TIER: {
                        if (DataModelHelper.isMaxTier(modelStack)) break;
                        DataModelHelper.increaseTier(modelStack);
                        break;
                    }
                    case INCREASE_KILLS: {
                        if (DataModelHelper.isMaxTier(modelStack)) break;
                        DataModelHelper.addKill(modelStack, player);
                    }
                }
            }
            ItemDeepLearner.setContainedItems(inventoryStack, deepLearnerContents);
        }
    }

    public static enum CreativeLevelUpAction {
        INCREASE_TIER(0),
        INCREASE_KILLS(1),
        DECREASE_TIER(2);

        private final int value;
        private static final HashMap<Integer, CreativeLevelUpAction> map;

        private CreativeLevelUpAction(int value) {
            this.value = value;
        }

        public int toInt() {
            return this.value;
        }

        public static CreativeLevelUpAction fromInt(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap();
            for (CreativeLevelUpAction creativeLevelUpAction : CreativeLevelUpAction.values()) {
                map.put(creativeLevelUpAction.value, creativeLevelUpAction);
            }
        }
    }
}

