/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.util;

import java.util.List;
import java.util.Set;
import mustapelto.deepmoblearning.common.capability.CapabilityPlayerTrial;
import mustapelto.deepmoblearning.common.capability.CapabilityPlayerTrialProvider;
import mustapelto.deepmoblearning.common.network.DMLPacketHandler;
import mustapelto.deepmoblearning.common.network.MessageTrialOverlay;
import mustapelto.deepmoblearning.common.util.ItemStackHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PlayerHelper {
    public static List<EntityPlayerMP> getLivingPlayersInArea(World world, BlockPos center, int radius, int height, int offsetY) {
        return world.func_175647_a(EntityPlayerMP.class, new AxisAlignedBB((double)(center.func_177958_n() - radius), (double)(center.func_177956_o() + offsetY), (double)(center.func_177952_p() - radius), (double)(center.func_177958_n() + radius), (double)(center.func_177956_o() + offsetY + height), (double)(center.func_177952_p() + radius)), p -> !p.field_70128_L);
    }

    public static ItemStack getHeldDeepLearner(EntityPlayer player) {
        ItemStack mainHandStack = player.func_184614_ca();
        ItemStack offHandStack = player.func_184592_cb();
        if (ItemStackHelper.isDeepLearner(mainHandStack)) {
            return mainHandStack;
        }
        if (ItemStackHelper.isDeepLearner(offHandStack)) {
            return offHandStack;
        }
        return ItemStack.field_190927_a;
    }

    public static void sendMessageToOverlay(EntityPlayerMP player, String type) {
        DMLPacketHandler.sendToClientPlayer(new MessageTrialOverlay(type), player);
    }

    public static void updateTrialCapability(EntityPlayerMP player, int waveMobTotal, int currentWave, int mobsDefeated, int lastWave, BlockPos pos, boolean active) {
        CapabilityPlayerTrial cap = (CapabilityPlayerTrial)player.getCapability(CapabilityPlayerTrialProvider.PLAYER_TRIAL_CAP, null);
        cap.setWaveMobTotal(waveMobTotal);
        cap.setCurrentWave(currentWave);
        cap.setDefeated(mobsDefeated);
        cap.setLastWave(lastWave);
        cap.setTilePos(pos.func_177986_g());
        cap.setIsActive(active);
        cap.sync(player);
    }

    public static void updateTrialCapability(Set<EntityPlayerMP> players, int waveMobTotal, int currentWave, int mobsDefeated, int lastWave, BlockPos pos, boolean active) {
        players.forEach(p -> PlayerHelper.updateTrialCapability(p, waveMobTotal, currentWave, mobsDefeated, lastWave, pos, active));
    }

    public static void resetTrialCapability(EntityPlayerMP player) {
        PlayerHelper.updateTrialCapability(player, 0, 0, 0, 0, BlockPos.field_177992_a, false);
    }
}

