/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import java.util.Optional;
import mustapelto.deepmoblearning.common.DMLRegistry;
import mustapelto.deepmoblearning.common.metadata.MetadataDataModel;
import mustapelto.deepmoblearning.common.trials.AttunementData;
import mustapelto.deepmoblearning.common.trials.affix.TrialAffix;
import mustapelto.deepmoblearning.common.util.AffixHelper;
import mustapelto.deepmoblearning.common.util.DataModelHelper;
import mustapelto.deepmoblearning.common.util.ItemStackHelper;
import mustapelto.deepmoblearning.common.util.NBTHelper;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class TrialKeyHelper {
    private static final String NBT_ATTUNEMENT = "attunement";
    private static final String NBT_TIER = "tier";
    private static final String NBT_AFFIXES = "affixes";
    private static final String NBT_LEGACY_MOB_KEY = "mobKey";
    private static final Table<String, Integer, AttunementData> attunementDataCache = HashBasedTable.create();

    public static void attune(ItemStack trialKey, ItemStack dataModel, EntityPlayerMP player) {
        DataModelHelper.getDataModelMetadata(dataModel).ifPresent(metadata -> {
            NBTHelper.setString(trialKey, NBT_ATTUNEMENT, metadata.getID());
            NBTHelper.setInteger(trialKey, NBT_TIER, DataModelHelper.getTier(dataModel));
            player.func_145747_a((ITextComponent)new TextComponentTranslation("deepmoblearning.trial_key.attunement_message", new Object[]{trialKey.func_82833_r(), metadata.getDisplayName()}));
        });
    }

    public static boolean isAttuned(ItemStack trialKey) {
        return TrialKeyHelper.getAttunement(trialKey).isPresent();
    }

    public static ItemStack createAttunedKey(MetadataDataModel dataModel, int tier) {
        ItemStack trialKey = new ItemStack((Item)DMLRegistry.ITEM_TRIAL_KEY);
        NBTHelper.setString(trialKey, NBT_ATTUNEMENT, dataModel.getID());
        NBTHelper.setInteger(trialKey, NBT_TIER, tier);
        return trialKey;
    }

    public static Optional<AttunementData> getAttunement(ItemStack trialKey) {
        AttunementData result;
        int tier;
        String mob = TrialKeyHelper.getAttunementString(trialKey).orElse("");
        if (!attunementDataCache.contains((Object)mob, (Object)(tier = NBTHelper.getInteger(trialKey, NBT_TIER, -1)))) {
            AttunementData.create(mob, tier).ifPresent(data -> attunementDataCache.put((Object)mob, (Object)tier, data));
        }
        return (result = (AttunementData)attunementDataCache.get((Object)mob, (Object)tier)) != null ? Optional.of(result) : Optional.empty();
    }

    public static ImmutableList<TrialAffix> getAffixes(ItemStack trialKey, BlockPos pos, World world) {
        ImmutableList<String> affixKeys = TrialKeyHelper.getAffixList(trialKey);
        return (ImmutableList)affixKeys.stream().map(key -> AffixHelper.createAffix(key, pos, world)).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<String> getAffixList(ItemStack stack) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        NBTTagList list = NBTHelper.getTagList(stack, NBT_AFFIXES);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            builder.add((Object)tag.func_74779_i(i + ""));
        }
        return builder.build();
    }

    public static void setAffixList(ItemStack stack, ImmutableList<String> affixes) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < affixes.size(); ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a(i + "", (String)affixes.get(i));
            list.func_74742_a((NBTBase)tag);
        }
        NBTHelper.setTagList(stack, NBT_AFFIXES, list);
    }

    public static int getNumberOfAffixes(ItemStack stack) {
        AttunementData data = TrialKeyHelper.getAttunement(stack).orElse(null);
        if (data != null) {
            return data.getAffixCount();
        }
        return 0;
    }

    public static ImmutableList<ItemStack> getRewards(ItemStack stack) {
        AttunementData data = TrialKeyHelper.getAttunement(stack).orElse(null);
        if (data != null) {
            return data.getRewards();
        }
        return ImmutableList.of();
    }

    public static String getMobName(ItemStack stack) {
        AttunementData data = TrialKeyHelper.getAttunement(stack).orElse(null);
        if (data != null) {
            return data.getMobDisplayName();
        }
        return "";
    }

    private static Optional<String> getAttunementString(ItemStack trialKey) {
        String attunement;
        if (!ItemStackHelper.isTrialKey(trialKey)) {
            return Optional.empty();
        }
        if (NBTHelper.hasKey(trialKey, NBT_LEGACY_MOB_KEY)) {
            TrialKeyHelper.convertNBT(trialKey);
        }
        return !(attunement = NBTHelper.getString(trialKey, NBT_ATTUNEMENT)).isEmpty() ? Optional.of(attunement) : Optional.empty();
    }

    private static void convertNBT(ItemStack stack) {
        String mobKey = NBTHelper.getString(stack, NBT_LEGACY_MOB_KEY);
        NBTHelper.setString(stack, NBT_ATTUNEMENT, mobKey);
        NBTHelper.removeKey(stack, NBT_LEGACY_MOB_KEY);
    }
}

