/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.EnderCore;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.CycleButton;
import com.enderio.core.client.render.EnderWidget;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.oredict.OreDictionary;

public enum DyeColor implements CycleButton.ICycleEnum
{
    BLACK,
    RED,
    GREEN,
    BROWN,
    BLUE,
    PURPLE,
    CYAN,
    SILVER,
    GRAY,
    PINK,
    LIME,
    YELLOW,
    LIGHT_BLUE,
    MAGENTA,
    ORANGE,
    WHITE;

    public static final String[] DYE_ORE_NAMES;
    public static final String[] DYE_ORE_UNLOCAL_NAMES;
    public static final IWidgetIcon[] DYE_ICONS;

    @Nonnull
    public static DyeColor getNext(@Nonnull DyeColor col) {
        int ord = col.ordinal() + 1;
        if (ord >= DyeColor.values().length) {
            ord = 0;
        }
        return NullHelper.first(DyeColor.values()[ord], BLACK);
    }

    @Nullable
    public static DyeColor getColorFromDye(@Nonnull ItemStack dye) {
        if (dye.func_190926_b()) {
            return null;
        }
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)dye);
        for (int i = 0; i < DYE_ORE_NAMES.length; ++i) {
            int dyeID = OreDictionary.getOreID((String)DYE_ORE_NAMES[i]);
            for (int oreId : oreIDs) {
                if (dyeID != oreId) continue;
                return DyeColor.values()[i];
            }
        }
        return null;
    }

    @Nonnull
    public static DyeColor fromIndex(int index) {
        return NullHelper.first(DyeColor.values()[MathHelper.func_76125_a((int)index, (int)0, (int)(DyeColor.values().length - 1))], BLACK);
    }

    public int getColor() {
        return ItemDye.field_150922_c[this.ordinal()];
    }

    @Nonnull
    public String getName() {
        return EnumDyeColor.values()[this.ordinal()].func_176610_l();
    }

    @Nonnull
    public String getLocalisedName() {
        return EnderCore.lang.localizeExact(NullHelper.notnull(DYE_ORE_UNLOCAL_NAMES[this.ordinal()], "Data corruption"), false);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    @Nonnull
    public IWidgetIcon getIcon() {
        return NullHelper.first(DYE_ICONS[this.ordinal()], EnderWidget.COLOR_BLACK);
    }

    @Override
    @Nonnull
    public List<String> getTooltipLines() {
        return new NNList<String>(this.getLocalisedName());
    }

    static {
        DYE_ORE_NAMES = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        DYE_ORE_UNLOCAL_NAMES = new String[]{"item.fireworksCharge.black", "item.fireworksCharge.red", "item.fireworksCharge.green", "item.fireworksCharge.brown", "item.fireworksCharge.blue", "item.fireworksCharge.purple", "item.fireworksCharge.cyan", "item.fireworksCharge.silver", "item.fireworksCharge.gray", "item.fireworksCharge.pink", "item.fireworksCharge.lime", "item.fireworksCharge.yellow", "item.fireworksCharge.lightBlue", "item.fireworksCharge.magenta", "item.fireworksCharge.orange", "item.fireworksCharge.white"};
        DYE_ICONS = new IWidgetIcon[]{EnderWidget.COLOR_BLACK, EnderWidget.COLOR_RED, EnderWidget.COLOR_GREEN, EnderWidget.COLOR_BROWN, EnderWidget.COLOR_BLUE, EnderWidget.COLOR_PURPLE, EnderWidget.COLOR_CYAN, EnderWidget.COLOR_SILVER, EnderWidget.COLOR_GRAY, EnderWidget.COLOR_PINK, EnderWidget.COLOR_LIME, EnderWidget.COLOR_YELLOW, EnderWidget.COLOR_LIGHTBLUE, EnderWidget.COLOR_MAGENTA, EnderWidget.COLOR_ORANGE, EnderWidget.COLOR_WHITE};
    }
}

