/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.IItemFilterUpgrade;
import crazypants.enderio.util.NbtValue;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class FilterRegistry {
    public static boolean isItemFilter(@Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof IItemFilterUpgrade;
    }

    @Nullable
    public static <T extends IFilter> T getFilterForUpgrade(@Nonnull ItemStack stack) {
        if (!FilterRegistry.isItemFilter(stack)) {
            return null;
        }
        IItemFilterUpgrade upgrade = (IItemFilterUpgrade)stack.func_77973_b();
        Object res = upgrade.createFilterFromStack(stack);
        return res;
    }

    public static boolean isFilterSet(@Nonnull ItemStack stack) {
        return NbtValue.FILTER.hasTag(stack);
    }

    public static void writeFilterToStack(@Nullable IFilter filter, @Nonnull ItemStack stack) {
        if (filter == null) {
            return;
        }
        NBTTagCompound filterRoot = new NBTTagCompound();
        FilterRegistry.writeFilterToNbt(filter, filterRoot);
        NbtValue.FILTER.setTag(stack, filterRoot);
    }

    public static void writeFilterToNbt(@Nullable IFilter filter, @Nonnull NBTTagCompound filterTag) {
        if (filter == null) {
            return;
        }
        NbtValue.FILTER_CLASS.setString(filterTag, filter.getClass().getName());
        filter.writeToNBT(filterTag);
    }

    public static IFilter loadFilterFromNbt(@Nullable NBTTagCompound filterTag) {
        if (filterTag == null) {
            return null;
        }
        String className = NbtValue.FILTER_CLASS.getString(filterTag);
        return FilterRegistry.loadFilterFromNbt(className, filterTag);
    }

    private static IFilter loadFilterFromNbt(@Nullable String className, @Nonnull NBTTagCompound tag) {
        try {
            Class<?> clz = Class.forName(className);
            IFilter filter = (IFilter)clz.newInstance();
            filter.readFromNBT(tag);
            return filter;
        }
        catch (Exception e) {
            Log.error("Could not read item filter with class name: " + className + " from NBT: " + tag + " Error: " + e);
            return null;
        }
    }

    private static IFilter loadFilterFromByteBuf(@Nonnull String className, @Nonnull ByteBuf buf) {
        try {
            Class<?> clz = Class.forName(className);
            IFilter filter = (IFilter)clz.newInstance();
            filter.readFromByteBuf(buf);
            return filter;
        }
        catch (Exception e) {
            Log.error("Could not read item filter with class name: " + className + " from ByteBuf Error: " + e);
            return null;
        }
    }

    public static void writeFilter(@Nonnull ByteBuf buf, @Nullable IFilter filter) {
        if (filter == null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)"nullFilter");
            return;
        }
        String name = filter.getClass().getName();
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)name);
        filter.writeToByteBuf(buf);
    }

    public static IFilter readFilter(@Nonnull ByteBuf buf) {
        String className = ByteBufUtils.readUTF8String((ByteBuf)buf);
        if (className.equals("nullFilter")) {
            return null;
        }
        return FilterRegistry.loadFilterFromByteBuf(className, buf);
    }

    public static IFilter readFilterFromStack(@Nonnull ItemStack stack) {
        if (FilterRegistry.isFilterSet(stack)) {
            return FilterRegistry.loadFilterFromNbt(NbtValue.FILTER.getTag(stack));
        }
        return FilterRegistry.getFilterForUpgrade(stack);
    }
}

