/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.gui;

import com.enderio.core.api.client.gui.IGuiOverlay;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.GuiContainerBase;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.ILocalizable;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.config.config.IntegrationConfig;
import crazypants.enderio.base.config.config.PersonalConfig;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.integration.jei.JeiAccessor;
import crazypants.enderio.base.machine.interfaces.INotifier;
import crazypants.enderio.base.network.IRemoteExec;
import crazypants.enderio.base.scheduler.Celeb;
import crazypants.enderio.base.sound.IModSound;
import crazypants.enderio.base.sound.SoundHelper;
import crazypants.enderio.base.sound.SoundRegistry;
import crazypants.enderio.util.Prep;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiContainerBaseEIO<O>
extends GuiContainerBase
implements IRemoteExec.IGui {
    @Nonnull
    private final NNList<ResourceLocation> guiTextures = new NNList();
    @Nonnull
    private final O owner;
    @Nonnull
    private final List<Rectangle> tabAreas = new ArrayList<Rectangle>();
    @Nonnull
    private static final Rectangle NO_TAB = new Rectangle(0, 0, 0, 0);
    static long[] LAYERSEED = null;

    public GuiContainerBaseEIO(@Nonnull O owner, @Nonnull Container par1Container, String ... guiTexture) {
        super(par1Container);
        this.owner = owner;
        for (String string : guiTexture) {
            this.guiTextures.add((Object)EnderIO.proxy.getGuiTexture((String)NullHelper.notnull((Object)string, (String)"invalid gui texture name")));
        }
    }

    @Nonnull
    public O getOwner() {
        return this.owner;
    }

    public void bindGuiTexture() {
        this.bindGuiTexture(0);
    }

    public void bindGuiTexture(int id) {
        RenderUtil.bindTexture((ResourceLocation)this.getGuiTexture(id));
    }

    @Nonnull
    protected ResourceLocation getGuiTexture(int id) {
        return this.guiTextures.size() > id ? (ResourceLocation)this.guiTextures.get(id) : new ResourceLocation("enderio", "texture_missing");
    }

    @Nonnull
    protected ResourceLocation getGuiTexture() {
        return this.getGuiTexture(0);
    }

    protected boolean showRecipeButton() {
        return JeiAccessor.isJeiRuntimeAvailable();
    }

    public List<Rectangle> getBlockingAreas() {
        ArrayList<Rectangle> result = new ArrayList<Rectangle>(this.tabAreas);
        for (IGuiOverlay overlay : this.overlays) {
            if (!overlay.isVisible()) continue;
            Rectangle bounds = new Rectangle(overlay.getBounds());
            bounds.translate(this.field_147003_i, this.field_147009_r);
            result.add(bounds);
        }
        return result;
    }

    @Nonnull
    public Set<String> getDocumentationPages() {
        return Collections.singleton(this.getDocumentationPage());
    }

    @Nonnull
    protected String getDocumentationPage() {
        return "enderio:" + this.getClass().getSimpleName().replaceAll("([A-Z])", "_$0").replaceFirst("^_", "").toLowerCase(Locale.ENGLISH).replaceFirst("_gui$", "").replaceFirst("^gui_", "");
    }

    public Rectangle getDocumentationButtonArea() {
        return new Rectangle(this.field_147003_i - 25, this.field_147009_r + 3, 25, 25);
    }

    public Rectangle getDocumentationArea() {
        return IntegrationConfig.rectangleWithPIMargins(0, 0, this.field_147003_i, this.field_146295_m);
    }

    @Nullable
    public Object getIngredientUnderMouse(int mouseX, int mouseY) {
        return null;
    }

    public void startTabs() {
        this.tabAreas.clear();
    }

    public int getTabFromCoords(int x, int y) {
        for (int i = 0; i < this.tabAreas.size(); ++i) {
            if (!this.tabAreas.get(i).contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    protected boolean func_193983_c(int mouseX, int mouseY, int guileft, int guitop) {
        if (super.func_193983_c(mouseX, mouseY, guileft, guitop)) {
            for (Rectangle r : this.getBlockingAreas()) {
                if (!r.contains(mouseX, mouseY)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        int tabFromCoords;
        if (button == 0 && (tabFromCoords = this.getTabFromCoords(x, y)) >= 0 && this.doSwitchTab(tabFromCoords)) {
            SoundHelper.playSound((World)this.field_146297_k.field_71441_e, (Entity)this.field_146297_k.field_71439_g, (IModSound)SoundRegistry.TAB_SWITCH, 1.0f, 1.0f);
            return;
        }
        super.func_73864_a(x, y, button);
    }

    protected boolean doSwitchTab(int tab) {
        return false;
    }

    @Nonnull
    public Rectangle renderStdTab(int sx, int sy, int tabNo, boolean isActive) {
        return this.renderStdTab(sx, sy, tabNo, Prep.getEmpty(), null, null, isActive);
    }

    @Nonnull
    public Rectangle renderStdTab(int sx, int sy, int tabNo, @Nonnull ItemStack stack, boolean isActive) {
        return this.renderStdTab(sx, sy, tabNo, stack, null, null, isActive);
    }

    @Nonnull
    public Rectangle renderStdTab(int sx, int sy, int tabNo, @Nullable IWidgetIcon icon, boolean isActive) {
        return this.renderStdTab(sx, sy, tabNo, Prep.getEmpty(), icon, null, isActive);
    }

    @Nonnull
    public Rectangle renderStdTab(int sx, int sy, int tabNo, @Nullable GuiButton button, boolean isActive) {
        return this.renderStdTab(sx, sy, tabNo, Prep.getEmpty(), null, button, isActive);
    }

    @Nonnull
    public Rectangle renderStdTab(int sx, int sy, int tabNo, @Nonnull ItemStack stack, @Nullable GuiButton button, boolean isActive) {
        return this.renderStdTab(sx, sy, tabNo, stack, null, button, isActive);
    }

    @Nonnull
    public Rectangle renderStdTab(int sx, int sy, int tabNo, @Nullable IWidgetIcon icon, @Nullable GuiButton button, boolean isActive) {
        return this.renderStdTab(sx, sy, tabNo, Prep.getEmpty(), icon, button, isActive);
    }

    @Nonnull
    public Rectangle renderStdTab(int sx, int sy, int tabNo, @Nonnull ItemStack stack, @Nullable IWidgetIcon icon, @Nullable GuiButton button, boolean isActive) {
        int tabX = sx + this.field_146999_f + -3;
        int tabY = sy + 4 + 24 * tabNo;
        Rectangle result = this.renderTab(tabX, tabY, 24, stack, icon, isActive);
        while (this.tabAreas.size() <= tabNo) {
            this.tabAreas.add(NO_TAB);
        }
        this.tabAreas.set(tabNo, result);
        if (button != null) {
            button.field_146128_h = result.x;
            button.field_146129_i = result.y;
            button.field_146120_f = result.width;
            button.field_146121_g = result.height;
            button.field_146124_l = !isActive;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return result;
    }

    @Nonnull
    public Rectangle renderTab(int x, int y, int w, @Nonnull ItemStack stack, @Nullable IWidgetIcon icon, boolean isActive) {
        int bg_x = isActive ? 0 : 3;
        int bg_w = w - 3 - bg_x;
        int l_x = isActive ? 0 : 3;
        int l_w = w - 3 - l_x;
        int r_x = 3;
        int r_w = w - r_x;
        int r_u = IconEIO.TAB_FRAME_LEFT.width - r_w;
        if (isActive) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GlStateManager.func_179131_c((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
        }
        GlStateManager.func_179140_f();
        BufferBuilder tes = Tessellator.func_178181_a().func_178180_c();
        RenderUtil.bindTexture((ResourceLocation)IconEIO.map.getTexture());
        tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        this.renderTabPart(tes, x + bg_x, y, IconEIO.TAB_BG.getX() + bg_x, IconEIO.TAB_BG.getY(), bg_w, IconEIO.TAB_BG.getHeight());
        this.renderTabPart(tes, x + l_x, y, IconEIO.TAB_FRAME_LEFT.getX() + l_x, IconEIO.TAB_FRAME_LEFT.getY(), l_w, IconEIO.TAB_FRAME_LEFT.getHeight());
        this.renderTabPart(tes, x + r_x, y, IconEIO.TAB_FRAME_RIGHT.getX() + r_u, IconEIO.TAB_FRAME_RIGHT.getY(), r_w, IconEIO.TAB_FRAME_RIGHT.getHeight());
        if (icon != null && icon.getMap() == IconEIO.map) {
            icon.getMap().render(icon, (double)(x + w / 2 - 8), (double)(y + IconEIO.TAB_BG.getHeight() / 2 - 8), false);
        }
        Tessellator.func_178181_a().func_78381_a();
        if (icon != null && icon.getMap() != IconEIO.map) {
            icon.getMap().render(icon, (double)(x + w / 2 - 8), (double)(y + IconEIO.TAB_BG.getHeight() / 2 - 8), true);
        }
        if (Prep.isValid(stack)) {
            RenderHelper.func_74520_c();
            this.field_146296_j.func_175042_a(stack, x + w / 2 - 8, y + IconEIO.TAB_BG.getHeight() / 2 - 8);
            RenderHelper.func_74518_a();
        }
        return new Rectangle(x + bg_x, y - 1, bg_w + 3 + 1, IconEIO.TAB_BG.getHeight() + 2);
    }

    private void renderTabPart(@Nonnull BufferBuilder tes, int x, int y, int u, int v, int w, int h) {
        double minU = (double)u / (double)IconEIO.map.getSize();
        double maxU = (double)(u + w) / (double)IconEIO.map.getSize();
        double minV = (double)v / (double)IconEIO.map.getSize();
        double maxV = (double)(v + h) / (double)IconEIO.map.getSize();
        tes.func_181662_b((double)x, (double)(y + h), 0.0).func_187315_a(minU, maxV).func_181675_d();
        tes.func_181662_b((double)(x + w), (double)(y + h), 0.0).func_187315_a(maxU, maxV).func_181675_d();
        tes.func_181662_b((double)(x + w), (double)(y + 0), 0.0).func_187315_a(maxU, minV).func_181675_d();
        tes.func_181662_b((double)x, (double)(y + 0), 0.0).func_187315_a(minU, minV).func_181675_d();
    }

    @Override
    public void setGuiID(int id) {
        if (this.field_147002_h instanceof IRemoteExec.IContainer) {
            ((IRemoteExec.IContainer)this.field_147002_h).setGuiID(id);
        }
    }

    @Override
    public int getGuiID() {
        if (this.field_147002_h instanceof IRemoteExec.IContainer) {
            return ((IRemoteExec.IContainer)this.field_147002_h).getGuiID();
        }
        return -1;
    }

    public void func_73733_a(int left, int top, int right, int bottom, int startColor, int endColor) {
        super.func_73733_a(left, top, right, bottom, startColor, endColor);
    }

    /*
     * WARNING - void declaration
     */
    public void func_146270_b(int tint) {
        if (Celeb.SPACE.isOn() && NullHelper.untrust((Object)this.field_146297_k.field_71441_e) != null && ((Boolean)PersonalConfig.celebrateSpaceDay.get()).booleanValue()) {
            void var5_8;
            GuiContainerBaseEIO.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)-553648128);
            long tickCount = EnderIO.proxy.getTickCount();
            Random rand = new Random();
            if (LAYERSEED == null) {
                long[] lArray = new long[10];
                for (int i = 0; i < lArray.length; ++i) {
                    lArray[i] = rand.nextLong();
                }
                LAYERSEED = lArray;
            }
            boolean bl = true;
            while (var5_8 < 10) {
                for (int star = 0; star < this.field_146294_l - 1; ++star) {
                    long seed = LAYERSEED[var5_8] + (long)star + tickCount / (long)var5_8;
                    rand.setSeed(seed);
                    int y = rand.nextInt(this.field_146295_m * 10 * var5_8 / 3);
                    int r = rand.nextInt(64);
                    int g = rand.nextInt(64);
                    int b = rand.nextInt(32);
                    int color = 255 - r << 16 | 255 - g << 8 | 255 - b;
                    if (y >= this.field_146295_m) continue;
                    GuiContainerBaseEIO.func_73734_a((int)star, (int)y, (int)(star + 1), (int)(y + 1), (int)(0xA0000000 | color));
                    GuiContainerBaseEIO.func_73734_a((int)(star + 1), (int)y, (int)(star + 2), (int)(y + 1), (int)(0x20000000 | color));
                }
                ++var5_8;
            }
            return;
        }
        super.func_146270_b(tint);
        if (((Boolean)PersonalConfig.GUIBrandingEnabled.get()).booleanValue()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((Float)PersonalConfig.GUIBrandingAlpha.get()).floatValue());
            RenderUtil.bindTexture((String)((String)PersonalConfig.GUIBrandingTexture.get()));
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.01f);
            int size = Math.min(this.field_146294_l, this.field_146295_m) / (Integer)PersonalConfig.GUIBrandingTiles.get();
            GuiContainerBaseEIO.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.field_146294_l, (int)this.field_146295_m, (float)size, (float)size);
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
        }
        if (this.getOwner() instanceof INotifier) {
            int x = this.field_146294_l / 2;
            int y = 4;
            for (ILocalizable iLocalizable : ((INotifier)this.getOwner()).getNotification()) {
                String s = EnderIO.lang.localizeExact(iLocalizable.getUnlocalizedName());
                int stringWidth = this.field_146289_q.func_78256_a(s);
                int xPos = x - stringWidth / 2;
                this.func_73733_a(xPos - 1, y - 1, xPos + stringWidth + 1, y + this.field_146289_q.field_78288_b, -65536, -5308416);
                this.field_146289_q.func_175065_a(s, (float)xPos, (float)y, 0xFFFFFF, true);
                y += this.field_146289_q.field_78288_b + 2;
            }
        }
    }

    public float setZLevel(float level) {
        float old = this.field_73735_i;
        this.field_73735_i = level;
        return old;
    }
}

