/*
 * Decompiled with CFR 0.152.
 */
package gregicality.multiblocks.api.fluids;

import gregicality.multiblocks.api.fluids.GCYMFluidStorageKeys;
import gregicality.multiblocks.api.unification.GCYMMaterialFlags;
import gregicality.multiblocks.api.unification.properties.AlloyBlastProperty;
import gregicality.multiblocks.api.unification.properties.GCYMPropertyKey;
import gregtech.api.GregTechAPI;
import gregtech.api.fluids.FluidBuilder;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.FluidProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class GeneratedFluidHandler {
    private GeneratedFluidHandler() {
    }

    public static void init() {
        for (Material material : GregTechAPI.materialManager.getRegisteredMaterials()) {
            GeneratedFluidHandler.createMoltenFluid(material);
        }
    }

    public static void createMoltenFluid(@NotNull Material material) {
        if (material.hasFlag(GCYMMaterialFlags.DISABLE_ALLOY_PROPERTY)) {
            return;
        }
        if (material.getMaterialComponents().size() <= 1) {
            return;
        }
        BlastProperty blastProperty = (BlastProperty)material.getProperty(PropertyKey.BLAST);
        if (blastProperty == null) {
            return;
        }
        AlloyBlastProperty alloyBlastProperty = (AlloyBlastProperty)material.getProperty(GCYMPropertyKey.ALLOY_BLAST);
        if (alloyBlastProperty == null) {
            return;
        }
        FluidProperty fluidProperty = (FluidProperty)material.getProperty(PropertyKey.FLUID);
        if (fluidProperty == null) {
            return;
        }
        if (alloyBlastProperty.shouldGenerateMolten(material)) {
            fluidProperty.enqueueRegistration(GCYMFluidStorageKeys.MOLTEN, new FluidBuilder().temperature(alloyBlastProperty.getTemperature()));
        }
    }
}

