/*
 * Decompiled with CFR 0.152.
 */
package gregicality.multiblocks.api.recipes.alloyblast;

import gregicality.multiblocks.api.fluids.GCYMFluidStorageKeys;
import gregicality.multiblocks.api.recipes.GCYMRecipeMaps;
import gregicality.multiblocks.api.unification.GCYMMaterialFlags;
import gregtech.api.GTValues;
import gregtech.api.fluids.store.FluidStorageKeys;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.BlastRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.common.items.MetaItems;
import gregtech.loaders.recipe.CraftingComponent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class AlloyBlastRecipeProducer {
    public static final AlloyBlastRecipeProducer DEFAULT_PRODUCER = new AlloyBlastRecipeProducer();

    public void produce(@NotNull Material material, @NotNull BlastProperty blastProperty) {
        if (material.hasFlag(GCYMMaterialFlags.NO_ALLOY_BLAST_RECIPES)) {
            return;
        }
        int componentAmount = material.getMaterialComponents().size();
        if (componentAmount < 2) {
            return;
        }
        Fluid output = material.getFluid(GCYMFluidStorageKeys.MOLTEN);
        if (output == null && (output = material.getFluid(FluidStorageKeys.LIQUID)) == null) {
            return;
        }
        BlastRecipeBuilder builder = this.createBuilder(blastProperty, material);
        int outputAmount = this.addInputs(material, (RecipeBuilder<BlastRecipeBuilder>)builder);
        if (outputAmount <= 0) {
            return;
        }
        this.buildRecipes(blastProperty, output, outputAmount, componentAmount, (RecipeBuilder<BlastRecipeBuilder>)builder);
        if (!OrePrefix.ingotHot.doGenerateItem(material)) {
            return;
        }
        this.addFreezerRecipes(material, output, blastProperty);
    }

    @NotNull
    protected BlastRecipeBuilder createBuilder(@NotNull BlastProperty property, @NotNull Material material) {
        BlastRecipeBuilder builder = (BlastRecipeBuilder)GCYMRecipeMaps.ALLOY_BLAST_RECIPES.recipeBuilder();
        int duration = property.getDurationOverride();
        if (duration < 0) {
            duration = Math.max(1, (int)(material.getMass() * (long)property.getBlastTemperature() / 100L));
        }
        builder.duration(duration);
        int EUt = property.getEUtOverride();
        if (EUt < 0) {
            EUt = GTValues.VA[2];
        }
        builder.EUt(EUt);
        return builder.blastFurnaceTemp(property.getBlastTemperature());
    }

    protected int addInputs(@NotNull Material material, @NotNull RecipeBuilder<BlastRecipeBuilder> builder) {
        int outputAmount = 0;
        int fluidAmount = 0;
        for (MaterialStack materialStack : material.getMaterialComponents()) {
            Material msMat = materialStack.material;
            int msAmount = (int)materialStack.amount;
            if (msMat.hasProperty(PropertyKey.DUST)) {
                builder.input(OrePrefix.dust, msMat, msAmount);
            } else if (msMat.hasProperty(PropertyKey.FLUID)) {
                if (fluidAmount >= 2) {
                    return -1;
                }
                ++fluidAmount;
                builder.fluidInputs(new FluidStack[]{msMat.getFluid(1000 * msAmount)});
            } else {
                return -1;
            }
            outputAmount += msAmount;
        }
        return outputAmount;
    }

    protected void buildRecipes(@NotNull BlastProperty property, @NotNull Fluid molten, int outputAmount, int componentAmount, @NotNull RecipeBuilder<BlastRecipeBuilder> builder) {
        builder.fluidOutputs(new FluidStack[]{new FluidStack(molten, 144 * outputAmount)});
        int duration = builder.getDuration() * outputAmount * 3 / 4;
        if (property.getGasTier() != null) {
            RecipeBuilder builderGas = builder.copy();
            FluidStack gas = (FluidStack)CraftingComponent.EBF_GASES.get(property.getGasTier());
            ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)builderGas.notConsumable((GTRecipeInput)new IntCircuitIngredient(this.getGasCircuitNum(componentAmount)))).fluidInputs(new FluidStack[]{new FluidStack(gas, gas.amount * outputAmount)})).duration((int)((double)duration * 0.67))).buildAndRegister();
        }
        ((BlastRecipeBuilder)((BlastRecipeBuilder)builder.notConsumable((GTRecipeInput)new IntCircuitIngredient(this.getCircuitNum(componentAmount)))).duration(duration)).buildAndRegister();
    }

    protected int getCircuitNum(int componentAmount) {
        return componentAmount;
    }

    protected int getGasCircuitNum(int componentAmount) {
        return componentAmount + 10;
    }

    protected void addFreezerRecipes(@NotNull Material material, @NotNull Fluid molten, @NotNull BlastProperty property) {
        int vacuumDuration = property.getVacuumDurationOverride() == -1 ? (int)material.getMass() * 3 : property.getVacuumDurationOverride();
        int vacuumEUt = property.getVacuumEUtOverride() == -1 ? GTValues.VA[2] : property.getVacuumEUtOverride();
        RecipeBuilder freezerBuilder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder()).fluidInputs(new FluidStack[]{new FluidStack(molten, 144)})).notConsumable(MetaItems.SHAPE_MOLD_INGOT.getStackForm())).output(OrePrefix.ingot, material)).duration(vacuumDuration)).EUt(vacuumEUt);
        if (property.getBlastTemperature() >= 5000) {
            freezerBuilder.fluidInputs(new FluidStack[]{Materials.Helium.getFluid(FluidStorageKeys.LIQUID, 500)}).fluidOutputs(new FluidStack[]{Materials.Helium.getFluid(250)});
        }
        freezerBuilder.buildAndRegister();
    }
}

