/*
 * Decompiled with CFR 0.152.
 */
package gregicality.multiblocks.common.metatileentities.multiblock.standard;

import gregicality.multiblocks.api.recipes.GCYMRecipeMaps;
import gregicality.multiblocks.api.render.GCYMTextures;
import gregicality.multiblocks.common.block.GCYMMetaBlocks;
import gregicality.multiblocks.common.block.blocks.BlockLargeMultiblockCasing;
import gregicality.multiblocks.common.block.blocks.BlockUniqueCasing;
import gregicality.multiblocks.common.metatileentities.GCYMMetaTileEntities;
import gregtech.api.GregTechAPI;
import gregtech.api.block.IHeatingCoilBlockStats;
import gregtech.api.capability.IHeatingCoil;
import gregtech.api.capability.impl.HeatingCoilRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.recipes.recipeproperties.TemperatureProperty;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.metatileentities.MetaTileEntities;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityAlloyBlastSmelter
extends RecipeMapMultiblockController
implements IHeatingCoil {
    private int blastFurnaceTemperature;

    public MetaTileEntityAlloyBlastSmelter(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, GCYMRecipeMaps.ALLOY_BLAST_RECIPES);
        this.recipeMapWorkable = new HeatingCoilRecipeLogic((RecipeMapMultiblockController)this);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity metaTileEntityHolder) {
        return new MetaTileEntityAlloyBlastSmelter(this.metaTileEntityId);
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, (boolean)this.isStructureFormed()).setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.getEnergyContainer()).addEnergyTierLine((int)GTUtility.getTierByVoltage((long)this.recipeMapWorkable.getMaxVoltage())).addCustom(tl -> {
            if (this.isStructureFormed()) {
                TextComponentString heatString = TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.RED, (String)(TextFormattingUtil.formatNumbers((long)this.blastFurnaceTemperature) + "K"));
                tl.add(TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.blast_furnace.max_temperature", (Object[])new Object[]{heatString}));
            }
        }).addParallelsLine(this.recipeMapWorkable.getParallelLimit()).addWorkingStatusLine().addProgressLine(this.recipeMapWorkable.getProgressPercent());
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        Object type = context.get("CoilType");
        this.blastFurnaceTemperature = type instanceof IHeatingCoilBlockStats ? ((IHeatingCoilBlockStats)type).getCoilTemperature() : BlockWireCoil.CoilType.CUPRONICKEL.getCoilTemperature();
        this.blastFurnaceTemperature += 100 * Math.max(0, GTUtility.getTierByVoltage((long)this.getEnergyContainer().getInputVoltage()) - 2);
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.blastFurnaceTemperature = 0;
    }

    public boolean checkRecipe(@NotNull Recipe recipe, boolean consumeIfSuccess) {
        return this.blastFurnaceTemperature >= (Integer)recipe.getProperty((RecipeProperty)TemperatureProperty.getInstance(), (Object)0);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"#XXX#", "#CCC#", "#GGG#", "#CCC#", "#XXX#"}).aisle(new String[]{"XXXXX", "CAAAC", "GAAAG", "CAAAC", "XXXXX"}).aisle(new String[]{"XXXXX", "CAAAC", "GAAAG", "CAAAC", "XXMXX"}).aisle(new String[]{"XXXXX", "CAAAC", "GAAAG", "CAAAC", "XXXXX"}).aisle(new String[]{"#XSX#", "#CCC#", "#GGG#", "#CCC#", "#XXX#"}).where('S', this.selfPredicate()).where('X', MetaTileEntityAlloyBlastSmelter.states((IBlockState[])new IBlockState[]{MetaTileEntityAlloyBlastSmelter.getCasingState()}).setMinGlobalLimited(30).or(this.autoAbilities(true, true, true, true, true, true, false))).where('C', MetaTileEntityAlloyBlastSmelter.heatingCoils()).where('G', MetaTileEntityAlloyBlastSmelter.states((IBlockState[])new IBlockState[]{MetaTileEntityAlloyBlastSmelter.getCasingState2()})).where('M', MetaTileEntityAlloyBlastSmelter.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.MUFFLER_HATCH})).where('A', MetaTileEntityAlloyBlastSmelter.air()).where('#', MetaTileEntityAlloyBlastSmelter.any()).build();
    }

    public List<MultiblockShapeInfo> getMatchingShapes() {
        ArrayList<MultiblockShapeInfo> shapeInfo = new ArrayList<MultiblockShapeInfo>();
        MultiblockShapeInfo.Builder builder = MultiblockShapeInfo.builder().aisle(new String[]{"#XEX#", "#CCC#", "#GGG#", "#CCC#", "#XXX#"}).aisle(new String[]{"XXXXX", "C###C", "G###G", "C###C", "XXXXX"}).aisle(new String[]{"XXXXX", "C###C", "G###G", "C###C", "XXMXX"}).aisle(new String[]{"FXXXH", "C###C", "G###G", "C###C", "XXXXX"}).aisle(new String[]{"#ISO#", "#CCC#", "#GGG#", "#CCC#", "#XXX#"}).where('S', (MetaTileEntity)GCYMMetaTileEntities.ALLOY_BLAST_SMELTER, EnumFacing.SOUTH).where('X', MetaTileEntityAlloyBlastSmelter.getCasingState()).where('G', MetaTileEntityAlloyBlastSmelter.getCasingState2()).where('M', (MetaTileEntity)MetaTileEntities.MUFFLER_HATCH[3], EnumFacing.UP).where('I', (MetaTileEntity)MetaTileEntities.ITEM_IMPORT_BUS[3], EnumFacing.SOUTH).where('F', (MetaTileEntity)MetaTileEntities.FLUID_IMPORT_HATCH[3], EnumFacing.SOUTH).where('O', (MetaTileEntity)MetaTileEntities.FLUID_EXPORT_HATCH[3], EnumFacing.SOUTH).where('E', (MetaTileEntity)MetaTileEntities.ENERGY_INPUT_HATCH[4], EnumFacing.NORTH).where('H', () -> ConfigHolder.machines.enableMaintenance ? MetaTileEntities.MAINTENANCE_HATCH : MetaTileEntityAlloyBlastSmelter.getCasingState(), EnumFacing.SOUTH).where('#', Blocks.field_150350_a.func_176223_P());
        GregTechAPI.HEATING_COILS.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((IHeatingCoilBlockStats)entry.getValue()).getTier())).forEach(entry -> shapeInfo.add(builder.where('C', (IBlockState)entry.getKey()).build()));
        return shapeInfo;
    }

    private static IBlockState getCasingState() {
        return GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING.getState(BlockLargeMultiblockCasing.CasingType.HIGH_TEMPERATURE_CASING);
    }

    private static IBlockState getCasingState2() {
        return GCYMMetaBlocks.UNIQUE_CASING.getState(BlockUniqueCasing.UniqueCasingType.HEAT_VENT);
    }

    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.electric_blast_furnace.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.electric_blast_furnace.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.electric_blast_furnace.tooltip.3", (Object[])new Object[0]));
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart iMultiblockPart) {
        return GCYMTextures.BLAST_CASING;
    }

    @NotNull
    protected OrientedOverlayRenderer getFrontOverlay() {
        return GCYMTextures.ALLOY_BLAST_SMELTER_OVERLAY;
    }

    public boolean hasMufflerMechanics() {
        return true;
    }

    public boolean canBeDistinct() {
        return true;
    }

    public int getCurrentTemperature() {
        return this.blastFurnaceTemperature;
    }
}

