/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.furnace;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class SmeltingRecipe
implements IRecipeWrapper {
    private final List<ItemStack> input;
    private final ItemStack output;
    private float experience = -1.0f;

    public SmeltingRecipe(List<ItemStack> input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    @Override
    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(this.input));
        ingredients.setOutput(VanillaTypes.ITEM, this.output);
    }

    @Override
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        FurnaceRecipes furnaceRecipes = FurnaceRecipes.func_77602_a();
        if (this.experience == -1.0f) {
            this.experience = furnaceRecipes.func_151398_b(this.output);
        }
        if (this.experience > 0.0f) {
            String experienceString = Translator.translateToLocalFormatted("gui.jei.category.smelting.experience", Float.valueOf(this.experience));
            FontRenderer fontRenderer = minecraft.field_71466_p;
            int stringWidth = fontRenderer.func_78256_a(experienceString);
            fontRenderer.func_78276_b(experienceString, recipeWidth - stringWidth, 0, Color.gray.getRGB());
        }
    }
}

