/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.furnace;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.plugins.vanilla.furnace.SmeltingRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public final class SmeltingRecipeMaker {
    private SmeltingRecipeMaker() {
    }

    public static List<SmeltingRecipe> getFurnaceRecipes(IJeiHelpers helpers) {
        IStackHelper stackHelper = helpers.getStackHelper();
        FurnaceRecipes furnaceRecipes = FurnaceRecipes.func_77602_a();
        Map smeltingMap = furnaceRecipes.func_77599_b();
        Object2ObjectOpenCustomHashMap outputMap = new Object2ObjectOpenCustomHashMap(smeltingMap.size(), (Hash.Strategy)new Hash.Strategy<ItemStack>(){

            public int hashCode(ItemStack o) {
                return (o.func_77973_b().hashCode() + 31) * o.func_190916_E();
            }

            public boolean equals(ItemStack a, ItemStack b) {
                if (a == null || b == null) {
                    return false;
                }
                return a.func_77973_b() == b.func_77973_b() && a.func_77960_j() == b.func_77960_j() && a.func_190916_E() == b.func_190916_E();
            }
        });
        ArrayList<SmeltingRecipe> recipes = new ArrayList<SmeltingRecipe>(smeltingMap.size());
        for (Map.Entry entry : smeltingMap.entrySet()) {
            ItemStack input = (ItemStack)entry.getKey();
            ItemStack output = (ItemStack)entry.getValue();
            outputMap.computeIfAbsent(output, k -> new ArrayList()).addAll(stackHelper.getSubtypes(input));
        }
        for (Map.Entry entry : outputMap.entrySet()) {
            recipes.add(new SmeltingRecipe((List)entry.getValue(), (ItemStack)entry.getKey()));
        }
        return recipes;
    }
}

