/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.search.IElementSearch;
import mezz.jei.search.PrefixInfo;
import mezz.jei.search.TokenInfo;
import mezz.jei.util.Log;
import net.minecraft.util.NonNullList;

public class ElementSearchLowMem
implements IElementSearch {
    private final NonNullList<IIngredientListElement<?>> elementInfoList = NonNullList.func_191196_a();

    @Override
    public Set<IIngredientListElement<?>> getSearchResults(TokenInfo tokenInfo) {
        String token = tokenInfo.token;
        if (token.isEmpty()) {
            return Collections.emptySet();
        }
        PrefixInfo prefixInfo = tokenInfo.prefixInfo;
        return this.elementInfoList.stream().filter(elementInfo -> ElementSearchLowMem.matches(token, prefixInfo, elementInfo)).collect(Collectors.toSet());
    }

    private static boolean matches(String word, PrefixInfo prefixInfo, IIngredientListElement<?> elementInfo) {
        if (elementInfo.isVisible()) {
            Collection<String> strings = prefixInfo.getStrings(elementInfo);
            for (String string : strings) {
                if (!string.contains(word)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void add(IIngredientListElement<?> ingredient) {
        this.elementInfoList.add(ingredient);
    }

    @Override
    public void addAll(NonNullList<IIngredientListElement> ingredients) {
        for (IIngredientListElement ingredient : ingredients) {
            this.add(ingredient);
        }
    }

    public List<IIngredientListElement<?>> getAllIngredients() {
        return Collections.unmodifiableList(this.elementInfoList);
    }

    @Override
    public void logStatistics() {
        Log.get().info("ElementSearchLowMem Element Count: {}", (Object)this.elementInfoList.size());
    }
}

