/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.PrintWriter;
import java.util.Set;
import mezz.jei.collect.SetMultiMap;
import mezz.jei.search.GeneralizedSuffixTree;
import mezz.jei.search.ISearchStorage;

public class LimitedStringStorage<T>
implements ISearchStorage<T> {
    private final SetMultiMap<String, T> multiMap = new SetMultiMap(ReferenceOpenHashSet::new);
    private final GeneralizedSuffixTree<Set<T>> generalizedSuffixTree = new GeneralizedSuffixTree();

    @Override
    public void getSearchResults(String token, Set<T> results) {
        ReferenceOpenHashSet intermediateResults = new ReferenceOpenHashSet();
        this.generalizedSuffixTree.getSearchResults(token, (Set<Set<T>>)intermediateResults);
        for (Set set : intermediateResults) {
            results.addAll(set);
        }
    }

    @Override
    public void getAllElements(Set<T> results) {
        this.multiMap.valueStream().forEach(results::add);
    }

    @Override
    public void put(String key, T value) {
        boolean isNewKey = !this.multiMap.containsKey(key);
        this.multiMap.put(key, value);
        if (isNewKey) {
            Set set = (Set)this.multiMap.get(key);
            this.generalizedSuffixTree.put(key, set);
        }
    }

    @Override
    public String statistics() {
        return "LimitedStringStorage: " + this.generalizedSuffixTree.statistics();
    }

    @Override
    public void printTree(PrintWriter out, boolean includeSuffixLinks) {
        this.generalizedSuffixTree.printTree(out, includeSuffixLinks);
    }
}

