/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.startup.StackHelper;
import net.minecraft.item.ItemStack;

public class IngredientSet<V>
extends AbstractSet<V> {
    private final Function<V, String> uidGenerator;
    private final Map<String, V> ingredients;

    public static <V> IngredientSet<V> create(IIngredientType<V> ingredientType, IIngredientHelper<V> ingredientHelper) {
        Function<Object, String> uidGenerator;
        if (ingredientType == VanillaTypes.ITEM) {
            StackHelper stackHelper = Internal.getStackHelper();
            uidGenerator = stack -> stackHelper.getUniqueIdentifierForStack((ItemStack)stack, StackHelper.UidMode.FULL);
        } else {
            uidGenerator = ingredientHelper::getUniqueId;
        }
        return new IngredientSet<Object>(uidGenerator);
    }

    private IngredientSet(Function<V, String> uidGenerator) {
        this.uidGenerator = uidGenerator;
        this.ingredients = new Object2ObjectLinkedOpenHashMap();
    }

    @Override
    public boolean add(V v) {
        String uid = this.uidGenerator.apply(v);
        return this.ingredients.put(uid, v) == null;
    }

    @Override
    public boolean remove(Object o) {
        String uid = this.uidGenerator.apply(o);
        return this.ingredients.remove(uid) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c instanceof IngredientSet) {
            return super.removeAll(c);
        }
        Objects.requireNonNull(c);
        boolean modified = false;
        for (Object aC : c) {
            modified |= this.remove(aC);
        }
        return modified;
    }

    @Override
    public boolean contains(Object o) {
        String uid = this.uidGenerator.apply(o);
        return this.ingredients.containsKey(uid);
    }

    @Nullable
    public V getByUid(String uid) {
        return this.ingredients.get(uid);
    }

    @Override
    public void clear() {
        this.ingredients.clear();
    }

    @Override
    public Iterator<V> iterator() {
        return this.ingredients.values().iterator();
    }

    @Override
    public int size() {
        return this.ingredients.size();
    }
}

