/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.core.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.core.LibrarianLog;
import com.teamwizardry.librarianlib.core.common.LibLibConfig;
import com.teamwizardry.librarianlib.core.common.OwnershipHandler;
import com.teamwizardry.librarianlib.features.base.IExtraVariantHolder;
import com.teamwizardry.librarianlib.features.base.IModelGenerator;
import com.teamwizardry.librarianlib.features.base.IVariantHolder;
import com.teamwizardry.librarianlib.features.base.block.IBlockColorProvider;
import com.teamwizardry.librarianlib.features.base.block.IModBlockProvider;
import com.teamwizardry.librarianlib.features.base.item.IItemColorProvider;
import com.teamwizardry.librarianlib.features.base.item.IModItemProvider;
import com.teamwizardry.librarianlib.features.base.item.ISpecialModelProvider;
import com.teamwizardry.librarianlib.features.helpers.VariantHelper;
import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.kotlin.JsonMaker;
import com.teamwizardry.librarianlib.features.methodhandles.MethodHandleHelper;
import com.teamwizardry.librarianlib.features.utilities.FileDsl;
import com.teamwizardry.librarianlib.features.utilities.JsonGenerationUtilsKt;
import com.teamwizardry.librarianlib.features.utilities.JsonUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="librarianlib")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0007J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0014H\u0003J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020\u0018H\u0007J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0007J-\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00112\u000e\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050%2\u0006\u0010&\u001a\u00020\tH\u0007\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010 \u001a\u00020)H\u0007J\u0010\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u0011H\u0003J\u0018\u0010,\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0005H\u0007J3\u0010,\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020-2\u001d\u0010/\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020201\u0012\u0004\u0012\u00020\u001800\u00a2\u0006\u0002\b3H\u0087\b\u00f8\u0001\u0000J\b\u00104\u001a\u00020\tH\u0007JA\u00105\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u0002062/\u00107\u001a+\u0012\u0013\u0012\u001108\u00a2\u0006\f\b9\u0012\b\b\u001c\u0012\u0004\b\b(:\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020\u00140;\u0018\u000100H\u0007JR\u00105\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u0002062\u001d\u0010=\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020801\u0012\u0004\u0012\u00020\u001800\u00a2\u0006\u0002\b32\u001d\u0010/\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020801\u0012\u0004\u0012\u00020\u001800\u00a2\u0006\u0002\b3H\u0087\b\u00f8\u0001\u0000J\u000e\u0010>\u001a\u00020\u00052\u0006\u0010+\u001a\u00020-J\u0018\u0010?\u001a\u00020\u00052\u0006\u0010@\u001a\u0002022\u0006\u0010A\u001a\u00020BH\u0007J\u000e\u0010C\u001a\u00020\u00182\u0006\u0010D\u001a\u00020\u0005R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00140\u00130\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006E"}, d2={"Lcom/teamwizardry/librarianlib/core/client/ModelHandler;", "", "<init>", "()V", "serialize", "", "el", "Lcom/google/gson/JsonElement;", "debug", "", "modName", "namePad", "getNamePad", "()Ljava/lang/String;", "variantCache", "Ljava/util/HashMap;", "", "Lcom/teamwizardry/librarianlib/features/base/IVariantHolder;", "resourceLocations", "", "Lnet/minecraft/client/renderer/block/model/ModelResourceLocation;", "getResourceLocations", "()Ljava/util/Map;", "registerVariantHolder", "", "holder", "getResource", "modId", "name", "addToCachedLocations", "mrl", "preInit", "e", "Lnet/minecraftforge/client/event/ModelRegistryEvent;", "init", "registerModels", "variants", "", "extra", "(Lcom/teamwizardry/librarianlib/features/base/IVariantHolder;[Ljava/lang/String;Z)V", "onModelBake", "Lnet/minecraftforge/client/event/ModelBakeEvent;", "shouldGenItemJson", "provider", "generateItemJson", "Lcom/teamwizardry/librarianlib/features/base/item/IModItemProvider;", "variant", "modelFiles", "Lkotlin/Function1;", "Lcom/teamwizardry/librarianlib/features/utilities/FileDsl;", "Lnet/minecraft/item/Item;", "Lkotlin/ExtensionFunctionType;", "shouldGenerateAnyJson", "generateBlockJson", "Lcom/teamwizardry/librarianlib/features/base/block/IModBlockProvider;", "mapper", "Lnet/minecraft/block/Block;", "Lkotlin/ParameterName;", "block", "", "Lnet/minecraft/block/state/IBlockState;", "blockstateFiles", "getNameForItemProvider", "getKey", "item", "meta", "", "log", "text", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nModelHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelHandler.kt\ncom/teamwizardry/librarianlib/core/client/ModelHandler\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,380:1\n286#1,11:396\n317#1,17:407\n335#1,4:428\n339#1,3:435\n342#1:441\n344#1,21:444\n381#2,7:381\n381#2,7:388\n1053#3:395\n1557#3:424\n1628#3,3:425\n1755#3,3:432\n774#3:438\n865#3,2:439\n1863#3,2:442\n1557#3:465\n1628#3,3:466\n1557#3:469\n1628#3,3:470\n1755#3,3:473\n774#3:476\n865#3,2:477\n1863#3,2:479\n*S KotlinDebug\n*F\n+ 1 ModelHandler.kt\ncom/teamwizardry/librarianlib/core/client/ModelHandler\n*L\n278#1:396,11\n305#1:407,17\n305#1:428,4\n305#1:435,3\n305#1:441\n305#1:444,21\n81#1:381,7\n88#1:388,7\n97#1:395\n305#1:424\n305#1:425,3\n305#1:432,3\n305#1:438\n305#1:439,2\n305#1:442,2\n333#1:465\n333#1:466,3\n336#1:469\n336#1:470,3\n338#1:473,3\n341#1:476\n341#1:477,2\n342#1:479,2\n*E\n"})
public final class ModelHandler {
    @NotNull
    public static final ModelHandler INSTANCE = new ModelHandler();
    private static final boolean debug = LibrarianLib.DEV_ENVIRONMENT;
    @NotNull
    private static String modName = "";
    @NotNull
    private static final HashMap<String, List<IVariantHolder>> variantCache = new HashMap();
    @NotNull
    private static final Map<String, Map<String, ModelResourceLocation>> resourceLocations = new LinkedHashMap();

    private ModelHandler() {
    }

    @NotNull
    public final String serialize(@NotNull JsonElement el) {
        Intrinsics.checkNotNullParameter((Object)el, (String)"el");
        return LibLibConfig.getPrettyJsonSerialization() ? JsonMaker.serialize(el) : "" + el + '\n';
    }

    @NotNull
    public final String getNamePad() {
        return CommonUtilMethods.times(" ", modName.length());
    }

    @NotNull
    public final Map<String, Map<String, ModelResourceLocation>> getResourceLocations() {
        return resourceLocations;
    }

    @JvmStatic
    public static final void registerVariantHolder(@NotNull IVariantHolder holder) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Object object2 = Loader.instance().activeModContainer();
        if (object2 == null || (object2 = object2.getModId()) == null) {
            return;
        }
        Object name = object2;
        Map $this$getOrPut$iv = variantCache;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(name, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(holder);
    }

    @Nullable
    public final ModelResourceLocation getResource(@NotNull String modId, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, ModelResourceLocation> map = resourceLocations.get(modId);
        return map != null ? map.get(name) : null;
    }

    /*
     * WARNING - void declaration
     */
    @SideOnly(value=Side.CLIENT)
    private final ModelResourceLocation addToCachedLocations(String name, ModelResourceLocation mrl) {
        Object object;
        void $this$getOrPut$iv;
        Map<String, Map<String, ModelResourceLocation>> map = resourceLocations;
        String key$iv = modName;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new HashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((Map)object).put(name, mrl);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    @JvmStatic
    public static final void preInit(@NotNull ModelRegistryEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        for (Map.Entry entry : ((Map)variantCache).entrySet()) {
            String modid = (String)entry.getKey();
            List holders = (List)entry.getValue();
            modName = modid;
            INSTANCE.log(modName + " | Registering models");
            Iterable $this$sortedBy$iv = holders;
            boolean $i$f$sortedBy = false;
            for (IVariantHolder holder : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    IVariantHolder it = (IVariantHolder)a;
                    boolean bl = false;
                    char c = (char)(255 - it.getVariants().length);
                    String string = it instanceof IModBlockProvider ? "b" : 'I' + (it instanceof IModItemProvider ? CommonUtilMethods.getKey((IForgeRegistryEntry)((IModItemProvider)it).getProvidedItem()).func_110623_a() : "");
                    it = (IVariantHolder)b;
                    Comparable comparable = (Comparable)((Object)(c + string));
                    bl = false;
                    c = (char)(255 - it.getVariants().length);
                    string = it instanceof IModBlockProvider ? "b" : 'I' + (it instanceof IModItemProvider ? CommonUtilMethods.getKey((IForgeRegistryEntry)((IModItemProvider)it).getProvidedItem()).func_110623_a() : "");
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)(c + string))));
                }
            })) {
                INSTANCE.registerModels(holder);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void init() {
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        for (Map.Entry entry : ((Map)variantCache).entrySet()) {
            String modid = (String)entry.getKey();
            List holders = (List)entry.getValue();
            modName = modid;
            boolean flag = false;
            for (IVariantHolder holder : holders) {
                Item[] itemArray;
                Function2<ItemStack, Integer, Integer> color;
                if (holder instanceof IItemColorProvider && holder instanceof IModItemProvider && (color = ((IItemColorProvider)holder).getItemColorFunction()) != null) {
                    if (!flag) {
                        this.log(modName + " | Registering colors");
                        flag = true;
                    }
                    this.log(this.getNamePad() + " | Registering item color for " + CommonUtilMethods.getKey((IForgeRegistryEntry)((IModItemProvider)holder).getProvidedItem()).func_110623_a());
                    itemArray = new Item[]{((IModItemProvider)holder).getProvidedItem()};
                    itemColors.func_186730_a((arg_0, arg_1) -> ModelHandler.init$lambda$3(color, arg_0, arg_1), itemArray);
                }
                if (!(holder instanceof IModBlockProvider) || !(holder instanceof IBlockColorProvider) || (color = ((IBlockColorProvider)holder).getBlockColorFunction()) == null) continue;
                if (!flag) {
                    this.log(modName + " | Registering colors");
                    flag = true;
                }
                this.log(this.getNamePad() + " | Registering block color for " + CommonUtilMethods.getKey((IForgeRegistryEntry)((IBlockColorProvider)holder).getProvidedBlock()).func_110623_a());
                itemArray = new Block[]{((IBlockColorProvider)holder).getProvidedBlock()};
                blockColors.func_186722_a((arg_0, arg_1, arg_2, arg_3) -> ModelHandler.init$lambda$4(color, arg_0, arg_1, arg_2, arg_3), (Block[])itemArray);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void registerModels(@NotNull IVariantHolder holder) {
        Function1<ItemStack, ModelResourceLocation> meshDef;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (holder instanceof IExtraVariantHolder) {
            this.registerModels(holder, ((IExtraVariantHolder)holder).getExtraVariants(), true);
        }
        if (holder instanceof IModBlockProvider) {
            Function1<Block, Map<IBlockState, ModelResourceLocation>> mapper = ((IModBlockProvider)holder).getStateMapper();
            if (mapper != null) {
                ModelLoader.setCustomStateMapper((Block)((IModBlockProvider)holder).getProvidedBlock(), arg_0 -> ModelHandler.registerModels$lambda$5(mapper, arg_0));
            }
            if (this.shouldGenerateAnyJson()) {
                this.generateBlockJson((IModBlockProvider)holder, mapper);
            }
        }
        if (holder instanceof IModItemProvider && (meshDef = ((IModItemProvider)holder).getMeshDefinition()) != null) {
            ModelLoader.setCustomMeshDefinition((Item)((IModItemProvider)holder).getProvidedItem(), arg_0 -> ModelHandler.registerModels$lambda$6(meshDef, arg_0));
            return;
        }
        this.registerModels(holder, holder.getVariants(), false);
    }

    @SideOnly(value=Side.CLIENT)
    public final void registerModels(@NotNull IVariantHolder holder, @NotNull String[] variants2, boolean extra) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)variants2, (String)"variants");
        if (holder instanceof IModItemProvider) {
            Item item = ((IModItemProvider)holder).getProvidedItem();
            int n = variants2.length;
            for (int i = 0; i < n; ++i) {
                ModelResourceLocation modelResourceLocation;
                int index = i;
                String variantName = variants2[i];
                String variant = VariantHelper.toSnakeCase(variantName);
                if (index == 0) {
                    String print = this.getNamePad() + " | Registering ";
                    if (!Intrinsics.areEqual((Object)variant, (Object)CommonUtilMethods.getKey((IForgeRegistryEntry)item).func_110623_a()) || variants2.length != 1 || extra) {
                        print = print + (extra ? "extra " : "") + "variant" + (variants2.length == 1 ? "" : "s") + " of ";
                    }
                    print = print + (item instanceof IModBlockProvider ? "block" : "item");
                    print = print + ' ' + CommonUtilMethods.getKey((IForgeRegistryEntry)item).func_110623_a();
                    this.log(print);
                }
                if (holder instanceof ISpecialModelProvider && ((ISpecialModelProvider)holder).getSpecialModel(index) != null) {
                    this.log(this.getNamePad() + " |  Variant #" + (index + 1) + ": " + variant + " - SPECIAL");
                    continue;
                }
                if (!Intrinsics.areEqual((Object)variant, (Object)CommonUtilMethods.getKey((IForgeRegistryEntry)item).func_110623_a()) || variants2.length != 1) {
                    this.log(this.getNamePad() + " |  Variant #" + (index + 1) + ": " + variant);
                }
                if (this.shouldGenItemJson(holder)) {
                    this.generateItemJson((IModItemProvider)holder, variant);
                }
                ModelResourceLocation model = new ModelResourceLocation(StringsKt.contains$default((CharSequence)variant, (char)':', (boolean)false, (int)2, null) ? variant : modName + ':' + variant, "inventory");
                if (!extra) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)index, (ModelResourceLocation)model);
                    modelResourceLocation = this.addToCachedLocations(ModelHandler.getKey(item, index), model);
                    continue;
                }
                ResourceLocation[] resourceLocationArray = new ResourceLocation[]{model};
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])resourceLocationArray);
                modelResourceLocation = this.addToCachedLocations(variantName, model);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    @JvmStatic
    public static final void onModelBake(@NotNull ModelBakeEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String[] stringArray = new String[]{"customModels"};
        Function0<Object> customModelGetter = MethodHandleHelper.wrapperForStaticGetter(ModelLoader.class, stringArray);
        Object object = customModelGetter.invoke();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.Pair<net.minecraftforge.registries.IRegistryDelegate<net.minecraft.item.Item>, kotlin.Int>, net.minecraft.client.renderer.block.model.ModelResourceLocation>");
        Map customModels = TypeIntrinsics.asMutableMap((Object)object);
        for (Map.Entry entry : ((Map)variantCache).entrySet()) {
            String modid = (String)entry.getKey();
            List holders = (List)entry.getValue();
            modName = modid;
            boolean hasRegisteredAny = false;
            for (IVariantHolder holder : holders) {
                if (!(holder instanceof ISpecialModelProvider)) continue;
                Item item = ((ISpecialModelProvider)holder).getProvidedItem();
                boolean flag = false;
                String[] stringArray2 = holder.getVariants();
                int n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    int index = i;
                    String variant = stringArray2[i];
                    IBakedModel model = ((ISpecialModelProvider)holder).getSpecialModel(index);
                    if (model == null) continue;
                    if (!hasRegisteredAny) {
                        INSTANCE.log(modName + " | Registering special models");
                        hasRegisteredAny = true;
                    }
                    if (!flag) {
                        String print = INSTANCE.getNamePad() + " | Applying special model rules for ";
                        print = print + (item instanceof IModBlockProvider ? "block " : "item ");
                        print = print + CommonUtilMethods.getKey((IForgeRegistryEntry)item).func_110623_a();
                        INSTANCE.log(print);
                        flag = true;
                    }
                    ModelResourceLocation mrl = new ModelResourceLocation(new ResourceLocation(modName, variant).toString(), "inventory");
                    INSTANCE.log(INSTANCE.getNamePad() + " | Special model for variant " + index + " - " + variant + " applied");
                    e.getModelRegistry().func_82595_a((Object)mrl, (Object)model);
                    customModels.put(TuplesKt.to((Object)item.delegate, (Object)index), mrl);
                    INSTANCE.addToCachedLocations(variant, mrl);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private final boolean shouldGenItemJson(IVariantHolder provider) {
        JsonElement marker;
        if (!this.shouldGenerateAnyJson()) {
            return false;
        }
        if (!(provider instanceof IModBlockProvider) && !(provider instanceof IModItemProvider)) {
            return false;
        }
        IModBlockProvider iModBlockProvider = provider instanceof IModBlockProvider ? (IModBlockProvider)provider : null;
        IForgeRegistryEntry.Impl entry = iModBlockProvider != null && (iModBlockProvider = iModBlockProvider.getProvidedBlock()) != null ? (IForgeRegistryEntry.Impl)iModBlockProvider : (IForgeRegistryEntry.Impl)((IModItemProvider)provider).getProvidedItem();
        String statePath = JsonGenerationUtilsKt.getPathForBaseBlockstate((IForgeRegistryEntry)entry);
        File file = new File(statePath);
        if (!file.exists()) {
            return true;
        }
        JsonElement json = null;
        try {
            File file2 = file;
            Charset charset = Charsets.UTF_8;
            json = new JsonParser().parse((Reader)new InputStreamReader((InputStream)new FileInputStream(file2), charset));
        }
        catch (Throwable t) {
            return true;
        }
        boolean isForge = false;
        if (json.isJsonObject() && json.getAsJsonObject().has("forge_marker") && (marker = json.getAsJsonObject().get("forge_marker")).isJsonPrimitive() && marker.getAsJsonPrimitive().isNumber()) {
            boolean bl = isForge = marker.getAsInt() != 0;
        }
        if (isForge) {
            StringBuilder stringBuilder = new StringBuilder().append(this.getNamePad()).append(" | Assuming forge override for ");
            ResourceLocation resourceLocation = entry.getRegistryName();
            Intrinsics.checkNotNull((Object)resourceLocation);
            this.log(stringBuilder.append(resourceLocation.func_110623_a()).append(" item model").toString());
        }
        return !isForge;
    }

    @SideOnly(value=Side.CLIENT)
    public final void generateItemJson(@NotNull IModItemProvider holder, @NotNull String variant) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        if (holder instanceof IModelGenerator && ((IModelGenerator)((Object)holder)).generateMissingItem(holder, variant)) {
            return;
        }
        ModelHandler this_$iv = this;
        boolean $i$f$generateItemJson = false;
        FileDsl<Item> fileDsl = new FileDsl<Item>((IForgeRegistryEntry)holder.getProvidedItem(), null, 2, null);
        FileDsl<Item> entry = fileDsl;
        boolean bl = false;
        entry.to(JsonGenerationUtilsKt.getPathForItemModel(entry, variant), (JsonElement)JsonGenerationUtilsKt.generateBaseItemModel$default(entry, variant, null, 4, null));
        Map<String, JsonElement> files$iv = fileDsl.getMap();
        for (Map.Entry entry2 : files$iv.entrySet()) {
            String path$iv = (String)entry2.getKey();
            JsonElement model$iv = (JsonElement)entry2.getValue();
            File file$iv = new File(path$iv);
            file$iv.getParentFile().mkdirs();
            if (!file$iv.createNewFile()) continue;
            FilesKt.writeText$default((File)file$iv, (String)this_$iv.serialize(model$iv), null, (int)2, null);
            this_$iv.log(this_$iv.getNamePad() + " | Creating " + file$iv.getName() + " for item model of " + this_$iv.getNameForItemProvider(holder));
            JsonGenerationUtilsKt.getGeneratedFiles().add(path$iv);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void generateItemJson(@NotNull IModItemProvider holder, @NotNull Function1<? super FileDsl<Item>, Unit> modelFiles) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter(modelFiles, (String)"modelFiles");
        boolean $i$f$generateItemJson = false;
        FileDsl fileDsl = new FileDsl((IForgeRegistryEntry)holder.getProvidedItem(), null, 2, null);
        modelFiles.invoke(fileDsl);
        Map<String, JsonElement> files = fileDsl.getMap();
        for (Map.Entry entry : files.entrySet()) {
            String path = (String)entry.getKey();
            JsonElement model = (JsonElement)entry.getValue();
            File file = new File(path);
            file.getParentFile().mkdirs();
            if (!file.createNewFile()) continue;
            FilesKt.writeText$default((File)file, (String)this.serialize(model), null, (int)2, null);
            this.log(this.getNamePad() + " | Creating " + file.getName() + " for item model of " + this.getNameForItemProvider(holder));
            JsonGenerationUtilsKt.getGeneratedFiles().add(path);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final boolean shouldGenerateAnyJson() {
        return debug && LibLibConfig.getGenerateJson() && OwnershipHandler.INSTANCE.getDEV_OWNED().contains(modName);
    }

    /*
     * WARNING - void declaration
     */
    @SideOnly(value=Side.CLIENT)
    public final void generateBlockJson(@NotNull IModBlockProvider holder, @Nullable Function1<? super Block, ? extends Map<IBlockState, ? extends ModelResourceLocation>> mapper) {
        block19: {
            FileDsl<Block> fileDsl;
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            if (holder instanceof IModelGenerator && ((IModelGenerator)((Object)holder)).generateMissingBlockstate(holder, mapper)) {
                return;
            }
            ModelHandler this_$iv = this;
            boolean $i$f$generateBlockJson = false;
            FileDsl<Block> $this$generateBlockJson_u24lambda_u248 = fileDsl = new FileDsl<Block>((IForgeRegistryEntry)holder.getProvidedBlock(), null, 2, null);
            boolean bl = false;
            JsonGenerationUtilsKt.generateBaseBlockStates($this$generateBlockJson_u24lambda_u248, mapper);
            Map<String, JsonElement> files$iv = fileDsl.getMap();
            boolean flag$iv = false;
            for (Map.Entry<String, JsonElement> iterator2 : files$iv.entrySet()) {
                Iterable $this$any$iv$iv;
                List newVarsInFile$iv;
                List list;
                Object $this$map$iv$iv;
                JsonObject newVariants$iv;
                Object object;
                List varsInFile$iv;
                List list2;
                Object it$iv;
                Collection collection;
                File stateJson$iv;
                File file;
                String path$iv = iterator2.getKey();
                JsonElement model$iv = iterator2.getValue();
                if (!(model$iv instanceof JsonObject)) break block19;
                File stateFile$iv = new File(path$iv);
                stateFile$iv.getParentFile().mkdirs();
                try {
                    file = stateFile$iv;
                    Charset charset = Charsets.UTF_8;
                    file = new JsonParser().parse((Reader)new InputStreamReader((InputStream)new FileInputStream(file), charset)).getAsJsonObject();
                }
                catch (Throwable ignored$iv) {
                    flag$iv = true;
                    file = new JsonObject();
                }
                if ((stateJson$iv = file).size() != 0 && (stateJson$iv.has("multipart") || stateJson$iv.has("forge_marker") || ((JsonObject)model$iv).has("multipart") || ((JsonObject)model$iv).has("forge_marker"))) continue;
                JsonObject variants$iv = stateJson$iv.has("variants") ? stateJson$iv.get("variants").getAsJsonObject() : null;
                Object object2 = variants$iv;
                if (object2 != null && (object2 = object2.entrySet()) != null) {
                    void $this$mapTo$iv$iv$iv;
                    Iterable $this$map$iv$iv2 = (Iterable)object2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv$iv2;
                    Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv2, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                        Map.Entry entry = (Map.Entry)item$iv$iv$iv;
                        collection = destination$iv$iv$iv;
                        boolean bl2 = false;
                        collection.add((String)it$iv.getKey());
                    }
                    list2 = (List)destination$iv$iv$iv;
                } else {
                    list2 = varsInFile$iv = CollectionsKt.emptyList();
                }
                if ((object = (newVariants$iv = ((JsonObject)model$iv).has("variants") ? ((JsonObject)model$iv).get("variants").getAsJsonObject() : null)) != null && (object = object.entrySet()) != null) {
                    void $this$mapTo$iv$iv$iv;
                    $this$map$iv$iv = (Iterable)object;
                    boolean $i$f$map = false;
                    Iterable $i$f$mapTo = $this$map$iv$iv;
                    Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    it$iv = $this$mapTo$iv$iv$iv.iterator();
                    while (it$iv.hasNext()) {
                        void it$iv2;
                        Object item$iv$iv$iv = it$iv.next();
                        Map.Entry entry = (Map.Entry)item$iv$iv$iv;
                        collection = destination$iv$iv$iv;
                        boolean bl3 = false;
                        collection.add((String)it$iv2.getKey());
                    }
                    list = (List)destination$iv$iv$iv;
                } else {
                    list = newVarsInFile$iv = CollectionsKt.emptyList();
                }
                if (newVariants$iv != null && variants$iv != null) {
                    boolean bl2;
                    block20: {
                        $this$any$iv$iv = newVarsInFile$iv;
                        boolean $i$f$any = false;
                        if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv$iv : $this$any$iv$iv) {
                                String it$iv3 = (String)element$iv$iv;
                                boolean bl5 = false;
                                if (!(!varsInFile$iv.contains(it$iv3))) continue;
                                bl2 = true;
                                break block20;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                }
                if (newVariants$iv != null && variants$iv != null) {
                    void $this$forEach$iv$iv;
                    void $this$filterTo$iv$iv$iv;
                    Iterable $this$filter$iv$iv;
                    $this$any$iv$iv = varsInFile$iv;
                    boolean $i$f$filter = false;
                    $this$map$iv$iv = $this$filter$iv$iv;
                    Collection destination$iv$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
                        it$iv = (String)element$iv$iv$iv;
                        boolean bl6 = false;
                        if (!newVarsInFile$iv.contains(it$iv)) continue;
                        destination$iv$iv$iv.add(element$iv$iv$iv);
                    }
                    $this$filter$iv$iv = (List)destination$iv$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv$iv : $this$forEach$iv$iv) {
                        String it$iv4 = (String)element$iv$iv;
                        boolean bl7 = false;
                        JsonObject jsonObject = (JsonObject)model$iv;
                        String string = "variants." + it$iv4;
                        JsonElement jsonElement = variants$iv.get(it$iv4);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"get(...)");
                        JsonUtil.setObject(jsonObject, string, jsonElement);
                    }
                }
                FilesKt.writeText$default((File)stateFile$iv, (String)this_$iv.serialize(model$iv), null, (int)2, null);
                INSTANCE.log(this_$iv.getNamePad() + " | " + (flag$iv ? "Creating" : "Updating") + ' ' + stateFile$iv.getName() + " for blockstate of block " + CommonUtilMethods.getKey((IForgeRegistryEntry)holder.getProvidedBlock()).func_110623_a());
                JsonGenerationUtilsKt.getGeneratedFiles().add(path$iv);
                flag$iv = true;
            }
            if (flag$iv) {
                FileDsl<Block> fileDsl2;
                FileDsl<Block> $this$generateBlockJson_u24lambda_u249 = fileDsl2 = new FileDsl<Block>((IForgeRegistryEntry)holder.getProvidedBlock(), null, 2, null);
                boolean bl8 = false;
                $this$generateBlockJson_u24lambda_u249.to(JsonGenerationUtilsKt.getPathForBlockModel($this$generateBlockJson_u24lambda_u249), (JsonElement)JsonGenerationUtilsKt.generateBaseBlockModel($this$generateBlockJson_u24lambda_u249));
                Map<String, JsonElement> models$iv = fileDsl2.getMap();
                for (Map.Entry<String, JsonElement> entry : models$iv.entrySet()) {
                    String path$iv = entry.getKey();
                    JsonElement model$iv = entry.getValue();
                    File modelFile$iv = new File(path$iv);
                    modelFile$iv.getParentFile().mkdirs();
                    if (!modelFile$iv.createNewFile()) continue;
                    FilesKt.writeText$default((File)modelFile$iv, (String)this_$iv.serialize(model$iv), null, (int)2, null);
                    INSTANCE.log(this_$iv.getNamePad() + " | Creating " + modelFile$iv.getName() + " for block model of block " + CommonUtilMethods.getKey((IForgeRegistryEntry)holder.getProvidedBlock()).func_110623_a());
                    JsonGenerationUtilsKt.getGeneratedFiles().add(path$iv);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @SideOnly(value=Side.CLIENT)
    public final void generateBlockJson(@NotNull IModBlockProvider holder, @NotNull Function1<? super FileDsl<Block>, Unit> blockstateFiles, @NotNull Function1<? super FileDsl<Block>, Unit> modelFiles) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter(blockstateFiles, (String)"blockstateFiles");
        Intrinsics.checkNotNullParameter(modelFiles, (String)"modelFiles");
        boolean $i$f$generateBlockJson = false;
        FileDsl fileDsl = new FileDsl((IForgeRegistryEntry)holder.getProvidedBlock(), null, 2, null);
        blockstateFiles.invoke(fileDsl);
        Map<String, JsonElement> files = fileDsl.getMap();
        boolean flag = false;
        for (Map.Entry<String, JsonElement> iterator2 : files.entrySet()) {
            Iterable $this$any$iv;
            List newVarsInFile;
            List list;
            Object $this$map$iv;
            JsonObject newVariants;
            Object object;
            List varsInFile;
            List list2;
            Object it;
            Collection collection;
            File stateJson;
            File file;
            String path = iterator2.getKey();
            JsonElement model = iterator2.getValue();
            if (!(model instanceof JsonObject)) {
                return;
            }
            File stateFile = new File(path);
            stateFile.getParentFile().mkdirs();
            try {
                file = stateFile;
                Charset charset = Charsets.UTF_8;
                file = new JsonParser().parse((Reader)new InputStreamReader((InputStream)new FileInputStream(file), charset)).getAsJsonObject();
            }
            catch (Throwable ignored) {
                flag = true;
                file = new JsonObject();
            }
            if ((stateJson = file).size() != 0 && (stateJson.has("multipart") || stateJson.has("forge_marker") || ((JsonObject)model).has("multipart") || ((JsonObject)model).has("forge_marker"))) continue;
            JsonObject variants2 = stateJson.has("variants") ? stateJson.get("variants").getAsJsonObject() : null;
            Object object2 = variants2;
            if (object2 != null && (object2 = object2.entrySet()) != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv2 = (Iterable)object2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Map.Entry entry = (Map.Entry)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((String)it.getKey());
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = varsInFile = CollectionsKt.emptyList();
            }
            if ((object = (newVariants = ((JsonObject)model).has("variants") ? ((JsonObject)model).get("variants").getAsJsonObject() : null)) != null && (object = object.entrySet()) != null) {
                void $this$mapTo$iv$iv;
                $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable $i$f$mapTo = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                it = $this$mapTo$iv$iv.iterator();
                while (it.hasNext()) {
                    void it2;
                    Object item$iv$iv = it.next();
                    Map.Entry entry = (Map.Entry)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((String)it2.getKey());
                }
                list = (List)destination$iv$iv;
            } else {
                list = newVarsInFile = CollectionsKt.emptyList();
            }
            if (newVariants != null && variants2 != null) {
                boolean bl;
                block19: {
                    $this$any$iv = newVarsInFile;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it3 = (String)element$iv;
                            boolean bl2 = false;
                            if (!(!varsInFile.contains(it3))) continue;
                            bl = true;
                            break block19;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
            }
            if (newVariants != null && variants2 != null) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                $this$any$iv = varsInFile;
                boolean $i$f$filter = false;
                $this$map$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!newVarsInFile.contains(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it4 = (String)element$iv;
                    boolean bl = false;
                    JsonObject jsonObject = (JsonObject)model;
                    String string = "variants." + it4;
                    JsonElement jsonElement = variants2.get(it4);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"get(...)");
                    JsonUtil.setObject(jsonObject, string, jsonElement);
                }
            }
            FilesKt.writeText$default((File)stateFile, (String)this.serialize(model), null, (int)2, null);
            INSTANCE.log(this.getNamePad() + " | " + (flag ? "Creating" : "Updating") + ' ' + stateFile.getName() + " for blockstate of block " + CommonUtilMethods.getKey((IForgeRegistryEntry)holder.getProvidedBlock()).func_110623_a());
            JsonGenerationUtilsKt.getGeneratedFiles().add(path);
            flag = true;
        }
        if (flag) {
            FileDsl fileDsl2 = new FileDsl((IForgeRegistryEntry)holder.getProvidedBlock(), null, 2, null);
            modelFiles.invoke(fileDsl2);
            Map<String, JsonElement> models = fileDsl2.getMap();
            for (Map.Entry<String, JsonElement> entry : models.entrySet()) {
                String path = entry.getKey();
                JsonElement model = entry.getValue();
                File modelFile = new File(path);
                modelFile.getParentFile().mkdirs();
                if (!modelFile.createNewFile()) continue;
                FilesKt.writeText$default((File)modelFile, (String)this.serialize(model), null, (int)2, null);
                INSTANCE.log(this.getNamePad() + " | Creating " + modelFile.getName() + " for block model of block " + CommonUtilMethods.getKey((IForgeRegistryEntry)holder.getProvidedBlock()).func_110623_a());
                JsonGenerationUtilsKt.getGeneratedFiles().add(path);
            }
        }
    }

    @NotNull
    public final String getNameForItemProvider(@NotNull IModItemProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Item item = provider.getProvidedItem();
        return (item instanceof ItemBlock ? "block " : "item ") + CommonUtilMethods.getKey((IForgeRegistryEntry)item).func_110623_a();
    }

    @JvmStatic
    @NotNull
    public static final String getKey(@NotNull Item item, int meta) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return "i_" + item.getRegistryName() + '@' + meta;
    }

    public final void log(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (debug) {
            LibrarianLog.INSTANCE.info(text, new Object[0]);
        }
    }

    private static final int init$lambda$3(Function2 $tmp0, ItemStack p0, int p1) {
        return ((Number)$tmp0.invoke((Object)p0, (Object)p1)).intValue();
    }

    private static final int init$lambda$4(Function4 $tmp0, IBlockState p0, IBlockAccess p1, BlockPos p2, int p3) {
        return ((Number)$tmp0.invoke((Object)p0, (Object)p1, (Object)p2, (Object)p3)).intValue();
    }

    private static final Map registerModels$lambda$5(Function1 $tmp0, Block p0) {
        return (Map)$tmp0.invoke((Object)p0);
    }

    private static final ModelResourceLocation registerModels$lambda$6(Function1 $tmp0, ItemStack p0) {
        return (ModelResourceLocation)$tmp0.invoke((Object)p0);
    }
}

