/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.animator;

import com.teamwizardry.librarianlib.features.animator.AnimatableProperty;
import com.teamwizardry.librarianlib.features.animator.Animator;
import com.teamwizardry.librarianlib.features.animator.IAnimatable;
import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001f\b\u0011\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\tJ\u0010\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u001aH\u0004J\u000e\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u0002J\u0010\u00109\u001a\u00020:2\u0006\u00105\u001a\u00020\u001aH&J\b\u0010;\u001a\u00020:H\u0016J\u0015\u0010B\u001a\u00020:2\u0006\u0010C\u001a\u00020DH\u0000\u00a2\u0006\u0002\bEJ\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010H\u001a\u00020/J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00105\u001a\u00020\u001aJ\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00105\u001a\u00020\u001aJ\u0014\u0010I\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010J\u001a\u00020)J\f\u0010K\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0014\u0010L\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010C\u001a\u00020DR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R*\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00108F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0019\u0010\u0014R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u001a@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR\u0011\u0010#\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001dR\u001a\u0010%\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0012\"\u0004\b'\u0010\u0014R\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0011\u00108\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u0012R\u001a\u0010<\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u0012\"\u0004\b>\u0010\u0014R$\u0010?\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\u0012\"\u0004\bA\u0010\u0014R\u001e\u0010F\u001a\u00020)2\u0006\u0010\u0015\u001a\u00020)@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010+\u00a8\u0006M"}, d2={"Lcom/teamwizardry/librarianlib/features/animator/Animation;", "T", "", "target", "property", "Lcom/teamwizardry/librarianlib/features/animator/IAnimatable;", "<init>", "(Ljava/lang/Object;Lcom/teamwizardry/librarianlib/features/animator/IAnimatable;)V", "Lcom/teamwizardry/librarianlib/features/animator/AnimatableProperty;", "(Ljava/lang/Object;Lcom/teamwizardry/librarianlib/features/animator/AnimatableProperty;)V", "getTarget", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getProperty", "()Lcom/teamwizardry/librarianlib/features/animator/IAnimatable;", "useAbsoluteTime", "", "getUseAbsoluteTime", "()Z", "setUseAbsoluteTime", "(Z)V", "value", "isTimeRelative", "isTimeRelative$annotations", "()V", "setTimeRelative", "", "start", "getStart", "()F", "setStart", "(F)V", "duration", "getDuration", "setDuration", "end", "getEnd", "shouldReverse", "getShouldReverse", "setShouldReverse", "repeatCount", "", "getRepeatCount", "()I", "setRepeatCount", "(I)V", "completion", "Ljava/lang/Runnable;", "getCompletion", "()Ljava/lang/Runnable;", "setCompletion", "(Ljava/lang/Runnable;)V", "timeFraction", "time", "doesInvolveObject", "obj", "isInAnimator", "update", "", "complete", "terminated", "getTerminated", "setTerminated", "finished", "getFinished", "setFinished$LibrarianLib_Continuous_1_12_2", "onAddedToAnimator", "animator", "Lcom/teamwizardry/librarianlib/features/animator/Animator;", "onAddedToAnimator$LibrarianLib_Continuous_1_12_2", "_id", "get_id$LibrarianLib_Continuous_1_12_2", "fn", "repeat", "count", "reverseOnRepeat", "addTo", "LibrarianLib-Continuous-1.12.2"})
public abstract class Animation<T> {
    private final T target;
    @NotNull
    private final IAnimatable<T> property;
    private boolean useAbsoluteTime;
    private float start;
    private float duration;
    private boolean shouldReverse;
    private int repeatCount;
    @NotNull
    private Runnable completion;
    private boolean terminated;
    private boolean finished;
    private int _id;

    public Animation(T target, @NotNull IAnimatable<T> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        this.target = target;
        this.property = property;
        this.completion = Animation::completion$lambda$0;
        this._id = -1;
    }

    public final T getTarget() {
        return this.target;
    }

    @NotNull
    public final IAnimatable<T> getProperty() {
        return this.property;
    }

    @PublishedApi
    public Animation(@NotNull Object target, @NotNull AnimatableProperty<Object> property) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        this(target, (IAnimatable)property);
    }

    public final boolean getUseAbsoluteTime() {
        return this.useAbsoluteTime;
    }

    public final void setUseAbsoluteTime(boolean bl) {
        this.useAbsoluteTime = bl;
    }

    public final boolean isTimeRelative() {
        return !this.useAbsoluteTime;
    }

    public final void setTimeRelative(boolean value) {
        this.useAbsoluteTime = !value;
    }

    @Deprecated(message="Use `useAbsoluteTime`")
    public static /* synthetic */ void isTimeRelative$annotations() {
    }

    public final float getStart() {
        return this.start;
    }

    public final void setStart(float value) {
        if (this.isInAnimator()) {
            throw new IllegalStateException("Cannot change the start time of an animation once it has been added to an animator");
        }
        this.start = value;
    }

    public final float getDuration() {
        return this.duration;
    }

    public final void setDuration(float f) {
        this.duration = f;
    }

    public final float getEnd() {
        if (this.repeatCount < 0) {
            return Float.POSITIVE_INFINITY;
        }
        float duration = this.duration;
        if (this.shouldReverse) {
            duration *= (float)2;
        }
        if (this.repeatCount > 0) {
            duration *= (float)this.repeatCount;
        }
        return this.start + duration;
    }

    public final boolean getShouldReverse() {
        return this.shouldReverse;
    }

    public final void setShouldReverse(boolean bl) {
        this.shouldReverse = bl;
    }

    public final int getRepeatCount() {
        return this.repeatCount;
    }

    public final void setRepeatCount(int n) {
        this.repeatCount = n;
    }

    @NotNull
    public final Runnable getCompletion() {
        return this.completion;
    }

    public final void setCompletion(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"<set-?>");
        this.completion = runnable;
    }

    protected final float timeFraction(float time) {
        if (time < this.start) {
            return 0.0f;
        }
        if (time > this.getEnd()) {
            return this.shouldReverse ? 0.0f : 1.0f;
        }
        if (this.shouldReverse) {
            float f = (time - this.start) / this.duration % (float)2;
            if (f > 1.0f) {
                return CommonUtilMethods.clamp((float)2 - f, 0.0f, 1.0f);
            }
            return CommonUtilMethods.clamp(f, 0.0f, 1.0f);
        }
        float f = (time - this.start) / this.duration;
        if (this.repeatCount != 0 && this.repeatCount != 1) {
            f %= 1.0f;
        }
        return CommonUtilMethods.clamp(f, 0.0f, 1.0f);
    }

    public final boolean doesInvolveObject(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (this.target == obj) {
            return true;
        }
        return this.property.doesInvolve(this.target, obj);
    }

    public final boolean isInAnimator() {
        return this._id != -1;
    }

    public abstract void update(float var1);

    public void complete() {
        this.completion.run();
        this.finished = true;
    }

    public final boolean getTerminated() {
        return this.terminated;
    }

    public final void setTerminated(boolean bl) {
        this.terminated = bl;
    }

    public final boolean getFinished() {
        return this.finished;
    }

    public final void setFinished$LibrarianLib_Continuous_1_12_2(boolean bl) {
        this.finished = bl;
    }

    public final void onAddedToAnimator$LibrarianLib_Continuous_1_12_2(@NotNull Animator animator2) {
        Intrinsics.checkNotNullParameter((Object)animator2, (String)"animator");
        if (this.useAbsoluteTime) {
            this.setStart(this.start + animator2.getTime());
        }
        int n = animator2.getNextID$LibrarianLib_Continuous_1_12_2();
        animator2.setNextID$LibrarianLib_Continuous_1_12_2(n + 1);
        this._id = n;
    }

    public final int get_id$LibrarianLib_Continuous_1_12_2() {
        return this._id;
    }

    @NotNull
    public final Animation<T> completion(@NotNull Runnable fn) {
        Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
        this.completion = fn;
        return this;
    }

    @NotNull
    public final Animation<T> start(float time) {
        this.setStart(time);
        return this;
    }

    @NotNull
    public final Animation<T> duration(float time) {
        this.duration = time;
        return this;
    }

    @NotNull
    public final Animation<T> repeat(int count) {
        this.repeatCount = count;
        return this;
    }

    @NotNull
    public final Animation<T> reverseOnRepeat() {
        this.shouldReverse = true;
        return this;
    }

    @NotNull
    public final Animation<T> useAbsoluteTime() {
        this.useAbsoluteTime = true;
        return this;
    }

    @NotNull
    public final Animation<T> addTo(@NotNull Animator animator2) {
        Intrinsics.checkNotNullParameter((Object)animator2, (String)"animator");
        Animation[] animationArray = new Animation[]{this};
        animator2.add(animationArray);
        return this;
    }

    private static final void completion$lambda$0() {
    }
}

