/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.animator;

import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.AnimatorKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="librarianlib")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0007\u0018\u0000 62\u00020\u0001:\u00016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0019\u001a\u00020\u000eH\u0002J'\u0010\"\u001a\u00020#2\u001a\u0010\u001b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001d0$\"\u0006\u0012\u0002\b\u00030\u001d\u00a2\u0006\u0002\u0010%J\u000e\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u0001J'\u0010(\u001a\u00020#2\u001a\u0010\u001b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001d0$\"\u0006\u0012\u0002\b\u00030\u001d\u00a2\u0006\u0002\u0010%J\u0006\u0010)\u001a\u00020#J\r\u0010*\u001a\u00020#H\u0000\u00a2\u0006\u0002\b+J\b\u0010,\u001a\u00020#H\u0002J\u0017\u0010-\u001a\u00020#2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020#0/H\u0082\bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0018\u0010\tR\u000e\u0010\u001a\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00100\u001a\u000201X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105\u00a8\u00067"}, d2={"Lcom/teamwizardry/librarianlib/features/animator/Animator;", "", "<init>", "()V", "deletePastAnimations", "", "getDeletePastAnimations", "()Z", "setDeletePastAnimations", "(Z)V", "useWorldTicks", "getUseWorldTicks", "setUseWorldTicks", "value", "", "time", "getTime", "()F", "setTime", "(F)V", "speed", "getSpeed", "setSpeed", "addLock", "setAddLock", "partialTicks", "timeOffset", "animations", "", "Lcom/teamwizardry/librarianlib/features/animator/Animation;", "animationsToAdd", "", "animationsToRemove", "currentAnimations", "add", "", "", "([Lcom/teamwizardry/librarianlib/features/animator/Animation;)V", "removeAnimationsFor", "obj", "removeAnimations", "removeAll", "update", "update$LibrarianLib_Continuous_1_12_2", "updateCurrentAnimations", "performLocked", "block", "Lkotlin/Function0;", "nextID", "", "getNextID$LibrarianLib_Continuous_1_12_2", "()I", "setNextID$LibrarianLib_Continuous_1_12_2", "(I)V", "Companion", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nAnimator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Animator.kt\ncom/teamwizardry/librarianlib/features/animator/Animator\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,219:1\n176#1,4:228\n37#2,2:220\n13346#3,2:222\n1863#4,2:224\n1863#4,2:226\n967#4,7:232\n*S KotlinDebug\n*F\n+ 1 Animator.kt\ncom/teamwizardry/librarianlib/features/animator/Animator\n*L\n155#1:228,4\n73#1:220,2\n100#1:222,2\n115#1:224,2\n145#1:226,2\n172#1:232,7\n*E\n"})
public final class Animator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean deletePastAnimations;
    private boolean useWorldTicks;
    private float speed;
    private boolean addLock;
    private float timeOffset;
    @NotNull
    private final Set<Animation<?>> animations;
    @NotNull
    private final List<Animation<?>> animationsToAdd;
    @NotNull
    private final List<Animation<?>> animationsToRemove;
    @NotNull
    private final List<Animation<?>> currentAnimations;
    private int nextID;
    private static int worldTicks;
    private static int screenTicks;
    @NotNull
    private static final Set<Animator> animators;
    @JvmField
    @NotNull
    public static final Animator global;

    public Animator() {
        animators.add(this);
        this.deletePastAnimations = true;
        this.speed = 1.0f;
        this.timeOffset = this.partialTicks();
        Function1[] function1Array = new Function1[]{Animator::animations$lambda$0, Animator::animations$lambda$1};
        this.animations = SetsKt.sortedSetOf((Comparator)ComparisonsKt.compareBy((Function1[])function1Array), (Object[])new Animation[0]);
        this.animationsToAdd = new ArrayList();
        this.animationsToRemove = new ArrayList();
        this.currentAnimations = new ArrayList();
    }

    public final boolean getDeletePastAnimations() {
        return this.deletePastAnimations;
    }

    public final void setDeletePastAnimations(boolean bl) {
        this.deletePastAnimations = bl;
    }

    public final boolean getUseWorldTicks() {
        return this.useWorldTicks;
    }

    public final void setUseWorldTicks(boolean bl) {
        this.useWorldTicks = bl;
    }

    public final float getTime() {
        return this.partialTicks() * this.speed - this.timeOffset;
    }

    public final void setTime(float value) {
        this.timeOffset = this.partialTicks() * this.speed - value;
    }

    public final float getSpeed() {
        return this.speed;
    }

    public final void setSpeed(float value) {
        this.timeOffset = this.getTime() + this.partialTicks() * value;
        this.speed = value;
    }

    private final void setAddLock(boolean value) {
        this.addLock = value;
        if (!value) {
            Collection $this$toTypedArray$iv = this.animationsToAdd;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Animation[] animationArray = thisCollection$iv.toArray(new Animation[0]);
            this.add(Arrays.copyOf(animationArray, animationArray.length));
            this.animations.removeAll((Collection)this.animationsToRemove);
            this.animationsToAdd.clear();
            this.animationsToRemove.clear();
        }
    }

    private final float partialTicks() {
        return this.useWorldTicks ? Companion.getWorldPartialTicks() : Companion.getScreenPartialTicks();
    }

    public final void add(Animation<?> ... animations) {
        Intrinsics.checkNotNullParameter(animations, (String)"animations");
        if (this.addLock) {
            CollectionsKt.addAll((Collection)this.animationsToAdd, (Object[])animations);
        } else {
            Animation<?>[] $this$forEach$iv = animations;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Animation<?> element$iv;
                Animation<?> animation = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (animation.isInAnimator()) {
                    throw new IllegalArgumentException("Animation already added to animator");
                }
                animation.onAddedToAnimator$LibrarianLib_Continuous_1_12_2(this);
                this.animations.add(animation);
            }
        }
    }

    public final void removeAnimationsFor(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        List inlineRemove = new ArrayList();
        Iterable $this$forEach$iv = this.animations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Animation it = (Animation)element$iv;
            boolean bl = false;
            if (!it.doesInvolveObject(obj)) continue;
            boolean bl2 = this.addLock ? this.animationsToRemove.add(it) : inlineRemove.add(it);
        }
        if (!this.addLock) {
            this.animations.removeAll(inlineRemove);
        }
    }

    public final void removeAnimations(Animation<?> ... animations) {
        Intrinsics.checkNotNullParameter(animations, (String)"animations");
        boolean bl = this.addLock ? CollectionsKt.addAll((Collection)this.animationsToRemove, (Object[])animations) : CollectionsKt.removeAll((Collection)this.animations, (Object[])animations);
    }

    public final void removeAll() {
        if (this.addLock) {
            this.animationsToRemove.addAll((Collection)this.animations);
        } else {
            this.animations.clear();
        }
    }

    public final void update$LibrarianLib_Continuous_1_12_2() {
        this.updateCurrentAnimations();
        Iterable $this$forEach$iv = this.currentAnimations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Animation anim = (Animation)element$iv;
            boolean bl = false;
            anim.update(this.getTime());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateCurrentAnimations() {
        void $this$takeWhile$iv;
        float time = this.getTime();
        this.currentAnimations.clear();
        Object this_$iv = this;
        boolean $i$f$performLocked = false;
        ((Animator)this_$iv).setAddLock(true);
        boolean bl = false;
        if (this.deletePastAnimations) {
            this.animations.removeIf(arg_0 -> Animator.updateCurrentAnimations$lambda$7$lambda$6(arg_0 -> Animator.updateCurrentAnimations$lambda$7$lambda$5(time, arg_0), arg_0));
        }
        ((Animator)this_$iv).setAddLock(false);
        this_$iv = this.animations;
        List<Animation<?>> list = this.currentAnimations;
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            Animation it = (Animation)item$iv;
            boolean bl2 = false;
            if (!(it.getStart() <= time)) break;
            list$iv.add(item$iv);
        }
        list.addAll(list$iv);
    }

    private final void performLocked(Function0<Unit> block) {
        boolean $i$f$performLocked = false;
        this.setAddLock(true);
        block.invoke();
        this.setAddLock(false);
    }

    public final int getNextID$LibrarianLib_Continuous_1_12_2() {
        return this.nextID;
    }

    public final void setNextID$LibrarianLib_Continuous_1_12_2(int n) {
        this.nextID = n;
    }

    private static final Comparable animations$lambda$0(Animation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Float.valueOf(it.getStart());
    }

    private static final Comparable animations$lambda$1(Animation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.get_id$LibrarianLib_Continuous_1_12_2());
    }

    private static final boolean updateCurrentAnimations$lambda$7$lambda$5(float $time, Animation it) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getTerminated()) {
            it.setFinished$LibrarianLib_Continuous_1_12_2(true);
            bl = true;
        } else if (it.getEnd() < $time) {
            it.update($time);
            it.complete();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean updateCurrentAnimations$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final float getScreenPartialTicks() {
        return Companion.getScreenPartialTicks();
    }

    public static final float getWorldPartialTicks() {
        return Companion.getWorldPartialTicks();
    }

    @JvmStatic
    @SubscribeEvent
    public static final void renderTick(@NotNull TickEvent.RenderTickEvent e) {
        Companion.renderTick(e);
    }

    @JvmStatic
    @SubscribeEvent
    public static final void tick(@NotNull TickEvent.ClientTickEvent e) {
        Companion.tick(e);
    }

    static {
        Set set = Collections.newSetFromMap(new WeakHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(...)");
        animators = set;
        global = new Animator();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0017H\u0007R\u001a\u0010\u0004\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/teamwizardry/librarianlib/features/animator/Animator$Companion;", "", "<init>", "()V", "screenPartialTicks", "", "getScreenPartialTicks$annotations", "getScreenPartialTicks", "()F", "worldPartialTicks", "getWorldPartialTicks$annotations", "getWorldPartialTicks", "worldTicks", "", "screenTicks", "animators", "", "Lcom/teamwizardry/librarianlib/features/animator/Animator;", "renderTick", "", "e", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$RenderTickEvent;", "tick", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$ClientTickEvent;", "global", "LibrarianLib-Continuous-1.12.2"})
    @SourceDebugExtension(value={"SMAP\nAnimator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Animator.kt\ncom/teamwizardry/librarianlib/features/animator/Animator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,219:1\n1863#2,2:220\n*S KotlinDebug\n*F\n+ 1 Animator.kt\ncom/teamwizardry/librarianlib/features/animator/Animator$Companion\n*L\n204#1:220,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final float getScreenPartialTicks() {
            float f = screenTicks;
            Minecraft minecraft = Minecraft.func_71410_x();
            Intrinsics.checkNotNullExpressionValue((Object)minecraft, (String)"getMinecraft(...)");
            return f + AnimatorKt.getTimer((Minecraft)minecraft).field_194147_b;
        }

        @JvmStatic
        public static /* synthetic */ void getScreenPartialTicks$annotations() {
        }

        public final float getWorldPartialTicks() {
            float f;
            if (Minecraft.func_71410_x().func_147113_T()) {
                float f2 = worldTicks;
                Minecraft minecraft = Minecraft.func_71410_x();
                Intrinsics.checkNotNullExpressionValue((Object)minecraft, (String)"getMinecraft(...)");
                f = f2 + AnimatorKt.getRenderPartialTicksPaused(minecraft);
            } else {
                float f3 = worldTicks;
                Minecraft minecraft = Minecraft.func_71410_x();
                Intrinsics.checkNotNullExpressionValue((Object)minecraft, (String)"getMinecraft(...)");
                f = f3 + AnimatorKt.getTimer((Minecraft)minecraft).field_194147_b;
            }
            return f;
        }

        @JvmStatic
        public static /* synthetic */ void getWorldPartialTicks$annotations() {
        }

        @JvmStatic
        @SubscribeEvent
        public final void renderTick(@NotNull TickEvent.RenderTickEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Iterable $this$forEach$iv = animators;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Animator it = (Animator)element$iv;
                boolean bl = false;
                it.update$LibrarianLib_Continuous_1_12_2();
            }
        }

        @JvmStatic
        @SubscribeEvent
        public final void tick(@NotNull TickEvent.ClientTickEvent e) {
            int n;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!Minecraft.func_71410_x().func_147113_T()) {
                n = worldTicks;
                worldTicks = n + 1;
            }
            n = screenTicks;
            screenTicks = n + 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

