/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.animator.animations;

import com.teamwizardry.librarianlib.features.animator.AnimatableProperty;
import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.Easing;
import com.teamwizardry.librarianlib.features.animator.IAnimatable;
import com.teamwizardry.librarianlib.features.animator.Lerper;
import com.teamwizardry.librarianlib.features.animator.LerperHandler;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\nB\u001f\b\u0011\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0004\b\u0007\u0010\fJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001b\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\"\u001a\u00020\u0002H\u0007\u00a2\u0006\u0002\b\rJ\u001b\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\"\u001a\u00020\u0002H\u0007\u00a2\u0006\u0002\b\u0012J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0015\u001a\u00020\u0016R\u001a\u0010\r\u001a\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/teamwizardry/librarianlib/features/animator/animations/BasicAnimation;", "T", "", "Lcom/teamwizardry/librarianlib/features/animator/Animation;", "target", "property", "Lcom/teamwizardry/librarianlib/features/animator/IAnimatable;", "<init>", "(Ljava/lang/Object;Lcom/teamwizardry/librarianlib/features/animator/IAnimatable;)V", "", "(Ljava/lang/Object;Ljava/lang/String;)V", "Lcom/teamwizardry/librarianlib/features/animator/AnimatableProperty;", "(Ljava/lang/Object;Lcom/teamwizardry/librarianlib/features/animator/AnimatableProperty;)V", "from", "getFrom", "()Ljava/lang/Object;", "setFrom", "(Ljava/lang/Object;)V", "to", "getTo", "setTo", "easing", "Lcom/teamwizardry/librarianlib/features/animator/Easing;", "getEasing", "()Lcom/teamwizardry/librarianlib/features/animator/Easing;", "setEasing", "(Lcom/teamwizardry/librarianlib/features/animator/Easing;)V", "lerper", "Lcom/teamwizardry/librarianlib/features/animator/Lerper;", "update", "", "time", "", "fromValue", "value", "toValue", "ease", "LibrarianLib-Continuous-1.12.2"})
public final class BasicAnimation<T>
extends Animation<T> {
    @NotNull
    private Object from;
    @NotNull
    private Object to;
    @NotNull
    private Easing easing;
    @NotNull
    private Lerper<Object> lerper;

    public BasicAnimation(@NotNull T target, @NotNull IAnimatable<T> property) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        super(target, property);
        this.from = property.get(target);
        this.to = property.get(target);
        this.easing = Easing.linear;
        this.lerper = LerperHandler.INSTANCE.getLerperOrError(property.getType());
    }

    public BasicAnimation(@NotNull T target, @NotNull String property) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        this(target, AnimatableProperty.Companion.get(target.getClass(), property));
    }

    @PublishedApi
    public BasicAnimation(@NotNull T target, @NotNull AnimatableProperty<T> property) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        this(target, (IAnimatable)property);
    }

    @NotNull
    public final Object getFrom() {
        return this.from;
    }

    public final void setFrom(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
        this.from = object;
    }

    @NotNull
    public final Object getTo() {
        return this.to;
    }

    public final void setTo(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
        this.to = object;
    }

    @NotNull
    public final Easing getEasing() {
        return this.easing;
    }

    public final void setEasing(@NotNull Easing easing) {
        Intrinsics.checkNotNullParameter((Object)easing, (String)"<set-?>");
        this.easing = easing;
    }

    @Override
    public void update(float time) {
        float progress = this.easing.invoke(this.timeFraction(time));
        Object object = this.lerper.lerp(this.from, this.to, progress);
        this.getProperty().set(this.getTarget(), object);
    }

    @JvmName(name="from")
    @NotNull
    public final BasicAnimation<T> from(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.from = value;
        return this;
    }

    @JvmName(name="to")
    @NotNull
    public final BasicAnimation<T> to(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.to = value;
        return this;
    }

    @NotNull
    public final BasicAnimation<T> ease(@NotNull Easing easing) {
        Intrinsics.checkNotNullParameter((Object)easing, (String)"easing");
        this.easing = easing;
        return this;
    }
}

