/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.animator.animations;

import com.teamwizardry.librarianlib.features.animator.AnimatableProperty;
import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.IAnimatable;
import com.teamwizardry.librarianlib.features.animator.Lerper;
import com.teamwizardry.librarianlib.features.animator.LerperHandler;
import com.teamwizardry.librarianlib.features.animator.animations.Keyframe;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\nB\u001f\b\u0011\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0004\b\u0007\u0010\fJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R0\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/teamwizardry/librarianlib/features/animator/animations/KeyframeAnimation;", "T", "", "Lcom/teamwizardry/librarianlib/features/animator/Animation;", "target", "property", "Lcom/teamwizardry/librarianlib/features/animator/IAnimatable;", "<init>", "(Ljava/lang/Object;Lcom/teamwizardry/librarianlib/features/animator/IAnimatable;)V", "", "(Ljava/lang/Object;Ljava/lang/String;)V", "Lcom/teamwizardry/librarianlib/features/animator/AnimatableProperty;", "(Ljava/lang/Object;Lcom/teamwizardry/librarianlib/features/animator/AnimatableProperty;)V", "value", "", "Lcom/teamwizardry/librarianlib/features/animator/animations/Keyframe;", "keyframes", "getKeyframes", "()[Lcom/teamwizardry/librarianlib/features/animator/animations/Keyframe;", "setKeyframes", "([Lcom/teamwizardry/librarianlib/features/animator/animations/Keyframe;)V", "_keyframes", "[Lcom/teamwizardry/librarianlib/features/animator/animations/Keyframe;", "lerper", "Lcom/teamwizardry/librarianlib/features/animator/Lerper;", "update", "", "time", "", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nKeyframeAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyframeAnimation.kt\ncom/teamwizardry/librarianlib/features/animator/animations/KeyframeAnimation\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,63:1\n6180#2,2:64\n2019#2,5:66\n1137#2,2:71\n*S KotlinDebug\n*F\n+ 1 KeyframeAnimation.kt\ncom/teamwizardry/librarianlib/features/animator/animations/KeyframeAnimation\n*L\n29#1:64,2\n39#1:66,5\n44#1:71,2\n*E\n"})
public final class KeyframeAnimation<T>
extends Animation<T> {
    @NotNull
    private Keyframe[] _keyframes;
    @NotNull
    private Lerper<Object> lerper;

    public KeyframeAnimation(@NotNull T target, @NotNull IAnimatable<T> property) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        super(target, property);
        this._keyframes = new Keyframe[0];
        this.lerper = LerperHandler.INSTANCE.getLerperOrError(property.getType());
    }

    public KeyframeAnimation(@NotNull T target, @NotNull String property) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        this(target, AnimatableProperty.Companion.get(target.getClass(), property));
    }

    @PublishedApi
    public KeyframeAnimation(@NotNull T target, @NotNull AnimatableProperty<T> property) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        this(target, (IAnimatable)property);
    }

    @NotNull
    public final Keyframe[] getKeyframes() {
        Keyframe[] keyframeArray = Arrays.copyOf(this._keyframes, this._keyframes.length);
        Intrinsics.checkNotNullExpressionValue((Object)keyframeArray, (String)"copyOf(...)");
        return keyframeArray;
    }

    public final void setKeyframes(@NotNull Keyframe[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.isInAnimator()) {
            throw new IllegalStateException("Cannot set keyframes after the animation has been added to an animator");
        }
        Keyframe[] keyframeArray = Arrays.copyOf(value, value.length);
        Intrinsics.checkNotNullExpressionValue((Object)keyframeArray, (String)"copyOf(...)");
        this._keyframes = keyframeArray;
        Object[] $this$sortBy$iv = this._keyframes;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.length > 1) {
            ArraysKt.sortWith((Object[])$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Keyframe it = (Keyframe)a;
                    boolean bl = false;
                    Comparable comparable = Float.valueOf(it.getTime());
                    it = (Keyframe)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Float.valueOf(it.getTime()));
                }
            });
        }
    }

    @Override
    public void update(float time) {
        Object $this$first$iv;
        Object $this$last$iv;
        float progress = this.timeFraction(time);
        try {
            Keyframe element$iv;
            block15: {
                $this$last$iv = this._keyframes;
                boolean $i$f$last = false;
                int n = ((Keyframe[])$this$last$iv).length + -1;
                if (0 <= n) {
                    do {
                        int index$iv = n--;
                        Keyframe it = element$iv = $this$last$iv[index$iv];
                        boolean bl = false;
                        if (it.getTime() <= progress) break block15;
                    } while (0 <= n);
                }
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            $this$last$iv = element$iv;
        }
        catch (NoSuchElementException e) {
            $this$last$iv = null;
        }
        Keyframe[] prev = $this$last$iv;
        try {
            Keyframe element$iv;
            block16: {
                $this$first$iv = this._keyframes;
                boolean $i$f$first = false;
                int n = ((Keyframe[])$this$first$iv).length;
                for (int i = 0; i < n; ++i) {
                    Keyframe it = element$iv = $this$first$iv[i];
                    boolean bl = false;
                    if (!(it.getTime() >= progress)) {
                        continue;
                    }
                    break block16;
                }
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            $this$first$iv = element$iv;
        }
        catch (NoSuchElementException e) {
            $this$first$iv = null;
        }
        Keyframe[] next = $this$first$iv;
        if (prev != null && next != null) {
            if (next.getTime() == prev.getTime()) {
                this.getProperty().set(this.getTarget(), next.getValue());
            } else {
                float partialProgress = next.getEasing().invoke((progress - prev.getTime()) / (next.getTime() - prev.getTime()));
                this.getProperty().set(this.getTarget(), this.lerper.lerp(prev.getValue(), next.getValue(), partialProgress));
            }
        } else if (next != null) {
            this.getProperty().set(this.getTarget(), next.getValue());
        } else if (prev != null) {
            this.getProperty().set(this.getTarget(), prev.getValue());
        }
    }
}

